/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.metadata;

import java.util.HashSet;
import java.util.Set;
import net.hydromatic.optiq.BuiltinMethod;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SetOpRel;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.TableFunctionRelBase;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelColumnMapping;
import org.eigenbase.rel.metadata.RelColumnOrigin;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelMdColumnOrigins {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltinMethod.COLUMN_ORIGIN.method, new RelMdColumnOrigins());

    private RelMdColumnOrigins() {
    }

    public Set<RelColumnOrigin> getColumnOrigins(AggregateRelBase rel, int iOutputColumn) {
        if (iOutputColumn < rel.getGroupCount()) {
            return this.invokeGetColumnOrigins(rel.getChild(), iOutputColumn);
        }
        AggregateCall call = rel.getAggCallList().get(iOutputColumn - rel.getGroupCount());
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (Integer iInput : call.getArgList()) {
            Set<RelColumnOrigin> inputSet = this.invokeGetColumnOrigins(rel.getChild(), iInput);
            if ((inputSet = this.createDerivedColumnOrigins(inputSet)) == null) continue;
            set.addAll(inputSet);
        }
        return set;
    }

    public Set<RelColumnOrigin> getColumnOrigins(JoinRelBase rel, int iOutputColumn) {
        Set<RelColumnOrigin> set;
        int nLeftColumns = rel.getLeft().getRowType().getFieldList().size();
        boolean derived = false;
        if (iOutputColumn < nLeftColumns) {
            set = this.invokeGetColumnOrigins(rel.getLeft(), iOutputColumn);
            if (rel.getJoinType().generatesNullsOnLeft()) {
                derived = true;
            }
        } else {
            set = this.invokeGetColumnOrigins(rel.getRight(), iOutputColumn - nLeftColumns);
            if (rel.getJoinType().generatesNullsOnRight()) {
                derived = true;
            }
        }
        if (derived) {
            set = this.createDerivedColumnOrigins(set);
        }
        return set;
    }

    public Set<RelColumnOrigin> getColumnOrigins(SetOpRel rel, int iOutputColumn) {
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (RelNode input : rel.getInputs()) {
            Set<RelColumnOrigin> inputSet = this.invokeGetColumnOrigins(input, iOutputColumn);
            if (inputSet == null) {
                return null;
            }
            set.addAll(inputSet);
        }
        return set;
    }

    public Set<RelColumnOrigin> getColumnOrigins(ProjectRelBase rel, int iOutputColumn) {
        final RelNode child = rel.getChild();
        RexNode rexNode = rel.getProjects().get(iOutputColumn);
        if (rexNode instanceof RexInputRef) {
            RexInputRef inputRef = (RexInputRef)rexNode;
            return this.invokeGetColumnOrigins(child, inputRef.getIndex());
        }
        final HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            @Override
            public Void visitInputRef(RexInputRef inputRef) {
                Set<RelColumnOrigin> inputSet = RelMdColumnOrigins.this.invokeGetColumnOrigins(child, inputRef.getIndex());
                if (inputSet != null) {
                    set.addAll(inputSet);
                }
                return null;
            }
        };
        rexNode.accept(visitor);
        return this.createDerivedColumnOrigins(set);
    }

    public Set<RelColumnOrigin> getColumnOrigins(FilterRelBase rel, int iOutputColumn) {
        return this.invokeGetColumnOrigins(rel.getChild(), iOutputColumn);
    }

    public Set<RelColumnOrigin> getColumnOrigins(SortRel rel, int iOutputColumn) {
        return this.invokeGetColumnOrigins(rel.getChild(), iOutputColumn);
    }

    public Set<RelColumnOrigin> getColumnOrigins(TableFunctionRelBase rel, int iOutputColumn) {
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        Set<RelColumnMapping> mappings = rel.getColumnMappings();
        if (mappings == null) {
            if (rel.getInputs().size() > 0) {
                return null;
            }
            return set;
        }
        for (RelColumnMapping mapping : mappings) {
            if (mapping.iOutputColumn != iOutputColumn) continue;
            Set<RelColumnOrigin> origins = this.invokeGetColumnOrigins(rel.getInputs().get(mapping.iInputRel), mapping.iInputColumn);
            if (origins == null) {
                return null;
            }
            if (mapping.derived) {
                origins = this.createDerivedColumnOrigins(origins);
            }
            set.addAll(origins);
        }
        return set;
    }

    public Set<RelColumnOrigin> getColumnOrigins(RelNode rel, int iOutputColumn) {
        if (rel.getInputs().size() > 0) {
            return null;
        }
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        RelOptTable table = rel.getTable();
        if (table == null) {
            return set;
        }
        if (table.getRowType() != rel.getRowType()) {
            return null;
        }
        set.add(new RelColumnOrigin(table, iOutputColumn, false));
        return set;
    }

    protected Set<RelColumnOrigin> invokeGetColumnOrigins(RelNode rel, int iOutputColumn) {
        return RelMetadataQuery.getColumnOrigins(rel, iOutputColumn);
    }

    private Set<RelColumnOrigin> createDerivedColumnOrigins(Set<RelColumnOrigin> inputSet) {
        if (inputSet == null) {
            return null;
        }
        HashSet<RelColumnOrigin> set = new HashSet<RelColumnOrigin>();
        for (RelColumnOrigin rco : inputSet) {
            RelColumnOrigin derived = new RelColumnOrigin(rco.getOriginTable(), rco.getOriginColumnOrdinal(), true);
            set.add(derived);
        }
        return set;
    }
}

