/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.MultiJoinRel;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertMultiJoinRule
extends RelOptRule {
    public static final ConvertMultiJoinRule INSTANCE = new ConvertMultiJoinRule();

    private ConvertMultiJoinRule() {
        super(ConvertMultiJoinRule.operand(JoinRel.class, ConvertMultiJoinRule.operand(RelNode.class, ConvertMultiJoinRule.any()), ConvertMultiJoinRule.operand(RelNode.class, ConvertMultiJoinRule.any())));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        JoinRel origJoinRel = (JoinRel)call.rel(0);
        Object left = call.rel(1);
        Object right = call.rel(2);
        ArrayList<BitSet> projFieldsList = new ArrayList<BitSet>();
        ArrayList<int[]> joinFieldRefCountsList = new ArrayList<int[]>();
        List<RelNode> newInputs = this.combineInputs(origJoinRel, (RelNode)left, (RelNode)right, (List<BitSet>)projFieldsList, (List<int[]>)joinFieldRefCountsList);
        ArrayList<Pair<JoinRelType, RexNode>> joinSpecs = new ArrayList<Pair<JoinRelType, RexNode>>();
        this.combineOuterJoins(origJoinRel, newInputs, (RelNode)left, (RelNode)right, (List<Pair<JoinRelType, RexNode>>)joinSpecs);
        List<RexNode> newOuterJoinConds = Pair.right(joinSpecs);
        List<JoinRelType> joinTypes = Pair.left(joinSpecs);
        RexNode newJoinFilter = this.combineJoinFilters(origJoinRel, (RelNode)left, (RelNode)right);
        HashMap<Integer, int[]> newJoinFieldRefCountsMap = new HashMap<Integer, int[]>();
        this.addOnJoinFieldRefCounts(newInputs, origJoinRel.getRowType().getFieldCount(), origJoinRel.getCondition(), joinFieldRefCountsList, newJoinFieldRefCountsMap);
        RexNode newPostJoinFilter = this.combinePostJoinFilters(origJoinRel, (RelNode)left, (RelNode)right);
        MultiJoinRel multiJoin = new MultiJoinRel(origJoinRel.getCluster(), newInputs, newJoinFilter, origJoinRel.getRowType(), origJoinRel.getJoinType() == JoinRelType.FULL, newOuterJoinConds, joinTypes, projFieldsList, newJoinFieldRefCountsMap, newPostJoinFilter);
        call.transformTo(multiJoin);
    }

    private List<RelNode> combineInputs(JoinRel join, RelNode left, RelNode right, List<BitSet> projFieldsList, List<int[]> joinFieldRefCountsList) {
        int i;
        MultiJoinRel rightMultiJoin;
        int nInputsOnLeft;
        int nInputs;
        MultiJoinRel leftMultiJoin;
        JoinRelType joinType = join.getJoinType();
        boolean combineLeft = this.canCombine(left, joinType.generatesNullsOnLeft());
        if (combineLeft) {
            leftMultiJoin = (MultiJoinRel)left;
            nInputsOnLeft = nInputs = left.getInputs().size();
        } else {
            leftMultiJoin = null;
            nInputs = 1;
            nInputsOnLeft = 1;
        }
        boolean combineRight = this.canCombine(right, joinType.generatesNullsOnRight());
        if (combineRight) {
            rightMultiJoin = (MultiJoinRel)right;
            nInputs += right.getInputs().size();
        } else {
            rightMultiJoin = null;
            ++nInputs;
        }
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        if (combineLeft) {
            for (i = 0; i < left.getInputs().size(); ++i) {
                newInputs.add(leftMultiJoin.getInput(i));
                projFieldsList.add(leftMultiJoin.getProjFields().get(i));
                joinFieldRefCountsList.add(leftMultiJoin.getJoinFieldRefCountsMap().get(i));
            }
        } else {
            newInputs.add(left);
            i = 1;
            projFieldsList.add(null);
            joinFieldRefCountsList.add(new int[left.getRowType().getFieldCount()]);
        }
        if (combineRight) {
            while (i < nInputs) {
                newInputs.add(rightMultiJoin.getInput(i - nInputsOnLeft));
                projFieldsList.add(rightMultiJoin.getProjFields().get(i - nInputsOnLeft));
                joinFieldRefCountsList.add(rightMultiJoin.getJoinFieldRefCountsMap().get(i - nInputsOnLeft));
                ++i;
            }
        } else {
            newInputs.add(right);
            projFieldsList.add(null);
            joinFieldRefCountsList.add(new int[right.getRowType().getFieldCount()]);
        }
        return newInputs;
    }

    private void combineOuterJoins(JoinRel joinRel, List<RelNode> combinedInputs, RelNode left, RelNode right, List<Pair<JoinRelType, RexNode>> joinSpecs) {
        JoinRelType joinType = joinRel.getJoinType();
        boolean leftCombined = this.canCombine(left, joinType.generatesNullsOnLeft());
        boolean rightCombined = this.canCombine(right, joinType.generatesNullsOnRight());
        switch (joinType) {
            case LEFT: {
                if (leftCombined) {
                    this.copyOuterJoinInfo((MultiJoinRel)left, joinSpecs, 0, null, null);
                } else {
                    joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                }
                joinSpecs.add(Pair.of(joinType, joinRel.getCondition()));
                break;
            }
            case RIGHT: {
                joinSpecs.add(Pair.of(joinType, joinRel.getCondition()));
                if (rightCombined) {
                    this.copyOuterJoinInfo((MultiJoinRel)right, joinSpecs, left.getRowType().getFieldCount(), right.getRowType().getFieldList(), joinRel.getRowType().getFieldList());
                    break;
                }
                joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                break;
            }
            default: {
                if (leftCombined) {
                    this.copyOuterJoinInfo((MultiJoinRel)left, joinSpecs, 0, null, null);
                } else {
                    joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                }
                if (rightCombined) {
                    this.copyOuterJoinInfo((MultiJoinRel)right, joinSpecs, left.getRowType().getFieldCount(), right.getRowType().getFieldList(), joinRel.getRowType().getFieldList());
                    break;
                }
                joinSpecs.add(Pair.of(JoinRelType.INNER, null));
            }
        }
    }

    private void copyOuterJoinInfo(MultiJoinRel multiJoinRel, List<Pair<JoinRelType, RexNode>> destJoinSpecs, int adjustmentAmount, List<RelDataTypeField> srcFields, List<RelDataTypeField> destFields) {
        List<Pair<JoinRelType, RexNode>> srcJoinSpecs = Pair.zip(multiJoinRel.getJoinTypes(), multiJoinRel.getOuterJoinConditions());
        if (adjustmentAmount == 0) {
            destJoinSpecs.addAll(srcJoinSpecs);
        } else {
            int nFields = srcFields.size();
            int[] adjustments = new int[nFields];
            for (int idx = 0; idx < nFields; ++idx) {
                adjustments[idx] = adjustmentAmount;
            }
            for (Pair<JoinRelType, RexNode> src : srcJoinSpecs) {
                destJoinSpecs.add(Pair.of(src.left, src.right == null ? null : ((RexNode)src.right).accept(new RelOptUtil.RexInputConverter(multiJoinRel.getCluster().getRexBuilder(), srcFields, destFields, adjustments))));
            }
        }
    }

    private RexNode combineJoinFilters(JoinRel joinRel, RelNode left, RelNode right) {
        RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
        JoinRelType joinType = joinRel.getJoinType();
        RexNode rightFilter = null;
        if (this.canCombine(right, joinType.generatesNullsOnRight())) {
            MultiJoinRel multiJoin = (MultiJoinRel)right;
            rightFilter = this.shiftRightFilter(joinRel, left, multiJoin, multiJoin.getJoinFilter());
        }
        RexNode newFilter = null;
        if (joinType != JoinRelType.LEFT && joinType != JoinRelType.RIGHT) {
            newFilter = joinRel.getCondition();
        }
        if (this.canCombine(left, joinType.generatesNullsOnLeft())) {
            RexNode leftFilter = ((MultiJoinRel)left).getJoinFilter();
            newFilter = RelOptUtil.andJoinFilters(rexBuilder, newFilter, leftFilter);
        }
        newFilter = RelOptUtil.andJoinFilters(rexBuilder, newFilter, rightFilter);
        return newFilter;
    }

    private boolean canCombine(RelNode input, boolean nullGenerating) {
        return input instanceof MultiJoinRel && !((MultiJoinRel)input).isFullOuterJoin() && !nullGenerating;
    }

    private RexNode shiftRightFilter(JoinRel joinRel, RelNode left, MultiJoinRel right, RexNode rightFilter) {
        if (rightFilter == null) {
            return null;
        }
        int nFieldsOnLeft = left.getRowType().getFieldList().size();
        int nFieldsOnRight = right.getRowType().getFieldList().size();
        int[] adjustments = new int[nFieldsOnRight];
        for (int i = 0; i < nFieldsOnRight; ++i) {
            adjustments[i] = nFieldsOnLeft;
        }
        rightFilter = rightFilter.accept(new RelOptUtil.RexInputConverter(joinRel.getCluster().getRexBuilder(), right.getRowType().getFieldList(), joinRel.getRowType().getFieldList(), adjustments));
        return rightFilter;
    }

    private void addOnJoinFieldRefCounts(List<RelNode> multiJoinInputs, int nTotalFields, RexNode joinCondition, List<int[]> origJoinFieldRefCounts, Map<Integer, int[]> newJoinFieldRefCountsMap) {
        int[] joinCondRefCounts = new int[nTotalFields];
        joinCondition.accept(new InputReferenceCounter(joinCondRefCounts));
        int nInputs = multiJoinInputs.size();
        int currInput = 0;
        for (int[] origRefCounts : origJoinFieldRefCounts) {
            newJoinFieldRefCountsMap.put(currInput, (int[])origRefCounts.clone());
            ++currInput;
        }
        currInput = -1;
        int startField = 0;
        int nFields = 0;
        for (int i = 0; i < nTotalFields; ++i) {
            if (joinCondRefCounts[i] == 0) continue;
            while (i >= startField + nFields) {
                startField += nFields;
                assert (++currInput < nInputs);
                nFields = multiJoinInputs.get(currInput).getRowType().getFieldCount();
            }
            int[] refCounts = newJoinFieldRefCountsMap.get(currInput);
            int n = i - startField;
            refCounts[n] = refCounts[n] + joinCondRefCounts[i];
        }
    }

    private RexNode combinePostJoinFilters(JoinRel joinRel, RelNode left, RelNode right) {
        RexNode rightPostJoinFilter = null;
        if (right instanceof MultiJoinRel) {
            rightPostJoinFilter = this.shiftRightFilter(joinRel, left, (MultiJoinRel)right, ((MultiJoinRel)right).getPostJoinFilter());
        }
        RexNode leftPostJoinFilter = null;
        if (left instanceof MultiJoinRel) {
            leftPostJoinFilter = ((MultiJoinRel)left).getPostJoinFilter();
        }
        if (leftPostJoinFilter == null && rightPostJoinFilter == null) {
            return null;
        }
        return RelOptUtil.andJoinFilters(joinRel.getCluster().getRexBuilder(), leftPostJoinFilter, rightPostJoinFilter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InputReferenceCounter
    extends RexVisitorImpl<Void> {
        private final int[] refCounts;

        public InputReferenceCounter(int[] refCounts) {
            super(true);
            this.refCounts = refCounts;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            int n = inputRef.getIndex();
            this.refCounts[n] = this.refCounts[n] + 1;
            return null;
        }
    }
}

