/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.Collections;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.rules.PushProjector;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexNode;

public class PushProjectPastJoinRule
extends RelOptRule {
    public static final PushProjectPastJoinRule INSTANCE = new PushProjectPastJoinRule(PushProjector.ExprCondition.FALSE);
    private final PushProjector.ExprCondition preserveExprCondition;

    private PushProjectPastJoinRule(PushProjector.ExprCondition preserveExprCondition) {
        super(PushProjectPastJoinRule.operand(ProjectRel.class, PushProjectPastJoinRule.operand(JoinRel.class, PushProjectPastJoinRule.any()), new RelOptRuleOperand[0]));
        this.preserveExprCondition = preserveExprCondition;
    }

    public void onMatch(RelOptRuleCall call) {
        JoinRel joinRel;
        ProjectRel origProj = (ProjectRel)call.rel(0);
        PushProjector pushProject = new PushProjector(origProj, (joinRel = (JoinRel)call.rel(1)).getCondition(), joinRel, this.preserveExprCondition);
        if (pushProject.locateAllRefs()) {
            return;
        }
        ProjectRel leftProjRel = pushProject.createProjectRefsAndExprs(joinRel.getLeft(), true, false);
        ProjectRel rightProjRel = pushProject.createProjectRefsAndExprs(joinRel.getRight(), true, true);
        RexNode newJoinFilter = null;
        int[] adjustments = pushProject.getAdjustments();
        if (joinRel.getCondition() != null) {
            ArrayList<RelDataTypeField> projJoinFieldList = new ArrayList<RelDataTypeField>();
            projJoinFieldList.addAll(joinRel.getSystemFieldList());
            projJoinFieldList.addAll(leftProjRel.getRowType().getFieldList());
            projJoinFieldList.addAll(rightProjRel.getRowType().getFieldList());
            newJoinFilter = pushProject.convertRefsAndExprs(joinRel.getCondition(), projJoinFieldList, adjustments);
        }
        JoinRel newJoinRel = new JoinRel(joinRel.getCluster(), leftProjRel, rightProjRel, newJoinFilter, joinRel.getJoinType(), Collections.<String>emptySet(), joinRel.isSemiJoinDone(), joinRel.getSystemFieldList());
        ProjectRel topProject = pushProject.createNewProject(newJoinRel, adjustments);
        call.transformTo(topProject);
    }
}

