/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import java.util.HashSet;
import java.util.Set;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFamily;
import org.eigenbase.resource.EigenbaseResource;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlDynamicParam;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.type.InferTypes;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.sql.type.SqlTypeFamily;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCastFunction
extends SqlFunction {
    private final Set<TypeFamilyCast> nonMonotonicPreservingCasts = this.createNonMonotonicPreservingCasts();

    public SqlCastFunction() {
        super("CAST", SqlKind.CAST, null, InferTypes.FIRST_KNOWN, null, SqlFunctionCategory.SYSTEM);
    }

    private Set<TypeFamilyCast> createNonMonotonicPreservingCasts() {
        HashSet<TypeFamilyCast> result = new HashSet<TypeFamilyCast>();
        result.add(new TypeFamilyCast(SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.CHARACTER));
        result.add(new TypeFamilyCast(SqlTypeFamily.NUMERIC, SqlTypeFamily.CHARACTER));
        result.add(new TypeFamilyCast(SqlTypeFamily.APPROXIMATE_NUMERIC, SqlTypeFamily.CHARACTER));
        result.add(new TypeFamilyCast(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.CHARACTER));
        result.add(new TypeFamilyCast(SqlTypeFamily.CHARACTER, SqlTypeFamily.EXACT_NUMERIC));
        result.add(new TypeFamilyCast(SqlTypeFamily.CHARACTER, SqlTypeFamily.NUMERIC));
        result.add(new TypeFamilyCast(SqlTypeFamily.CHARACTER, SqlTypeFamily.APPROXIMATE_NUMERIC));
        result.add(new TypeFamilyCast(SqlTypeFamily.CHARACTER, SqlTypeFamily.DATETIME_INTERVAL));
        result.add(new TypeFamilyCast(SqlTypeFamily.DATETIME, SqlTypeFamily.TIME));
        result.add(new TypeFamilyCast(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.TIME));
        result.add(new TypeFamilyCast(SqlTypeFamily.TIME, SqlTypeFamily.DATETIME));
        result.add(new TypeFamilyCast(SqlTypeFamily.TIME, SqlTypeFamily.TIMESTAMP));
        return result;
    }

    private boolean isMonotonicPreservingCast(RelDataTypeFamily castFrom, RelDataTypeFamily castTo) {
        return !this.nonMonotonicPreservingCasts.contains(new TypeFamilyCast(castFrom, castTo));
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        SqlCallBinding callBinding;
        Object operand0;
        assert (opBinding.getOperandCount() == 2);
        RelDataType ret = opBinding.getOperandType(1);
        RelDataType firstType = opBinding.getOperandType(0);
        ret = opBinding.getTypeFactory().createTypeWithNullability(ret, firstType.isNullable());
        if (opBinding instanceof SqlCallBinding && ((operand0 = (callBinding = (SqlCallBinding)opBinding).getCall().operand(0)) instanceof SqlLiteral && ((SqlLiteral)operand0).getValue() == null || operand0 instanceof SqlDynamicParam)) {
            callBinding.getValidator().setValidatedNodeType((SqlNode)operand0, ret);
        }
        return ret;
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (operandsCount == 2);
        return "{0}({1} AS {2})";
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        Object left = callBinding.getCall().operand(0);
        Object right = callBinding.getCall().operand(1);
        if (SqlUtil.isNullLiteral(left, false) || left instanceof SqlDynamicParam) {
            return true;
        }
        RelDataType validatedNodeType = callBinding.getValidator().getValidatedNodeType((SqlNode)left);
        RelDataType returnType = callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)right);
        if (!SqlTypeUtil.canCastFrom(returnType, validatedNodeType, true)) {
            if (throwOnFailure) {
                throw callBinding.newError(EigenbaseResource.instance().CannotCastValue.ex(validatedNodeType.toString(), returnType.toString()));
            }
            return false;
        }
        if (SqlTypeUtil.areCharacterSetsMismatched(validatedNodeType, returnType)) {
            if (throwOnFailure) {
                throw callBinding.newError(EigenbaseResource.instance().CannotCastValue.ex(validatedNodeType.getFullTypeString(), returnType.getFullTypeString()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.sep("AS");
        if (call.operand(1) instanceof SqlIntervalQualifier) {
            writer.sep("INTERVAL");
        }
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endFunCall(frame);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlCall call, SqlValidatorScope scope) {
        RelDataTypeFamily castTo;
        RelDataTypeFamily castFrom = scope.getValidator().deriveType(scope, (SqlNode)call.operand(0)).getFamily();
        if (this.isMonotonicPreservingCast(castFrom, castTo = scope.getValidator().deriveType(scope, (SqlNode)call.operand(1)).getFamily())) {
            return ((SqlNode)call.operand(0)).getMonotonicity(scope);
        }
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    private class TypeFamilyCast {
        private final RelDataTypeFamily castFrom;
        private final RelDataTypeFamily castTo;

        public TypeFamilyCast(RelDataTypeFamily castFrom, RelDataTypeFamily castTo) {
            this.castFrom = castFrom;
            this.castTo = castTo;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != TypeFamilyCast.class) {
                return false;
            }
            TypeFamilyCast other = (TypeFamilyCast)obj;
            return this.castFrom.equals(other.castFrom) && this.castTo.equals(other.castTo);
        }

        public int hashCode() {
            return this.castFrom.hashCode() + this.castTo.hashCode();
        }
    }
}

