/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import java.util.ArrayList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.resource.EigenbaseResource;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.validate.DelegatingScope;
import org.eigenbase.sql.validate.SqlMoniker;
import org.eigenbase.sql.validate.SqlMonikerImpl;
import org.eigenbase.sql.validate.SqlMonikerType;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListScope
extends DelegatingScope {
    protected final List<Pair<String, SqlValidatorNamespace>> children = new ArrayList<Pair<String, SqlValidatorNamespace>>();

    public ListScope(SqlValidatorScope parent) {
        super(parent);
    }

    @Override
    public void addChild(SqlValidatorNamespace ns, String alias) {
        assert (alias != null);
        this.children.add(Pair.of(alias, ns));
    }

    public List<SqlValidatorNamespace> getChildren() {
        return Pair.right(this.children);
    }

    protected SqlValidatorNamespace getChild(String alias) {
        if (alias == null) {
            if (this.children.size() != 1) {
                throw Util.newInternal("no alias specified, but more than one table in from list");
            }
            return (SqlValidatorNamespace)this.children.get((int)0).right;
        }
        int i = this.validator.catalogReader.match(Pair.left(this.children), alias);
        if (i >= 0) {
            return (SqlValidatorNamespace)this.children.get((int)i).right;
        }
        return null;
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
        for (Pair<String, SqlValidatorNamespace> pair : this.children) {
            this.addColumnNames((SqlValidatorNamespace)pair.right, result);
        }
        this.parent.findAllColumnNames(result);
    }

    @Override
    public void findAliases(List<SqlMoniker> result) {
        for (Pair<String, SqlValidatorNamespace> pair : this.children) {
            result.add(new SqlMonikerImpl((String)pair.left, SqlMonikerType.TABLE));
        }
        this.parent.findAliases(result);
    }

    @Override
    public String findQualifyingTableName(String columnName, SqlNode ctx) {
        int count = 0;
        String tableName = null;
        for (Pair<String, SqlValidatorNamespace> child : this.children) {
            RelDataType rowType = ((SqlValidatorNamespace)child.right).getRowType();
            if (this.validator.catalogReader.field(rowType, columnName) == null) continue;
            tableName = (String)child.left;
            ++count;
        }
        switch (count) {
            case 0: {
                return this.parent.findQualifyingTableName(columnName, ctx);
            }
            case 1: {
                return tableName;
            }
        }
        throw this.validator.newValidationError(ctx, EigenbaseResource.instance().ColumnAmbiguous.ex(columnName));
    }

    @Override
    public SqlValidatorNamespace resolve(String name, SqlValidatorScope[] ancestorOut, int[] offsetOut) {
        int i = this.validator.catalogReader.match(Pair.left(this.children), name);
        if (i >= 0) {
            if (ancestorOut != null) {
                ancestorOut[0] = this;
            }
            if (offsetOut != null) {
                offsetOut[0] = i;
            }
            return (SqlValidatorNamespace)this.children.get((int)i).right;
        }
        return this.parent.resolve(name, ancestorOut, offsetOut);
    }

    @Override
    public RelDataType resolveColumn(String columnName, SqlNode ctx) {
        int found = 0;
        RelDataType type = null;
        for (Pair<String, SqlValidatorNamespace> pair : this.children) {
            SqlValidatorNamespace childNs = (SqlValidatorNamespace)pair.right;
            RelDataType childRowType = childNs.getRowType();
            RelDataTypeField field = this.validator.catalogReader.field(childRowType, columnName);
            if (field == null) continue;
            ++found;
            type = field.getType();
        }
        switch (found) {
            case 0: {
                return null;
            }
            case 1: {
                return type;
            }
        }
        throw this.validator.newValidationError(ctx, EigenbaseResource.instance().ColumnAmbiguous.ex(columnName));
    }
}

