/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util.mapping;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.util.Permutation;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.IntPair;
import org.eigenbase.util.mapping.Mapping;
import org.eigenbase.util.mapping.MappingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Mappings {
    private Mappings() {
    }

    public static Mapping create(MappingType mappingType, int sourceCount, int targetCount) {
        switch (mappingType) {
            case BIJECTION: {
                assert (sourceCount == targetCount);
                return new Permutation(sourceCount);
            }
            case INVERSE_SURJECTION: {
                assert (sourceCount >= targetCount);
                return new SurjectionWithInverse(sourceCount, targetCount);
            }
            case PARTIAL_SURJECTION: 
            case SURJECTION: {
                return new PartialMapping(sourceCount, targetCount, mappingType);
            }
            case PARTIAL_FUNCTION: 
            case FUNCTION: {
                return new PartialFunctionImpl(sourceCount, targetCount, mappingType);
            }
            case INVERSE_FUNCTION: 
            case INVERSE_PARTIAL_FUNCTION: {
                return new InverseMapping(Mappings.create(mappingType.inverse(), targetCount, sourceCount));
            }
        }
        throw Util.needToImplement("no known implementation for mapping type " + (Object)((Object)mappingType));
    }

    public static IdentityMapping createIdentity(int fieldCount) {
        return new IdentityMapping(fieldCount);
    }

    public static Mapping divide(Mapping mapping1, Mapping mapping2) {
        if (mapping1.getSourceCount() != mapping2.getSourceCount()) {
            throw new IllegalArgumentException();
        }
        Mapping remaining = Mappings.create(MappingType.INVERSE_SURJECTION, mapping2.getTargetCount(), mapping1.getTargetCount());
        for (int target = 0; target < mapping1.getTargetCount(); ++target) {
            int source = mapping1.getSourceOpt(target);
            if (source < 0) continue;
            int x = mapping2.getTarget(source);
            remaining.set(x, target);
        }
        return remaining;
    }

    public static Mapping multiply(Mapping mapping1, Mapping mapping2) {
        if (mapping1.getTargetCount() != mapping2.getSourceCount()) {
            throw new IllegalArgumentException();
        }
        Mapping product = Mappings.create(MappingType.INVERSE_SURJECTION, mapping1.getSourceCount(), mapping2.getTargetCount());
        for (int source = 0; source < mapping1.getSourceCount(); ++source) {
            int x = mapping1.getTargetOpt(source);
            if (x < 0) continue;
            int target = mapping2.getTarget(x);
            product.set(source, target);
        }
        return product;
    }

    public static BitSet apply(Mapping mapping, BitSet bitSet) {
        BitSet newBitSet = new BitSet();
        for (int source : BitSets.toIter(bitSet)) {
            int target = mapping.getTarget(source);
            newBitSet.set(target);
        }
        if (newBitSet.equals(bitSet)) {
            return bitSet;
        }
        return newBitSet;
    }

    public static <T> List<T> apply(Mapping mapping, List<T> list) {
        if (mapping.getSourceCount() != list.size()) {
            throw new IllegalArgumentException("mapping source count " + mapping.getSourceCount() + " does not match list size " + list.size());
        }
        int targetCount = mapping.getTargetCount();
        ArrayList<T> list2 = new ArrayList<T>(targetCount);
        for (int target = 0; target < targetCount; ++target) {
            int source = mapping.getSource(target);
            list2.add(list.get(source));
        }
        return list2;
    }

    public static List<Integer> apply2(final Mapping mapping, final List<Integer> list) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                int source = (Integer)list.get(index);
                return mapping.getTarget(source);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static <T> List<T> apply3(final Mapping mapping, final List<T> list) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return list.get(mapping.getSource(index));
            }

            @Override
            public int size() {
                return mapping.getTargetCount();
            }
        };
    }

    public static List<Integer> asList(final TargetMapping mapping) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int source) {
                int target = mapping.getTargetOpt(source);
                return target < 0 ? null : Integer.valueOf(target);
            }

            @Override
            public int size() {
                return mapping.getSourceCount();
            }
        };
    }

    public static TargetMapping target(Map<Integer, Integer> map, int sourceCount, int targetCount) {
        PartialFunctionImpl mapping = new PartialFunctionImpl(sourceCount, targetCount, MappingType.FUNCTION);
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            mapping.set(entry.getKey(), entry.getValue());
        }
        return mapping;
    }

    public static TargetMapping target(Function1<Integer, Integer> function, int sourceCount, int targetCount) {
        PartialFunctionImpl mapping = new PartialFunctionImpl(sourceCount, targetCount, MappingType.FUNCTION);
        for (int source = 0; source < sourceCount; ++source) {
            Integer target = (Integer)function.apply((Object)source);
            if (target == null) continue;
            mapping.set(source, target);
        }
        return mapping;
    }

    public static boolean isIdentity(TargetMapping mapping) {
        if (mapping.getSourceCount() != mapping.getTargetCount()) {
            return false;
        }
        for (int i = 0; i < mapping.getSourceCount(); ++i) {
            if (mapping.getTargetOpt(i) == i) continue;
            return false;
        }
        return true;
    }

    public static TargetMapping createShiftMapping(int sourceCount, int ... ints) {
        int targetCount = 0;
        assert (ints.length % 3 == 0);
        for (int i = 0; i < ints.length; i += 3) {
            int target = ints[i];
            int length = ints[i + 2];
            int top = target + length;
            targetCount = Math.max(targetCount, top);
        }
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, sourceCount, targetCount);
        for (int i = 0; i < ints.length; i += 3) {
            int target = ints[i];
            int source = ints[i + 1];
            int length = ints[i + 2];
            assert (source + length <= sourceCount);
            for (int j = 0; j < length; ++j) {
                assert (mapping.getTargetOpt(source + j) == -1);
                mapping.set(source + j, target + j);
            }
        }
        return mapping;
    }

    public static TargetMapping append(TargetMapping mapping0, TargetMapping mapping1) {
        int t;
        int s;
        int s0 = mapping0.getSourceCount();
        int s1 = mapping1.getSourceCount();
        int t0 = mapping0.getTargetCount();
        int t1 = mapping1.getTargetCount();
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, s0 + s1, t0 + t1);
        for (s = 0; s < s0; ++s) {
            t = mapping0.getTargetOpt(s);
            if (t < 0) continue;
            mapping.set(s, t);
        }
        for (s = 0; s < s1; ++s) {
            t = mapping1.getTargetOpt(s);
            if (t < 0) continue;
            mapping.set(s0 + s, t0 + t);
        }
        return mapping;
    }

    public static TargetMapping merge(TargetMapping mapping0, TargetMapping mapping1) {
        int s0 = mapping0.getSourceCount();
        int s1 = mapping1.getSourceCount();
        assert (s0 == s1);
        int t0 = mapping0.getTargetCount();
        int t1 = mapping1.getTargetCount();
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, s0, Math.max(t0, t1));
        for (int s = 0; s < s0; ++s) {
            int t = mapping0.getTargetOpt(s);
            if (t >= 0) {
                mapping.set(s, t);
                assert (mapping1.getTargetOpt(s) < 0);
                continue;
            }
            t = mapping1.getTargetOpt(s);
            if (t < 0) continue;
            mapping.set(s, t);
        }
        return mapping;
    }

    public static TargetMapping offsetSource(final TargetMapping mapping, final int offset, int sourceCount) {
        if (sourceCount < mapping.getSourceCount() + offset) {
            throw new IllegalArgumentException("new source count too low");
        }
        return Mappings.target(new Function1<Integer, Integer>(){

            public Integer apply(Integer source) {
                int source2 = source - offset;
                return source2 < 0 || source2 >= mapping.getSourceCount() ? null : Integer.valueOf(mapping.getTargetOpt(source2));
            }
        }, sourceCount, mapping.getTargetCount());
    }

    public static TargetMapping offset(final TargetMapping mapping, final int offset, int sourceCount) {
        if (sourceCount < mapping.getSourceCount() + offset) {
            throw new IllegalArgumentException("new source count too low");
        }
        return Mappings.target(new Function1<Integer, Integer>(){

            public Integer apply(Integer source) {
                int source2 = source - offset;
                if (source2 < 0 || source2 >= mapping.getSourceCount()) {
                    return null;
                }
                int target = mapping.getTargetOpt(source2);
                if (target < 0) {
                    return null;
                }
                return target + offset;
            }
        }, sourceCount, mapping.getTargetCount() + offset);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InverseMapping
    implements Mapping {
        private final Mapping parent;

        InverseMapping(Mapping parent) {
            this.parent = parent;
        }

        @Override
        public Iterator<IntPair> iterator() {
            final Iterator<IntPair> parentIter = this.parent.iterator();
            return new Iterator<IntPair>(){

                @Override
                public boolean hasNext() {
                    return parentIter.hasNext();
                }

                @Override
                public IntPair next() {
                    IntPair parentPair = (IntPair)parentIter.next();
                    return new IntPair(parentPair.target, parentPair.source);
                }

                @Override
                public void remove() {
                    parentIter.remove();
                }
            };
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public int getSourceCount() {
            return this.parent.getTargetCount();
        }

        @Override
        public int getTargetCount() {
            return this.parent.getSourceCount();
        }

        @Override
        public MappingType getMappingType() {
            return this.parent.getMappingType().inverse();
        }

        @Override
        public boolean isIdentity() {
            return this.parent.isIdentity();
        }

        @Override
        public int getTargetOpt(int source) {
            return this.parent.getSourceOpt(source);
        }

        @Override
        public int getTarget(int source) {
            return this.parent.getSource(source);
        }

        @Override
        public int getSource(int target) {
            return this.parent.getTarget(target);
        }

        @Override
        public int getSourceOpt(int target) {
            return this.parent.getTargetOpt(target);
        }

        @Override
        public Mapping inverse() {
            return this.parent;
        }

        @Override
        public void set(int source, int target) {
            this.parent.set(target, source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PartialFunctionImpl
    extends AbstractMapping
    implements TargetMapping {
        private final int sourceCount;
        private final int targetCount;
        private final MappingType mappingType;
        private final int[] targets;

        public PartialFunctionImpl(int sourceCount, int targetCount, MappingType mappingType) {
            if (sourceCount < 0) {
                throw new IllegalArgumentException("Sources must be finite");
            }
            this.sourceCount = sourceCount;
            this.targetCount = targetCount;
            this.mappingType = mappingType;
            if (!mappingType.isSingleTarget()) {
                throw new IllegalArgumentException("Must have at most one target");
            }
            this.targets = new int[sourceCount];
            Arrays.fill(this.targets, -1);
        }

        @Override
        public int getSourceCount() {
            return this.sourceCount;
        }

        @Override
        public int getTargetCount() {
            return this.targetCount;
        }

        @Override
        public void clear() {
            Arrays.fill(this.targets, -1);
        }

        @Override
        public int size() {
            int size = 0;
            for (int i = 0; i < this.targets.length; ++i) {
                if (this.targets[i] < 0) continue;
                ++size;
            }
            return size;
        }

        @Override
        public Iterator<IntPair> iterator() {
            return new Iterator<IntPair>(){
                int i = -1;
                {
                    this.advance();
                }

                private void advance() {
                    do {
                        ++this.i;
                    } while (this.i < PartialFunctionImpl.this.sourceCount && PartialFunctionImpl.this.targets[this.i] < 0);
                }

                @Override
                public boolean hasNext() {
                    return this.i < PartialFunctionImpl.this.sourceCount;
                }

                @Override
                public IntPair next() {
                    IntPair pair = new IntPair(this.i, PartialFunctionImpl.this.targets[this.i]);
                    this.advance();
                    return pair;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public MappingType getMappingType() {
            return this.mappingType;
        }

        @Override
        public Mapping inverse() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int source, int target) {
            if (target < 0 && this.mappingType.isMandatorySource()) {
                throw new IllegalArgumentException("Target is required");
            }
            if (target >= this.targetCount && this.targetCount >= 0) {
                throw new IllegalArgumentException("Target must be less than target count, " + this.targetCount);
            }
            this.targets[source] = target;
        }

        public void setAll(Mapping mapping) {
            for (IntPair pair : mapping) {
                this.set(pair.source, pair.target);
            }
        }

        @Override
        public int getTargetOpt(int source) {
            return this.targets[source];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OverridingTargetMapping
    extends AbstractMapping
    implements TargetMapping {
        private final TargetMapping parent;
        private final int target;
        private final int source;

        public OverridingTargetMapping(TargetMapping parent, int target, int source) {
            this.parent = parent;
            this.target = target;
            this.source = source;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Mapping is read-only");
        }

        @Override
        public int size() {
            return this.parent.getTargetOpt(this.source) >= 0 ? this.parent.size() : this.parent.size() + 1;
        }

        @Override
        public void set(int source, int target) {
            this.parent.set(source, target);
        }

        @Override
        public Mapping inverse() {
            return new OverridingSourceMapping(this.parent.inverse(), this.source, this.target);
        }

        @Override
        public MappingType getMappingType() {
            return this.parent.getMappingType();
        }

        @Override
        public boolean isIdentity() {
            return this.source == this.target && ((Mapping)this.parent).isIdentity();
        }

        @Override
        public int getTarget(int source) {
            if (source == this.source) {
                return this.target;
            }
            return this.parent.getTarget(source);
        }

        @Override
        public Iterator<IntPair> iterator() {
            throw Util.needToImplement(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OverridingSourceMapping
    extends AbstractMapping
    implements SourceMapping {
        private final SourceMapping parent;
        private final int source;
        private final int target;

        public OverridingSourceMapping(SourceMapping parent, int source, int target) {
            this.parent = parent;
            this.source = source;
            this.target = target;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Mapping is read-only");
        }

        @Override
        public int size() {
            return this.parent.getSourceOpt(this.target) >= 0 ? this.parent.size() : this.parent.size() + 1;
        }

        @Override
        public Mapping inverse() {
            return new OverridingTargetMapping(this.parent.inverse(), this.target, this.source);
        }

        @Override
        public MappingType getMappingType() {
            return this.parent.getMappingType();
        }

        @Override
        public int getSource(int target) {
            if (target == this.target) {
                return this.source;
            }
            return this.parent.getSource(target);
        }

        @Override
        public boolean isIdentity() {
            return this.source == this.target && this.parent.isIdentity();
        }

        @Override
        public Iterator<IntPair> iterator() {
            throw Util.needToImplement(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IdentityMapping
    extends AbstractMapping
    implements FunctionMapping,
    TargetMapping,
    SourceMapping {
        private final int size;

        public IdentityMapping(int size) {
            this.size = size;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Mapping is read-only");
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Mapping inverse() {
            return this;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public void set(int source, int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MappingType getMappingType() {
            return MappingType.BIJECTION;
        }

        @Override
        public int getSourceCount() {
            return this.size;
        }

        @Override
        public int getTargetCount() {
            return this.size;
        }

        @Override
        public int getTarget(int source) {
            return source;
        }

        @Override
        public int getTargetOpt(int source) {
            return source;
        }

        @Override
        public int getSource(int target) {
            return target;
        }

        @Override
        public int getSourceOpt(int target) {
            return target;
        }

        @Override
        public Iterator<IntPair> iterator() {
            return new Iterator<IntPair>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return IdentityMapping.this.size < 0 || this.i < IdentityMapping.this.size;
                }

                @Override
                public IntPair next() {
                    int x = this.i++;
                    return new IntPair(x, x);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static class SurjectionWithInverse
    extends PartialMapping {
        SurjectionWithInverse(int sourceCount, int targetCount) {
            super(sourceCount, targetCount, MappingType.INVERSE_SURJECTION);
        }

        public void set(int source, int target) {
            assert (this.isValid());
            int prevTarget = this.targets[source];
            if (prevTarget != -1) {
                throw new IllegalArgumentException("source #" + source + " is already mapped to target #" + target);
            }
            this.targets[source] = target;
            this.sources[target] = source;
        }

        public int getSource(int target) {
            return this.sources[target];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PartialMapping
    extends FiniteAbstractMapping
    implements Mapping,
    FunctionMapping,
    TargetMapping {
        protected final int[] sources;
        protected final int[] targets;
        private final MappingType mappingType;

        public PartialMapping(int sourceCount, int targetCount, MappingType mappingType) {
            this.mappingType = mappingType;
            assert (mappingType.isSingleSource()) : mappingType;
            assert (mappingType.isSingleTarget()) : mappingType;
            this.sources = new int[targetCount];
            this.targets = new int[sourceCount];
            Arrays.fill(this.sources, -1);
            Arrays.fill(this.targets, -1);
        }

        public PartialMapping(List<Integer> sourceList, int sourceCount, MappingType mappingType) {
            this.mappingType = mappingType;
            assert (mappingType.isSingleSource());
            assert (mappingType.isSingleTarget());
            int targetCount = sourceList.size();
            this.targets = new int[sourceCount];
            this.sources = new int[targetCount];
            Arrays.fill(this.sources, -1);
            for (int i = 0; i < sourceList.size(); ++i) {
                int source;
                this.sources[i] = source = sourceList.get(i).intValue();
                if (source >= 0) {
                    this.targets[source] = i;
                    continue;
                }
                assert (!this.mappingType.isMandatorySource());
            }
        }

        private PartialMapping(int[] sources, int[] targets, MappingType mappingType) {
            this.sources = sources;
            this.targets = targets;
            this.mappingType = mappingType;
        }

        @Override
        public MappingType getMappingType() {
            return this.mappingType;
        }

        @Override
        public int getSourceCount() {
            return this.targets.length;
        }

        @Override
        public int getTargetCount() {
            return this.sources.length;
        }

        @Override
        public void clear() {
            Arrays.fill(this.sources, -1);
            Arrays.fill(this.targets, -1);
        }

        @Override
        public int size() {
            int size = 0;
            int[] a = this.sources.length < this.targets.length ? this.sources : this.targets;
            for (int i = 0; i < a.length; ++i) {
                if (a[i] < 0) continue;
                ++size;
            }
            return size;
        }

        @Override
        public Mapping inverse() {
            return new PartialMapping((int[])this.targets.clone(), (int[])this.sources.clone(), this.mappingType.inverse());
        }

        @Override
        public Iterator<IntPair> iterator() {
            return new MappingItr();
        }

        protected boolean isValid() {
            PartialMapping.assertPartialValid(this.sources, this.targets);
            PartialMapping.assertPartialValid(this.targets, this.sources);
            return true;
        }

        private static void assertPartialValid(int[] sources, int[] targets) {
            for (int i = 0; i < sources.length; ++i) {
                int source = sources[i];
                assert (source >= -1);
                assert (source < targets.length);
                assert (source == -1 || targets[source] == i);
            }
        }

        @Override
        public void set(int source, int target) {
            assert (this.isValid());
            int prevTarget = this.targets[source];
            this.targets[source] = target;
            int prevSource = this.sources[target];
            this.sources[target] = source;
            if (prevTarget != -1) {
                this.sources[prevTarget] = prevSource;
            }
            if (prevSource != -1) {
                this.targets[prevSource] = prevTarget;
            }
            assert (this.isValid());
        }

        @Override
        public int getSourceOpt(int target) {
            return this.sources[target];
        }

        @Override
        public int getTargetOpt(int source) {
            return this.targets[source];
        }

        @Override
        public boolean isIdentity() {
            if (this.sources.length != this.targets.length) {
                return false;
            }
            for (int i = 0; i < this.sources.length; ++i) {
                int source = this.sources[i];
                if (source == i) continue;
                return false;
            }
            return true;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MappingItr
        implements Iterator<IntPair> {
            int i = -1;

            MappingItr() {
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.i < PartialMapping.this.targets.length;
            }

            private void advance() {
                do {
                    ++this.i;
                } while (this.i < PartialMapping.this.targets.length && PartialMapping.this.targets[this.i] == -1);
            }

            @Override
            public IntPair next() {
                IntPair pair = new IntPair(this.i, PartialMapping.this.targets[this.i]);
                this.advance();
                return pair;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class NoElementException
    extends RuntimeException {
        public NoElementException(String message) {
            super(message);
        }
    }

    public static class TooManyElementsException
    extends RuntimeException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FunctionMappingIter
    implements Iterator<IntPair> {
        private int i = 0;
        private final FunctionMapping mapping;

        FunctionMappingIter(FunctionMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.mapping.getSourceCount() || this.mapping.getSourceCount() == -1;
        }

        @Override
        public IntPair next() {
            int x = this.i++;
            return new IntPair(x, this.mapping.getTarget(x));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class FiniteAbstractMapping
    extends AbstractMapping {
        @Override
        public Iterator<IntPair> iterator() {
            return new FunctionMappingIter(this);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Mapping && this.toString().equals(obj.toString());
        }
    }

    public static abstract class AbstractMapping
    implements Mapping {
        public void set(int source, int target) {
            throw new UnsupportedOperationException();
        }

        public int getTargetOpt(int source) {
            throw new UnsupportedOperationException();
        }

        public int getTarget(int source) {
            int target = this.getTargetOpt(source);
            if (target == -1) {
                throw new NoElementException("source #" + source + " has no target in mapping " + this.toString());
            }
            return target;
        }

        public int getSourceOpt(int target) {
            throw new UnsupportedOperationException();
        }

        public int getSource(int target) {
            int source = this.getSourceOpt(target);
            if (source == -1) {
                throw new NoElementException("target #" + target + " has no source in mapping " + this.toString());
            }
            return source;
        }

        public int getSourceCount() {
            throw new UnsupportedOperationException();
        }

        public int getTargetCount() {
            throw new UnsupportedOperationException();
        }

        public boolean isIdentity() {
            int targetCount;
            int sourceCount = this.getSourceCount();
            if (sourceCount != (targetCount = this.getTargetCount())) {
                return false;
            }
            for (int i = 0; i < sourceCount; ++i) {
                if (this.getSource(i) == i) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[size=").append(this.size()).append(", sourceCount=").append(this.getSourceCount()).append(", targetCount=").append(this.getTargetCount()).append(", elements=[");
            int i = 0;
            for (IntPair pair : this) {
                if (i++ > 0) {
                    buf.append(", ");
                }
                buf.append(pair.source).append(':').append(pair.target);
            }
            buf.append("]]");
            return buf.toString();
        }
    }

    public static interface TargetMapping
    extends FunctionMapping {
        public int getSourceCount();

        public int getSourceOpt(int var1);

        public int getTargetCount();

        public int getTarget(int var1);

        public int getTargetOpt(int var1);

        public void set(int var1, int var2);

        public Mapping inverse();
    }

    public static interface SourceMapping
    extends CoreMapping {
        public int getSourceCount();

        public int getSource(int var1);

        public int getSourceOpt(int var1);

        public int getTargetCount();

        public int getTargetOpt(int var1);

        public MappingType getMappingType();

        public boolean isIdentity();

        public Mapping inverse();
    }

    public static interface FunctionMapping
    extends CoreMapping {
        public int getTargetOpt(int var1);

        public int getTarget(int var1);

        public MappingType getMappingType();

        public int getSourceCount();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CoreMapping
    extends Iterable<IntPair> {
        public MappingType getMappingType();

        public int size();
    }
}

