/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util14;

import java.sql.Date;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.eigenbase.util14.DateTimeUtil;
import org.eigenbase.util14.ZonelessDatetime;

public class ZonelessDate
extends ZonelessDatetime {
    private static final long serialVersionUID = -6385775986251759394L;
    protected transient Date tempDate;

    public void setZonelessTime(long value) {
        super.setZonelessTime(value);
        this.clearTime();
    }

    public void setZonedTime(long value, TimeZone zone) {
        super.setZonedTime(value, zone);
        this.clearTime();
    }

    public Object toJdbcObject() {
        return new Date(this.getJdbcDate(DateTimeUtil.DEFAULT_ZONE));
    }

    public String toString() {
        Date jdbcDate = this.getTempDate(this.getJdbcDate(DateTimeUtil.DEFAULT_ZONE));
        return jdbcDate.toString();
    }

    public String toString(String format) {
        DateFormat formatter = this.getFormatter(format);
        Date jdbcDate = this.getTempDate(this.getTime());
        return formatter.format(jdbcDate);
    }

    public static ZonelessDate parse(String s) {
        return ZonelessDate.parse(s, "yyyy-MM-dd");
    }

    public static ZonelessDate parse(String s, String format) {
        Calendar cal = DateTimeUtil.parseDateFormat(s, format, DateTimeUtil.GMT_ZONE);
        if (cal == null) {
            return null;
        }
        ZonelessDate zd = new ZonelessDate();
        zd.setZonelessTime(cal.getTimeInMillis());
        return zd;
    }

    protected Date getTempDate(long value) {
        if (this.tempDate == null) {
            this.tempDate = new Date(value);
        } else {
            this.tempDate.setTime(value);
        }
        return this.tempDate;
    }
}

