/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.function;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.function.BigDecimalFunction1;
import net.hydromatic.linq4j.function.DoubleFunction1;
import net.hydromatic.linq4j.function.EqualityComparer;
import net.hydromatic.linq4j.function.FloatFunction1;
import net.hydromatic.linq4j.function.Function;
import net.hydromatic.linq4j.function.Function0;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Function2;
import net.hydromatic.linq4j.function.IntegerFunction1;
import net.hydromatic.linq4j.function.LongFunction1;
import net.hydromatic.linq4j.function.NullableBigDecimalFunction1;
import net.hydromatic.linq4j.function.NullableDoubleFunction1;
import net.hydromatic.linq4j.function.NullableFloatFunction1;
import net.hydromatic.linq4j.function.NullableIntegerFunction1;
import net.hydromatic.linq4j.function.NullableLongFunction1;
import net.hydromatic.linq4j.function.Predicate1;
import net.hydromatic.linq4j.function.Predicate2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Functions {
    public static final Map<Class<? extends Function>, Class> FUNCTION_RESULT_TYPES = Collections.unmodifiableMap(Functions.map(Function0.class, Object.class, Function1.class, Object.class, Function2.class, Object.class, BigDecimalFunction1.class, BigDecimal.class, DoubleFunction1.class, Double.TYPE, FloatFunction1.class, Float.TYPE, IntegerFunction1.class, Integer.TYPE, LongFunction1.class, Long.TYPE, NullableBigDecimalFunction1.class, BigDecimal.class, NullableDoubleFunction1.class, Double.class, NullableFloatFunction1.class, Float.class, NullableIntegerFunction1.class, Integer.class, NullableLongFunction1.class, Long.class));
    private static final Map<Class, Class<? extends Function>> FUNCTION1_CLASSES = Collections.unmodifiableMap(new HashMap<Class, Class<? extends Function>>(Functions.inverse(FUNCTION_RESULT_TYPES)));
    private static final Comparator NULLS_FIRST_COMPARATOR = new NullsFirstComparator();
    private static final Comparator NULLS_LAST_COMPARATOR = new NullsLastComparator();
    private static final Comparator NULLS_LAST_REVERSE_COMPARATOR = new NullsLastReverseComparator();
    private static final Comparator NULLS_FIRST_REVERSE_COMPARATOR = new NullsFirstReverseComparator();
    private static final EqualityComparer<Object> IDENTITY_COMPARER = new IdentityEqualityComparer();
    private static final EqualityComparer<Object[]> ARRAY_COMPARER = new ArrayEqualityComparer();
    private static final Function1 CONSTANT_NULL_FUNCTION1 = new Function1(){

        public Object apply(Object s) {
            return null;
        }
    };

    private static <K, V> Map<K, V> map(K k, V v, Object ... rest) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(k, v);
        for (int i = 0; i < rest.length; ++i) {
            map.put(rest[i++], rest[i++]);
        }
        return map;
    }

    private static <K, V> Map<V, K> inverse(Map<K, V> map) {
        HashMap<V, K> inverseMap = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            inverseMap.put(entry.getValue(), entry.getKey());
        }
        return inverseMap;
    }

    public static <T, R> Function1<T, R> constant(final R r) {
        return new Function1<T, R>(){

            @Override
            public R apply(T s) {
                return r;
            }
        };
    }

    public static <T, R> Function1<T, R> constantNull() {
        return CONSTANT_NULL_FUNCTION1;
    }

    public static <T> Predicate1<T> truePredicate1() {
        return Predicate1.TRUE;
    }

    public static <T> Predicate1<T> falsePredicate1() {
        return Predicate1.FALSE;
    }

    public static <T1, T2> Predicate2<T1, T2> truePredicate2() {
        return Predicate2.TRUE;
    }

    public static <T1, T2> Predicate2<T1, T2> falsePredicate2() {
        return Predicate2.FALSE;
    }

    public static <TSource> Function1<TSource, TSource> identitySelector() {
        return Function1.IDENTITY;
    }

    public static <T, T2> Predicate1<T> ofTypePredicate(final Class<T2> clazz) {
        return new Predicate1<T>(){

            @Override
            public boolean apply(T v1) {
                return v1 == null || clazz.isInstance(v1);
            }
        };
    }

    public static <T1, T2> Predicate2<T1, T2> toPredicate2(final Predicate1<T1> p1) {
        return new Predicate2<T1, T2>(){

            @Override
            public boolean apply(T1 v1, T2 v2) {
                return p1.apply(v1);
            }
        };
    }

    public static <T1, T2> Predicate2<T1, T2> toPredicate(final Function2<T1, T2, Boolean> function) {
        return new Predicate2<T1, T2>(){

            @Override
            public boolean apply(T1 v1, T2 v2) {
                return (Boolean)function.apply(v1, v2);
            }
        };
    }

    private static <T> Predicate1<T> toPredicate(final Function1<T, Boolean> function) {
        return new Predicate1<T>(){

            @Override
            public boolean apply(T v1) {
                return (Boolean)function.apply(v1);
            }
        };
    }

    public static Class<? extends Function> functionClass(Type aClass) {
        Class<? extends Function> c = FUNCTION1_CLASSES.get(aClass);
        if (c != null) {
            return c;
        }
        return Function1.class;
    }

    public static <T1> Function1<T1, Integer> adapt(final IntegerFunction1<T1> f) {
        return new Function1<T1, Integer>(){

            @Override
            public Integer apply(T1 a0) {
                return f.apply(a0);
            }
        };
    }

    public static <T1> Function1<T1, Double> adapt(final DoubleFunction1<T1> f) {
        return new Function1<T1, Double>(){

            @Override
            public Double apply(T1 a0) {
                return f.apply(a0);
            }
        };
    }

    public static <T1> Function1<T1, Long> adapt(final LongFunction1<T1> f) {
        return new Function1<T1, Long>(){

            @Override
            public Long apply(T1 a0) {
                return f.apply(a0);
            }
        };
    }

    public static <T1> Function1<T1, Float> adapt(final FloatFunction1<T1> f) {
        return new Function1<T1, Float>(){

            @Override
            public Float apply(T1 a0) {
                return Float.valueOf(f.apply(a0));
            }
        };
    }

    public static <T1, R> List<R> adapt(final List<T1> list, final Function1<T1, R> f) {
        return new AbstractList<R>(){

            @Override
            public R get(int index) {
                return f.apply(list.get(index));
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static <T, R> List<R> adapt(final T[] ts, final Function1<T, R> f) {
        return new AbstractList<R>(){

            @Override
            public R get(int index) {
                return f.apply(ts[index]);
            }

            @Override
            public int size() {
                return ts.length;
            }
        };
    }

    public static <T1, R> List<R> apply(List<T1> list, Function1<T1, R> f) {
        ArrayList<R> list2 = new ArrayList<R>(list.size());
        for (T1 t : list) {
            list2.add(f.apply(t));
        }
        return list2;
    }

    public static <E> List<E> filter(List<E> list, Predicate1<E> predicate) {
        block8: {
            int hitCount = 0;
            int missCount = 0;
            for (E e : list) {
                if (predicate.apply(e)) {
                    if (missCount <= 0) {
                        ++hitCount;
                        continue;
                    }
                } else if (hitCount <= 0) {
                    ++missCount;
                    continue;
                }
                break block8;
            }
            if (hitCount == 0) {
                return Collections.emptyList();
            }
            if (missCount == 0) {
                return list;
            }
        }
        ArrayList<E> list2 = new ArrayList<E>(list.size());
        for (E e : list) {
            if (!predicate.apply(e)) continue;
            list2.add(e);
        }
        return list2;
    }

    public static <E> boolean exists(List<? extends E> list, Predicate1<E> predicate) {
        for (E e : list) {
            if (!predicate.apply(e)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean all(List<? extends E> list, Predicate1<E> predicate) {
        for (E e : list) {
            if (predicate.apply(e)) continue;
            return false;
        }
        return true;
    }

    public static <E> List<E> generate(final int size, final Function1<Integer, E> fn) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        return new AbstractList<E>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public E get(int index) {
                return fn.apply(index);
            }
        };
    }

    public static <R> Function0<R> ignore0() {
        return Ignore.INSTANCE;
    }

    public static <R, T0> Function1<R, T0> ignore1() {
        return Ignore.INSTANCE;
    }

    public static <R, T0, T1> Function2<R, T0, T1> ignore2() {
        return Ignore.INSTANCE;
    }

    public static <T extends Comparable<T>> Comparator<T> nullsComparator(boolean nullsFirst, boolean reverse) {
        return reverse ? (nullsFirst ? NULLS_FIRST_REVERSE_COMPARATOR : NULLS_LAST_REVERSE_COMPARATOR) : (nullsFirst ? NULLS_FIRST_COMPARATOR : NULLS_LAST_COMPARATOR);
    }

    public static <T> EqualityComparer<T> identityComparer() {
        return IDENTITY_COMPARER;
    }

    public static <T> EqualityComparer<T[]> arrayComparer() {
        return ARRAY_COMPARER;
    }

    public static <T, T2> EqualityComparer<T> selectorComparer(Function1<T, T2> selector) {
        return new SelectorEqualityComparer<T, T2>(selector);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Ignore<R, T0, T1>
    implements Function0<R>,
    Function1<T0, R>,
    Function2<T0, T1, R> {
        static final Ignore INSTANCE = new Ignore();

        private Ignore() {
        }

        @Override
        public R apply() {
            return null;
        }

        @Override
        public R apply(T0 p0) {
            return null;
        }

        @Override
        public R apply(T0 p0, T1 p1) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullsLastReverseComparator
    implements Comparator<Comparable>,
    Serializable {
        private NullsLastReverseComparator() {
        }

        @Override
        public int compare(Comparable o1, Comparable o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return -o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullsFirstReverseComparator
    implements Comparator<Comparable>,
    Serializable {
        private NullsFirstReverseComparator() {
        }

        @Override
        public int compare(Comparable o1, Comparable o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return -o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullsLastComparator
    implements Comparator<Comparable>,
    Serializable {
        private NullsLastComparator() {
        }

        @Override
        public int compare(Comparable o1, Comparable o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullsFirstComparator
    implements Comparator<Comparable>,
    Serializable {
        private NullsFirstComparator() {
        }

        @Override
        public int compare(Comparable o1, Comparable o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelectorEqualityComparer<T, T2>
    implements EqualityComparer<T> {
        private final Function1<T, T2> selector;

        SelectorEqualityComparer(Function1<T, T2> selector) {
            this.selector = selector;
        }

        @Override
        public boolean equal(T v1, T v2) {
            return v1 == v2 || v1 != null && v2 != null && Linq4j.equals(this.selector.apply(v1), this.selector.apply(v2));
        }

        @Override
        public int hashCode(T t) {
            return t == null ? 30877 : this.selector.apply(t).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdentityEqualityComparer
    implements EqualityComparer<Object> {
        private IdentityEqualityComparer() {
        }

        @Override
        public boolean equal(Object v1, Object v2) {
            return Linq4j.equals(v1, v2);
        }

        @Override
        public int hashCode(Object t) {
            return t == null ? 30877 : t.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayEqualityComparer
    implements EqualityComparer<Object[]> {
        private ArrayEqualityComparer() {
        }

        @Override
        public boolean equal(Object[] v1, Object[] v2) {
            return Arrays.equals(v1, v2);
        }

        @Override
        public int hashCode(Object[] t) {
            return Arrays.hashCode(t);
        }
    }
}

