/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;

public class Scan
implements Writable {
    private static final byte SCAN_VERSION = 1;
    private byte[] startRow = HConstants.EMPTY_START_ROW;
    private byte[] stopRow = HConstants.EMPTY_END_ROW;
    private int maxVersions = 1;
    private int batch = -1;
    private int caching = -1;
    private boolean cacheBlocks = true;
    private Filter filter = null;
    private TimeRange tr = new TimeRange();
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);

    public Scan() {
    }

    public Scan(byte[] startRow, Filter filter) {
        this(startRow);
        this.filter = filter;
    }

    public Scan(byte[] startRow) {
        this.startRow = startRow;
    }

    public Scan(byte[] startRow, byte[] stopRow) {
        this.startRow = startRow;
        this.stopRow = stopRow;
    }

    public Scan(Scan scan) throws IOException {
        this.startRow = scan.getStartRow();
        this.stopRow = scan.getStopRow();
        this.maxVersions = scan.getMaxVersions();
        this.batch = scan.getBatch();
        this.caching = scan.getCaching();
        this.cacheBlocks = scan.getCacheBlocks();
        this.filter = scan.getFilter();
        TimeRange ctr = scan.getTimeRange();
        this.tr = new TimeRange(ctr.getMin(), ctr.getMax());
        Map<byte[], NavigableSet<byte[]>> fams = scan.getFamilyMap();
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : fams.entrySet()) {
            byte[] fam = entry.getKey();
            NavigableSet<byte[]> cols = entry.getValue();
            if (cols != null && cols.size() > 0) {
                for (byte[] col : cols) {
                    this.addColumn(fam, col);
                }
                continue;
            }
            this.addFamily(fam);
        }
    }

    public Scan(Get get2) {
        this.startRow = get2.getRow();
        this.stopRow = get2.getRow();
        this.filter = get2.getFilter();
        this.cacheBlocks = get2.getCacheBlocks();
        this.maxVersions = get2.getMaxVersions();
        this.tr = get2.getTimeRange();
        this.familyMap = get2.getFamilyMap();
    }

    public boolean isGetScan() {
        return this.startRow != null && this.startRow.length > 0 && Bytes.equals(this.startRow, this.stopRow);
    }

    public Scan addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public Scan addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        }
        set.add(qualifier);
        this.familyMap.put(family, set);
        return this;
    }

    public Scan setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    public Scan setTimeStamp(long timestamp) {
        try {
            this.tr = new TimeRange(timestamp, timestamp + 1L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public Scan setStartRow(byte[] startRow) {
        this.startRow = startRow;
        return this;
    }

    public Scan setStopRow(byte[] stopRow) {
        this.stopRow = stopRow;
        return this;
    }

    public Scan setMaxVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public Scan setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
        return this;
    }

    public void setBatch(int batch) {
        if (this.hasFilter() && this.filter.hasFilterRow()) {
            throw new IncompatibleFilterException("Cannot set batch on a scan using a filter that returns true for filter.hasFilterRow");
        }
        this.batch = batch;
    }

    public void setCaching(int caching) {
        this.caching = caching;
    }

    public Scan setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Scan setFamilyMap(Map<byte[], NavigableSet<byte[]>> familyMap) {
        this.familyMap = familyMap;
        return this;
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    public int numFamilies() {
        if (this.hasFamilies()) {
            return this.familyMap.size();
        }
        return 0;
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public byte[][] getFamilies() {
        if (this.hasFamilies()) {
            return (byte[][])this.familyMap.keySet().toArray((T[])new byte[0][0]);
        }
        return null;
    }

    public byte[] getStartRow() {
        return this.startRow;
    }

    public byte[] getStopRow() {
        return this.stopRow;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public int getBatch() {
        return this.batch;
    }

    public int getCaching() {
        return this.caching;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public void setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("startRow=");
        sb.append(Bytes.toStringBinary(this.startRow));
        sb.append(", stopRow=");
        sb.append(Bytes.toStringBinary(this.stopRow));
        sb.append(", maxVersions=");
        sb.append(this.maxVersions);
        sb.append(", batch=");
        sb.append(this.batch);
        sb.append(", caching=");
        sb.append(this.caching);
        sb.append(", cacheBlocks=");
        sb.append(this.cacheBlocks);
        sb.append(", timeRange=");
        sb.append("[").append(this.tr.getMin()).append(",");
        sb.append(this.tr.getMax()).append(")");
        sb.append(", families=");
        if (this.familyMap.size() == 0) {
            sb.append("ALL");
            return sb.toString();
        }
        boolean moreThanOne = false;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            if (moreThanOne) {
                sb.append("), ");
            } else {
                moreThanOne = true;
                sb.append("{");
            }
            sb.append("(family=");
            sb.append(Bytes.toStringBinary(entry.getKey()));
            sb.append(", columns=");
            if (entry.getValue() == null) {
                sb.append("ALL");
                continue;
            }
            sb.append("{");
            boolean moreThanOneB = false;
            for (byte[] column : entry.getValue()) {
                if (moreThanOneB) {
                    sb.append(", ");
                } else {
                    moreThanOneB = true;
                }
                sb.append(Bytes.toStringBinary(column));
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    private Writable createForName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return WritableFactories.newInstance(clazz, (Configuration)new Configuration());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find class " + className);
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 1) {
            throw new IOException("version not supported");
        }
        this.startRow = Bytes.readByteArray(in);
        this.stopRow = Bytes.readByteArray(in);
        this.maxVersions = in.readInt();
        this.batch = in.readInt();
        this.caching = in.readInt();
        this.cacheBlocks = in.readBoolean();
        if (in.readBoolean()) {
            this.filter = (Filter)this.createForName(Bytes.toString(Bytes.readByteArray(in)));
            this.filter.readFields(in);
        }
        this.tr = new TimeRange();
        this.tr.readFields(in);
        int numFamilies = in.readInt();
        this.familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            int numColumns = in.readInt();
            TreeSet<byte[]> set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (int j = 0; j < numColumns; ++j) {
                byte[] qualifier = Bytes.readByteArray(in);
                set.add(qualifier);
            }
            this.familyMap.put(family, set);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(1);
        Bytes.writeByteArray(out, this.startRow);
        Bytes.writeByteArray(out, this.stopRow);
        out.writeInt(this.maxVersions);
        out.writeInt(this.batch);
        out.writeInt(this.caching);
        out.writeBoolean(this.cacheBlocks);
        if (this.filter == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Bytes.writeByteArray(out, Bytes.toBytes(this.filter.getClass().getName()));
            this.filter.write(out);
        }
        this.tr.write(out);
        out.writeInt(this.familyMap.size());
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            NavigableSet<byte[]> columnSet = entry.getValue();
            if (columnSet != null) {
                out.writeInt(columnSet.size());
                for (byte[] qualifier : columnSet) {
                    Bytes.writeByteArray(out, qualifier);
                }
                continue;
            }
            out.writeInt(0);
        }
    }

    public Scan addColumn(byte[] familyAndQualifier) {
        byte[][] fq = KeyValue.parseColumn(familyAndQualifier);
        if (fq.length > 1 && fq[1] != null && fq[1].length > 0) {
            this.addColumn(fq[0], fq[1]);
        } else {
            this.addFamily(fq[0]);
        }
        return this;
    }

    public Scan addColumns(byte[][] columns) {
        for (byte[] column : columns) {
            this.addColumn(column);
        }
        return this;
    }

    public Scan addColumns(String columns) {
        String[] cols;
        for (String col : cols = columns.split(" ")) {
            this.addColumn(Bytes.toBytes(col));
        }
        return this;
    }

    public String getInputColumns() {
        StringBuilder cols = new StringBuilder("");
        for (Map.Entry<byte[], NavigableSet<byte[]>> e : this.familyMap.entrySet()) {
            NavigableSet<byte[]> quals;
            byte[] fam = e.getKey();
            if (cols.length() > 0) {
                cols.append(" ");
            }
            if ((quals = e.getValue()) != null && quals.size() > 0) {
                StringBuilder cs = new StringBuilder("");
                for (byte[] qual : quals) {
                    if (cs.length() > 0) {
                        cs.append(" ");
                    }
                    cs.append(Bytes.toStringBinary(fam)).append(":").append(Bytes.toStringBinary(qual));
                }
                cols.append((CharSequence)cs);
                continue;
            }
            cols.append(Bytes.toStringBinary(fam)).append(":");
        }
        return cols.toString();
    }
}

