/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.util.StringUtils;

public class TableRecordReaderImpl {
    static final Log LOG = LogFactory.getLog(TableRecordReader.class);
    private ResultScanner scanner = null;
    private Scan scan = null;
    private HTable htable = null;
    private byte[] lastRow = null;
    private ImmutableBytesWritable key = null;
    private Result value = null;

    public void restart(byte[] firstRow) throws IOException {
        Scan newScan = new Scan(this.scan);
        newScan.setStartRow(firstRow);
        this.scanner = this.htable.getScanner(newScan);
    }

    public void init() throws IOException {
        this.restart(this.scan.getStartRow());
    }

    public void setHTable(HTable htable) {
        this.htable = htable;
    }

    public void setScan(Scan scan) {
        this.scan = scan;
    }

    public void close() {
        this.scanner.close();
    }

    public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public Result getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.key == null) {
            this.key = new ImmutableBytesWritable();
        }
        if (this.value == null) {
            this.value = new Result();
        }
        try {
            this.value = this.scanner.next();
        }
        catch (IOException e) {
            LOG.debug((Object)("recovered from " + StringUtils.stringifyException((Throwable)e)));
            if (this.lastRow == null) {
                LOG.warn((Object)"We are restarting the first next() invocation, if your mapper's restarted a few other times like this then you should consider killing this job and investigate why it's taking so long.");
                this.lastRow = this.scan.getStartRow();
            }
            this.restart(this.lastRow);
            this.scanner.next();
            this.value = this.scanner.next();
        }
        if (this.value != null && this.value.size() > 0) {
            this.key.set(this.value.getRow());
            this.lastRow = this.key.get();
            return true;
        }
        return false;
    }

    public float getProgress() {
        return 0.0f;
    }
}

