/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.master.LogCleanerDelegate;

public class TimeToLiveLogCleaner
implements LogCleanerDelegate {
    static final Log LOG = LogFactory.getLog((String)TimeToLiveLogCleaner.class.getName());
    private Configuration conf;
    private long ttl;
    private boolean stopped = false;

    @Override
    public boolean isLogDeletable(Path filePath) {
        long time = 0L;
        long currentTime = System.currentTimeMillis();
        String[] parts = filePath.getName().split("\\.");
        try {
            time = Long.parseLong(parts[parts.length - 1]);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Unable to parse the timestamp in " + filePath.getName() + ", deleting it since it's invalid and may not be a hlog"), (Throwable)e);
            return true;
        }
        long life = currentTime - time;
        if (life < 0L) {
            LOG.warn((Object)"Found a log newer than current time, probably a clock skew");
            return false;
        }
        return life > this.ttl;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.ttl = conf.getLong("hbase.master.logcleaner.ttl", 600000L);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void stop(String why) {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }
}

