/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.InternalScan;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;

class StoreScanner
implements KeyValueScanner,
InternalScanner,
ChangedReadersObserver {
    static final Log LOG = LogFactory.getLog(StoreScanner.class);
    private Store store;
    private ScanQueryMatcher matcher;
    private KeyValueHeap heap;
    private boolean cacheBlocks;
    private boolean closing = false;
    private final boolean isGet;
    private KeyValue lastTop = null;

    StoreScanner(Store store, Scan scan, NavigableSet<byte[]> columns) throws IOException {
        this.store = store;
        this.cacheBlocks = scan.getCacheBlocks();
        this.matcher = new ScanQueryMatcher(scan, store.getFamily().getName(), columns, store.ttl, store.comparator.getRawComparator(), store.versionsToReturn(scan.getMaxVersions()), false);
        this.isGet = scan.isGetScan();
        List<KeyValueScanner> scanners = this.getScanners(scan, columns);
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(this.matcher.getStartKey());
        }
        this.heap = new KeyValueHeap(scanners, store.comparator);
        this.store.addChangedReaderObserver(this);
    }

    StoreScanner(Store store, Scan scan, List<? extends KeyValueScanner> scanners, boolean retainDeletesInOutput) throws IOException {
        this.store = store;
        this.cacheBlocks = false;
        this.isGet = false;
        this.matcher = new ScanQueryMatcher(scan, store.getFamily().getName(), null, store.ttl, store.comparator.getRawComparator(), store.versionsToReturn(scan.getMaxVersions()), retainDeletesInOutput);
        for (KeyValueScanner keyValueScanner : scanners) {
            keyValueScanner.seek(this.matcher.getStartKey());
        }
        this.heap = new KeyValueHeap(scanners, store.comparator);
    }

    StoreScanner(Scan scan, byte[] colFamily, long ttl, KeyValue.KVComparator comparator, NavigableSet<byte[]> columns, List<KeyValueScanner> scanners) throws IOException {
        this.store = null;
        this.isGet = false;
        this.cacheBlocks = scan.getCacheBlocks();
        this.matcher = new ScanQueryMatcher(scan, colFamily, columns, ttl, comparator.getRawComparator(), scan.getMaxVersions(), false);
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(this.matcher.getStartKey());
        }
        this.heap = new KeyValueHeap(scanners, comparator);
    }

    private List<KeyValueScanner> getScanners() throws IOException {
        List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(this.store.getStorefiles(), this.cacheBlocks, this.isGet);
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(sfScanners.size() + 1);
        scanners.addAll(sfScanners);
        scanners.addAll(this.store.memstore.getScanners());
        return scanners;
    }

    private List<KeyValueScanner> getScanners(Scan scan, NavigableSet<byte[]> columns) throws IOException {
        boolean filesOnly;
        boolean memOnly;
        if (scan instanceof InternalScan) {
            InternalScan iscan = (InternalScan)scan;
            memOnly = iscan.isCheckOnlyMemStore();
            filesOnly = iscan.isCheckOnlyStoreFiles();
        } else {
            memOnly = false;
            filesOnly = false;
        }
        LinkedList<KeyValueScanner> scanners = new LinkedList<KeyValueScanner>();
        if (!memOnly) {
            List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(this.store.getStorefiles(), this.cacheBlocks, this.isGet);
            for (StoreFileScanner sfs : sfScanners) {
                if (!sfs.shouldSeek(scan, columns)) continue;
                scanners.add(sfs);
            }
        }
        if (!filesOnly && this.store.memstore.shouldSeek(scan)) {
            scanners.addAll(this.store.memstore.getScanners());
        }
        return scanners;
    }

    @Override
    public synchronized KeyValue peek() {
        if (this.heap == null) {
            return this.lastTop;
        }
        return this.heap.peek();
    }

    @Override
    public KeyValue next() {
        throw new RuntimeException("Never call StoreScanner.next()");
    }

    @Override
    public synchronized void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this.store != null) {
            this.store.deleteChangedReaderObserver(this);
        }
        if (this.heap != null) {
            this.heap.close();
        }
        this.heap = null;
        this.lastTop = null;
    }

    @Override
    public synchronized boolean seek(KeyValue key) throws IOException {
        if (this.heap == null) {
            List<KeyValueScanner> scanners = this.getScanners();
            this.heap = new KeyValueHeap(scanners, this.store.comparator);
        }
        return this.heap.seek(key);
    }

    @Override
    public synchronized boolean next(List<KeyValue> outResult, int limit) throws IOException {
        KeyValue kv;
        this.checkReseek();
        if (this.heap == null) {
            this.close();
            return false;
        }
        KeyValue peeked = this.heap.peek();
        if (peeked == null) {
            this.close();
            return false;
        }
        if (this.matcher.row == null || !peeked.matchingRow(this.matcher.row)) {
            this.matcher.setRow(peeked.getRow());
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        block9: while ((kv = this.heap.peek()) != null) {
            KeyValue copyKv = new KeyValue(kv.getBuffer(), kv.getOffset(), kv.getLength());
            ScanQueryMatcher.MatchCode qcode = this.matcher.match(copyKv);
            switch (qcode) {
                case INCLUDE: {
                    results.add(copyKv);
                    this.heap.next();
                    if (limit <= 0 || results.size() != limit) continue block9;
                    break block9;
                }
                case DONE: {
                    outResult.addAll(results);
                    return true;
                }
                case DONE_SCAN: {
                    this.close();
                    outResult.addAll(results);
                    return false;
                }
                case SEEK_NEXT_ROW: {
                    if (!this.matcher.moreRowsMayExistAfter(kv)) {
                        outResult.addAll(results);
                        return false;
                    }
                    this.reseek(this.matcher.getKeyForNextRow(kv));
                    break;
                }
                case SEEK_NEXT_COL: {
                    this.reseek(this.matcher.getKeyForNextColumn(kv));
                    break;
                }
                case SKIP: {
                    this.heap.next();
                    break;
                }
                case SEEK_NEXT_USING_HINT: {
                    KeyValue nextKV = this.matcher.getNextKeyHint(kv);
                    if (nextKV != null) {
                        this.reseek(nextKV);
                        break;
                    }
                    this.heap.next();
                    break;
                }
                default: {
                    throw new RuntimeException("UNEXPECTED");
                }
            }
        }
        if (!results.isEmpty()) {
            outResult.addAll(results);
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public synchronized boolean next(List<KeyValue> outResult) throws IOException {
        return this.next(outResult, -1);
    }

    @Override
    public synchronized void updateReaders() throws IOException {
        if (this.closing) {
            return;
        }
        if (this.heap == null) {
            return;
        }
        this.lastTop = this.peek();
        this.heap.close();
        this.heap = null;
    }

    private void checkReseek() throws IOException {
        if (this.heap == null && this.lastTop != null) {
            this.resetScannerStack(this.lastTop);
            this.lastTop = null;
        }
    }

    private void resetScannerStack(KeyValue lastTopKey) throws IOException {
        if (this.heap != null) {
            throw new RuntimeException("StoreScanner.reseek run on an existing heap!");
        }
        List<KeyValueScanner> scanners = this.getScanners();
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(lastTopKey);
        }
        this.heap = new KeyValueHeap(scanners, this.store.comparator);
        KeyValue kv = this.heap.peek();
        if (kv == null) {
            kv = lastTopKey;
        }
        if (this.matcher.row == null || !kv.matchingRow(this.matcher.row)) {
            this.matcher.reset();
            this.matcher.setRow(kv.getRow());
        }
    }

    @Override
    public synchronized boolean reseek(KeyValue kv) throws IOException {
        return this.heap.reseek(kv);
    }

    @Override
    public long getSequenceID() {
        return 0L;
    }
}

