/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.regionserver.wal.WALObserver;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

public class HLog
implements Syncable {
    static final Log LOG;
    public static final byte[] METAFAMILY;
    static final byte[] METAROW;
    private static final String RECOVERED_EDITS_DIR = "recovered.edits";
    private static final Pattern EDITFILES_NAME_PATTERN;
    private final FileSystem fs;
    private final Path dir;
    private final Configuration conf;
    private List<WALObserver> listeners = new CopyOnWriteArrayList<WALObserver>();
    private final long optionalFlushInterval;
    private final long blocksize;
    private final int flushlogentries;
    private final String prefix;
    private final Path oldLogDir;
    private boolean logRollRequested;
    private static Class<? extends Writer> logWriterClass;
    private static Class<? extends Reader> logReaderClass;
    private OutputStream hdfs_out;
    private int initialReplication;
    private Method getNumCurrentReplicas;
    static final Object[] NO_ARGS;
    private boolean forceSync = false;
    Writer writer;
    final SortedMap<Long, Path> outputfiles = Collections.synchronizedSortedMap(new TreeMap());
    private final ConcurrentSkipListMap<byte[], Long> lastSeqWritten = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private volatile boolean closed = false;
    private final AtomicLong logSeqNum = new AtomicLong(0L);
    private volatile long filenum = -1L;
    private final AtomicInteger numEntries = new AtomicInteger(0);
    private final long logrollsize;
    private final Lock cacheFlushLock = new ReentrantLock();
    private final Object updateLock = new Object();
    private final boolean enabled;
    private final int maxLogs;
    private final LogSyncer logSyncerThread;
    private static final Pattern pattern;
    static byte[] COMPLETE_CACHE_FLUSH;
    private static volatile long writeOps;
    private static volatile long writeTime;
    private static volatile long syncOps;
    private static volatile long syncTime;
    public static final long FIXED_OVERHEAD;

    static void resetLogReaderClass() {
        logReaderClass = null;
    }

    public static long getWriteOps() {
        long ret = writeOps;
        writeOps = 0L;
        return ret;
    }

    public static long getWriteTime() {
        long ret = writeTime;
        writeTime = 0L;
        return ret;
    }

    public static long getSyncOps() {
        long ret = syncOps;
        syncOps = 0L;
        return ret;
    }

    public static long getSyncTime() {
        long ret = syncTime;
        syncTime = 0L;
        return ret;
    }

    public HLog(FileSystem fs, Path dir, Path oldLogDir, Configuration conf) throws IOException {
        this(fs, dir, oldLogDir, conf, null, true, null);
    }

    public HLog(FileSystem fs, Path dir, Path oldLogDir, Configuration conf, List<WALObserver> listeners, String prefix) throws IOException {
        this(fs, dir, oldLogDir, conf, listeners, true, prefix);
    }

    public HLog(FileSystem fs, Path dir, Path oldLogDir, Configuration conf, List<WALObserver> listeners, boolean failIfLogDirExists, String prefix) throws IOException {
        this.fs = fs;
        this.dir = dir;
        this.conf = conf;
        if (listeners != null) {
            for (WALObserver i : listeners) {
                this.registerWALActionsListener(i);
            }
        }
        this.flushlogentries = conf.getInt("hbase.regionserver.flushlogentries", 1);
        this.blocksize = conf.getLong("hbase.regionserver.hlog.blocksize", this.fs.getDefaultBlockSize());
        float multi = conf.getFloat("hbase.regionserver.logroll.multiplier", 0.95f);
        this.logrollsize = (long)((float)this.blocksize * multi);
        this.optionalFlushInterval = conf.getLong("hbase.regionserver.optionallogflushinterval", 1000L);
        if (failIfLogDirExists && fs.exists(dir)) {
            throw new IOException("Target HLog directory already exists: " + dir);
        }
        if (!fs.mkdirs(dir)) {
            throw new IOException("Unable to mkdir " + dir);
        }
        this.oldLogDir = oldLogDir;
        if (!fs.exists(oldLogDir) && !fs.mkdirs(this.oldLogDir)) {
            throw new IOException("Unable to mkdir " + this.oldLogDir);
        }
        this.maxLogs = conf.getInt("hbase.regionserver.maxlogs", 32);
        this.enabled = conf.getBoolean("hbase.regionserver.hlog.enabled", true);
        LOG.info((Object)("HLog configuration: blocksize=" + StringUtils.byteDesc((long)this.blocksize) + ", rollsize=" + StringUtils.byteDesc((long)this.logrollsize) + ", enabled=" + this.enabled + ", flushlogentries=" + this.flushlogentries + ", optionallogflushinternal=" + this.optionalFlushInterval + "ms"));
        this.prefix = prefix == null || prefix.isEmpty() ? "hlog" : URLEncoder.encode(prefix, "UTF8");
        this.rollWriter();
        this.getNumCurrentReplicas = null;
        Exception exception = null;
        if (this.hdfs_out != null) {
            try {
                this.getNumCurrentReplicas = this.hdfs_out.getClass().getMethod("getNumCurrentReplicas", new Class[0]);
                this.getNumCurrentReplicas.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                exception = e;
            }
            catch (SecurityException e) {
                exception = e;
                this.getNumCurrentReplicas = null;
            }
        }
        if (this.getNumCurrentReplicas != null) {
            LOG.info((Object)"Using getNumCurrentReplicas--HDFS-826");
        } else {
            LOG.info((Object)("getNumCurrentReplicas--HDFS-826 not available; hdfs_out=" + this.hdfs_out + ", exception=" + exception.getMessage()));
        }
        this.logSyncerThread = new LogSyncer(this.optionalFlushInterval);
        Threads.setDaemonThreadRunning(this.logSyncerThread, Thread.currentThread().getName() + ".logSyncer");
    }

    public void registerWALActionsListener(WALObserver listener) {
        this.listeners.add(listener);
    }

    public boolean unregisterWALActionsListener(WALObserver listener) {
        return this.listeners.remove(listener);
    }

    public long getFilenum() {
        return this.filenum;
    }

    public void setSequenceNumber(long newvalue) {
        long id = this.logSeqNum.get();
        while (id < newvalue && !this.logSeqNum.compareAndSet(id, newvalue)) {
            LOG.debug((Object)("Changed sequenceid from " + this.logSeqNum + " to " + newvalue));
            id = this.logSeqNum.get();
        }
    }

    public long getSequenceNumber() {
        return this.logSeqNum.get();
    }

    OutputStream getOutputStream() {
        return this.hdfs_out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] rollWriter() throws FailedLogCloseException, IOException {
        if (this.writer != null && this.numEntries.get() <= 0) {
            return null;
        }
        byte[][] regionsToFlush = null;
        this.cacheFlushLock.lock();
        try {
            if (this.closed) {
                byte[][] byArray = regionsToFlush;
                return byArray;
            }
            long currentFilenum = this.filenum;
            this.filenum = System.currentTimeMillis();
            Path newPath = this.computeFilename();
            Writer nextWriter = this.createWriterInstance(this.fs, newPath, this.conf);
            short nextInitialReplication = this.fs.getFileStatus(newPath).getReplication();
            OutputStream nextHdfsOut = null;
            if (nextWriter instanceof SequenceFileLogWriter) {
                nextHdfsOut = ((SequenceFileLogWriter)nextWriter).getDFSCOutputStream();
            }
            if (!this.listeners.isEmpty()) {
                for (WALObserver i : this.listeners) {
                    i.logRolled(newPath);
                }
            }
            Iterator<Map.Entry<Long, Path>> i$ = this.updateLock;
            synchronized (i$) {
                Path oldFile = this.cleanupCurrentWriter(currentFilenum);
                this.writer = nextWriter;
                this.initialReplication = nextInitialReplication;
                this.hdfs_out = nextHdfsOut;
                LOG.info((Object)((oldFile != null ? "Roll " + FSUtils.getPath(oldFile) + ", entries=" + this.numEntries.get() + ", filesize=" + this.fs.getFileStatus(oldFile).getLen() + ". " : "") + "New hlog " + FSUtils.getPath(newPath)));
                this.numEntries.set(0);
                this.logRollRequested = false;
            }
            if (this.outputfiles.size() > 0) {
                if (this.lastSeqWritten.isEmpty()) {
                    LOG.debug((Object)"Last sequenceid written is empty. Deleting all old hlogs");
                    for (Map.Entry<Long, Path> e : this.outputfiles.entrySet()) {
                        this.archiveLogFile(e.getValue(), e.getKey());
                    }
                    this.outputfiles.clear();
                } else {
                    regionsToFlush = this.cleanOldLogs();
                }
            }
        }
        finally {
            this.cacheFlushLock.unlock();
        }
        return regionsToFlush;
    }

    protected Writer createWriterInstance(FileSystem fs, Path path, Configuration conf) throws IOException {
        return HLog.createWriter(fs, path, conf);
    }

    public static Reader getReader(FileSystem fs, Path path, Configuration conf) throws IOException {
        try {
            if (logReaderClass == null) {
                logReaderClass = conf.getClass("hbase.regionserver.hlog.reader.impl", SequenceFileLogReader.class, Reader.class);
            }
            Reader reader = logReaderClass.newInstance();
            reader.init(fs, path, conf);
            return reader;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Cannot get log reader", e);
        }
    }

    public static Writer createWriter(FileSystem fs, Path path, Configuration conf) throws IOException {
        try {
            if (logWriterClass == null) {
                logWriterClass = conf.getClass("hbase.regionserver.hlog.writer.impl", SequenceFileLogWriter.class, Writer.class);
            }
            Writer writer = logWriterClass.newInstance();
            writer.init(fs, path, conf);
            return writer;
        }
        catch (Exception e) {
            IOException ie = new IOException("cannot get log writer");
            ie.initCause(e);
            throw ie;
        }
    }

    private byte[][] cleanOldLogs() throws IOException {
        Long oldestOutstandingSeqNum = this.getOldestOutstandingSeqNum();
        TreeSet<Long> sequenceNumbers = new TreeSet<Long>(this.outputfiles.headMap((long)oldestOutstandingSeqNum).keySet());
        int logsToRemove = sequenceNumbers.size();
        if (logsToRemove > 0) {
            if (LOG.isDebugEnabled()) {
                byte[] oldestRegion = this.getOldestRegion(oldestOutstandingSeqNum);
                LOG.debug((Object)("Found " + logsToRemove + " hlogs to remove" + " out of total " + this.outputfiles.size() + ";" + " oldest outstanding sequenceid is " + oldestOutstandingSeqNum + " from region " + Bytes.toString(oldestRegion)));
            }
            for (Long seq : sequenceNumbers) {
                this.archiveLogFile((Path)this.outputfiles.remove(seq), seq);
            }
        }
        byte[][] regions = null;
        int logCount = this.outputfiles.size();
        if (logCount > this.maxLogs && this.outputfiles != null && this.outputfiles.size() > 0 && (regions = HLog.findMemstoresWithEditsEqualOrOlderThan(this.outputfiles.firstKey(), this.lastSeqWritten)) != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < regions.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(Bytes.toStringBinary(regions[i]));
            }
            LOG.info((Object)("Too many hlogs: logs=" + logCount + ", maxlogs=" + this.maxLogs + "; forcing flush of " + regions.length + " regions(s): " + sb.toString()));
        }
        return regions;
    }

    static byte[][] findMemstoresWithEditsEqualOrOlderThan(long oldestWALseqid, Map<byte[], Long> regionsToSeqids) {
        ArrayList<byte[]> regions = null;
        for (Map.Entry<byte[], Long> e : regionsToSeqids.entrySet()) {
            if (e.getValue() > oldestWALseqid) continue;
            if (regions == null) {
                regions = new ArrayList<byte[]>();
            }
            regions.add(e.getKey());
        }
        return regions == null ? (byte[][])null : (byte[][])regions.toArray((T[])new byte[][]{HConstants.EMPTY_BYTE_ARRAY});
    }

    private Long getOldestOutstandingSeqNum() {
        return Collections.min(this.lastSeqWritten.values());
    }

    private byte[] getOldestRegion(Long oldestOutstandingSeqNum) {
        byte[] oldestRegion = null;
        for (Map.Entry<byte[], Long> e : this.lastSeqWritten.entrySet()) {
            if (e.getValue().longValue() != oldestOutstandingSeqNum.longValue()) continue;
            oldestRegion = e.getKey();
            break;
        }
        return oldestRegion;
    }

    private Path cleanupCurrentWriter(long currentfilenum) throws IOException {
        Path oldFile = null;
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                FailedLogCloseException flce = new FailedLogCloseException("#" + currentfilenum);
                flce.initCause(e);
                throw e;
            }
            if (currentfilenum >= 0L) {
                oldFile = this.computeFilename(currentfilenum);
                this.outputfiles.put(this.logSeqNum.get(), oldFile);
            }
        }
        return oldFile;
    }

    private void archiveLogFile(Path p, Long seqno) throws IOException {
        Path newPath = HLog.getHLogArchivePath(this.oldLogDir, p);
        LOG.info((Object)("moving old hlog file " + FSUtils.getPath(p) + " whose highest sequenceid is " + seqno + " to " + FSUtils.getPath(newPath)));
        if (!this.fs.rename(p, newPath)) {
            throw new IOException("Unable to rename " + p + " to " + newPath);
        }
    }

    protected Path computeFilename() {
        return this.computeFilename(this.filenum);
    }

    protected Path computeFilename(long filenum) {
        if (filenum < 0L) {
            throw new RuntimeException("hlog file number can't be < 0");
        }
        return new Path(this.dir, this.prefix + "." + filenum);
    }

    public void closeAndDelete() throws IOException {
        FileStatus[] files;
        this.close();
        for (FileStatus file : files = this.fs.listStatus(this.dir)) {
            Path p = HLog.getHLogArchivePath(this.oldLogDir, file.getPath());
            if (this.fs.rename(file.getPath(), p)) continue;
            throw new IOException("Unable to rename " + file.getPath() + " to " + p);
        }
        LOG.debug((Object)("Moved " + files.length + " log files to " + FSUtils.getPath(this.oldLogDir)));
        if (!this.fs.delete(this.dir, true)) {
            LOG.info((Object)("Unable to delete " + this.dir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.logSyncerThread.interrupt();
            this.logSyncerThread.join(this.optionalFlushInterval * 2L);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Exception while waiting for syncer thread to die", (Throwable)e);
        }
        this.cacheFlushLock.lock();
        try {
            if (!this.listeners.isEmpty()) {
                for (WALObserver i : this.listeners) {
                    i.logCloseRequested();
                }
            }
            Object object = this.updateLock;
            synchronized (object) {
                this.closed = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("closing hlog writer in " + this.dir.toString()));
                }
                this.writer.close();
            }
        }
        finally {
            this.cacheFlushLock.unlock();
        }
    }

    public void append(HRegionInfo regionInfo, WALEdit logEdit, long now, boolean isMetaRegion) throws IOException {
        byte[] regionName = regionInfo.getEncodedNameAsBytes();
        byte[] tableName = regionInfo.getTableDesc().getName();
        this.append(regionInfo, this.makeKey(regionName, tableName, -1L, now), logEdit);
    }

    protected HLogKey makeKey(byte[] regionName, byte[] tableName, long seqnum, long now) {
        return new HLogKey(regionName, tableName, seqnum, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(HRegionInfo regionInfo, HLogKey logKey, WALEdit logEdit) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot append; log is closed");
        }
        Object object = this.updateLock;
        synchronized (object) {
            long seqNum = this.obtainSeqNum();
            logKey.setLogSeqNum(seqNum);
            this.lastSeqWritten.putIfAbsent(regionInfo.getEncodedNameAsBytes(), seqNum);
            this.doWrite(regionInfo, logKey, logEdit);
            this.numEntries.incrementAndGet();
        }
        if (regionInfo.isMetaRegion() || !regionInfo.getTableDesc().isDeferredLogFlush()) {
            this.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(HRegionInfo info, byte[] tableName, WALEdit edits, long now) throws IOException {
        if (edits.isEmpty()) {
            return;
        }
        if (this.closed) {
            throw new IOException("Cannot append; log is closed");
        }
        Object object = this.updateLock;
        synchronized (object) {
            long seqNum = this.obtainSeqNum();
            byte[] hriKey = info.getEncodedNameAsBytes();
            this.lastSeqWritten.putIfAbsent(hriKey, seqNum);
            HLogKey logKey = this.makeKey(hriKey, tableName, seqNum, now);
            this.doWrite(info, logKey, edits);
            this.numEntries.incrementAndGet();
        }
        if (info.isMetaRegion() || !info.getTableDesc().isDeferredLogFlush()) {
            this.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws IOException {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
        }
        try {
            long now = System.currentTimeMillis();
            this.writer.sync();
            Object object2 = this.updateLock;
            synchronized (object2) {
                syncTime += System.currentTimeMillis() - now;
                ++syncOps;
                if (!this.logRollRequested) {
                    this.checkLowReplication();
                    if (this.writer.getLength() > this.logrollsize) {
                        this.requestLogRoll();
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.fatal((Object)"Could not append. Requesting close of hlog", (Throwable)e);
            this.requestLogRoll();
            throw e;
        }
    }

    private void checkLowReplication() {
        try {
            int numCurrentReplicas = this.getLogReplication();
            if (numCurrentReplicas != 0 && numCurrentReplicas < this.initialReplication) {
                LOG.warn((Object)("HDFS pipeline error detected. Found " + numCurrentReplicas + " replicas but expecting " + this.initialReplication + " replicas. " + " Requesting close of hlog."));
                this.requestLogRoll();
                this.logRollRequested = true;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to invoke DFSOutputStream.getNumCurrentReplicas" + e + " still proceeding ahead..."));
        }
    }

    int getLogReplication() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object repl;
        if (this.getNumCurrentReplicas != null && this.hdfs_out != null && (repl = this.getNumCurrentReplicas.invoke((Object)this.hdfs_out, NO_ARGS)) instanceof Integer) {
            return (Integer)repl;
        }
        return 0;
    }

    boolean canGetCurReplicas() {
        return this.getNumCurrentReplicas != null;
    }

    public void hsync() throws IOException {
        this.sync();
    }

    private void requestLogRoll() {
        if (!this.listeners.isEmpty()) {
            for (WALObserver i : this.listeners) {
                i.logRollRequested();
            }
        }
    }

    protected void doWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        if (!this.enabled) {
            return;
        }
        if (!this.listeners.isEmpty()) {
            for (WALObserver i : this.listeners) {
                i.visitLogEntryBeforeWrite(info, logKey, logEdit);
            }
        }
        try {
            long now = System.currentTimeMillis();
            this.writer.append(new Entry(logKey, logEdit));
            long took = System.currentTimeMillis() - now;
            writeTime += took;
            ++writeOps;
            if (took > 1000L) {
                long len = 0L;
                for (KeyValue kv : logEdit.getKeyValues()) {
                    len += (long)kv.getLength();
                }
                LOG.warn((Object)String.format("%s took %d ms appending an edit to hlog; editcount=%d, len~=%s", Thread.currentThread().getName(), took, this.numEntries.get(), StringUtils.humanReadableInt((long)len)));
            }
        }
        catch (IOException e) {
            LOG.fatal((Object)"Could not append. Requesting close of hlog", (Throwable)e);
            this.requestLogRoll();
            throw e;
        }
    }

    int getNumEntries() {
        return this.numEntries.get();
    }

    private long obtainSeqNum() {
        return this.logSeqNum.incrementAndGet();
    }

    int getNumLogFiles() {
        return this.outputfiles.size();
    }

    public long startCacheFlush() {
        this.cacheFlushLock.lock();
        return this.obtainSeqNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeCacheFlush(byte[] encodedRegionName, byte[] tableName, long logSeqId, boolean isMetaRegion) throws IOException {
        try {
            if (this.closed) {
                return;
            }
            Object object = this.updateLock;
            synchronized (object) {
                long now = System.currentTimeMillis();
                WALEdit edit = this.completeCacheFlushLogEdit();
                HLogKey key = this.makeKey(encodedRegionName, tableName, logSeqId, System.currentTimeMillis());
                this.writer.append(new Entry(key, edit));
                writeTime += System.currentTimeMillis() - now;
                ++writeOps;
                this.numEntries.incrementAndGet();
                Long seq = this.lastSeqWritten.get(encodedRegionName);
                if (seq != null && logSeqId >= seq) {
                    this.lastSeqWritten.remove(encodedRegionName);
                }
            }
            this.sync();
        }
        finally {
            this.cacheFlushLock.unlock();
        }
    }

    private WALEdit completeCacheFlushLogEdit() {
        KeyValue kv = new KeyValue(METAROW, METAFAMILY, null, System.currentTimeMillis(), COMPLETE_CACHE_FLUSH);
        WALEdit e = new WALEdit();
        e.add(kv);
        return e;
    }

    public void abortCacheFlush() {
        this.cacheFlushLock.unlock();
    }

    public static boolean isMetaFamily(byte[] family) {
        return Bytes.equals(METAFAMILY, family);
    }

    public static Class<? extends HLogKey> getKeyClass(Configuration conf) {
        return conf.getClass("hbase.regionserver.hlog.keyclass", HLogKey.class);
    }

    public static HLogKey newKey(Configuration conf) throws IOException {
        Class<? extends HLogKey> keyClass = HLog.getKeyClass(conf);
        try {
            return keyClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException("cannot create hlog key");
        }
        catch (IllegalAccessException e) {
            throw new IOException("cannot create hlog key");
        }
    }

    public static String getHLogDirectoryName(HServerInfo info) {
        return HLog.getHLogDirectoryName(info.getServerName());
    }

    public static String getHLogDirectoryName(String serverAddress, long startCode) {
        if (serverAddress == null || serverAddress.length() == 0) {
            return null;
        }
        return HLog.getHLogDirectoryName(HServerInfo.getServerName(serverAddress, startCode));
    }

    public static String getHLogDirectoryName(String serverName) {
        StringBuilder dirName = new StringBuilder(".logs");
        dirName.append("/");
        dirName.append(serverName);
        return dirName.toString();
    }

    protected Path getDir() {
        return this.dir;
    }

    public static boolean validateHLogFilename(String filename) {
        return pattern.matcher(filename).matches();
    }

    static Path getHLogArchivePath(Path oldLogDir, Path p) {
        return new Path(oldLogDir, p.getName());
    }

    static String formatRecoveredEditsFileName(long seqid) {
        return String.format("%019d", seqid);
    }

    public static NavigableSet<Path> getSplitEditFilesSorted(final FileSystem fs, Path regiondir) throws IOException {
        Path editsdir = HLog.getRegionDirRecoveredEditsDir(regiondir);
        FileStatus[] files = fs.listStatus(editsdir, new PathFilter(){

            public boolean accept(Path p) {
                boolean result = false;
                try {
                    Matcher m = EDITFILES_NAME_PATTERN.matcher(p.getName());
                    result = fs.isFile(p) && m.matches();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed isFile check on " + p));
                }
                return result;
            }
        });
        TreeSet<Path> filesSorted = new TreeSet<Path>();
        if (files == null) {
            return filesSorted;
        }
        for (FileStatus status : files) {
            filesSorted.add(status.getPath());
        }
        return filesSorted;
    }

    public static Path moveAsideBadEditsFile(FileSystem fs, Path edits) throws IOException {
        Path moveAsideName = new Path(edits.getParent(), edits.getName() + "." + System.currentTimeMillis());
        if (!fs.rename(edits, moveAsideName)) {
            LOG.warn((Object)("Rename failed from " + edits + " to " + moveAsideName));
        }
        return moveAsideName;
    }

    public static Path getRegionDirRecoveredEditsDir(Path regiondir) {
        return new Path(regiondir, RECOVERED_EDITS_DIR);
    }

    private static void usage() {
        System.err.println("Usage: HLog <ARGS>");
        System.err.println("Arguments:");
        System.err.println(" --dump  Dump textual representation of passed one or more files");
        System.err.println("         For example: HLog --dump hdfs://example.com:9000/hbase/.logs/MACHINE/LOGFILE");
        System.err.println(" --split Split the passed directory of WAL logs");
        System.err.println("         For example: HLog --split hdfs://example.com:9000/hbase/.logs/DIR");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dump(Configuration conf, Path p) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(p)) {
            throw new FileNotFoundException(p.toString());
        }
        if (!fs.isFile(p)) {
            throw new IOException(p + " is not a file");
        }
        Reader log = HLog.getReader(fs, p, conf);
        try {
            Entry entry;
            int count = 0;
            while ((entry = log.next()) != null) {
                System.out.println("#" + count + ", pos=" + log.getPosition() + " " + entry.toString());
                ++count;
            }
        }
        finally {
            log.close();
        }
    }

    private static void split(Configuration conf, Path p) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(p)) {
            throw new FileNotFoundException(p.toString());
        }
        Path baseDir = new Path(conf.get("hbase.rootdir"));
        Path oldLogDir = new Path(baseDir, ".oldlogs");
        if (!fs.getFileStatus(p).isDir()) {
            throw new IOException(p + " is not a directory");
        }
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter(conf, baseDir, p, oldLogDir, fs);
        logSplitter.splitLog();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            HLog.usage();
            System.exit(-1);
        }
        boolean dump = true;
        if (args[0].compareTo("--dump") != 0) {
            if (args[0].compareTo("--split") == 0) {
                dump = false;
            } else {
                HLog.usage();
                System.exit(-1);
            }
        }
        Configuration conf = HBaseConfiguration.create();
        for (int i = 1; i < args.length; ++i) {
            try {
                conf.set("fs.default.name", args[i]);
                conf.set("fs.defaultFS", args[i]);
                Path logPath = new Path(args[i]);
                if (dump) {
                    HLog.dump(conf, logPath);
                    continue;
                }
                HLog.split(conf, logPath);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                System.exit(-1);
            }
        }
    }

    static {
        block2: {
            LOG = LogFactory.getLog(HLog.class);
            METAFAMILY = Bytes.toBytes("METAFAMILY");
            METAROW = Bytes.toBytes("METAROW");
            EDITFILES_NAME_PATTERN = Pattern.compile("-?[0-9]+");
            NO_ARGS = new Object[0];
            pattern = Pattern.compile(".*\\.\\d*");
            try {
                COMPLETE_CACHE_FLUSH = "HBASE::CACHEFLUSH".getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 5 * ClassSize.REFERENCE + ClassSize.ATOMIC_INTEGER + 4 + 24);
    }

    public static class Entry
    implements Writable {
        private WALEdit edit;
        private HLogKey key;

        public Entry() {
            this.edit = new WALEdit();
            this.key = new HLogKey();
        }

        public Entry(HLogKey key, WALEdit edit) {
            this.key = key;
            this.edit = edit;
        }

        public WALEdit getEdit() {
            return this.edit;
        }

        public HLogKey getKey() {
            return this.key;
        }

        public String toString() {
            return this.key + "=" + this.edit;
        }

        public void write(DataOutput dataOutput) throws IOException {
            this.key.write(dataOutput);
            this.edit.write(dataOutput);
        }

        public void readFields(DataInput dataInput) throws IOException {
            this.key.readFields(dataInput);
            this.edit.readFields(dataInput);
        }
    }

    class LogSyncer
    extends Thread {
        private final long optionalFlushInterval;
        private boolean syncerShuttingDown = false;

        LogSyncer(long optionalFlushInterval) {
            this.optionalFlushInterval = optionalFlushInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Thread.sleep(this.optionalFlushInterval);
                    HLog.this.sync();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Error while syncing, requesting close of hlog ", (Throwable)e);
                HLog.this.requestLogRoll();
            }
            catch (InterruptedException e) {
                LOG.debug((Object)(this.getName() + " interrupted while waiting for sync requests"));
            }
            finally {
                this.syncerShuttingDown = true;
                LOG.info((Object)(this.getName() + " exiting"));
            }
        }
    }

    public static interface Writer {
        public void init(FileSystem var1, Path var2, Configuration var3) throws IOException;

        public void close() throws IOException;

        public void sync() throws IOException;

        public void append(Entry var1) throws IOException;

        public long getLength() throws IOException;
    }

    public static interface Reader {
        public void init(FileSystem var1, Path var2, Configuration var3) throws IOException;

        public void close() throws IOException;

        public Entry next() throws IOException;

        public Entry next(Entry var1) throws IOException;

        public void seek(long var1) throws IOException;

        public long getPosition() throws IOException;
    }
}

