/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cache.GrowingLRUMap;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlListener;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.AccessControlUtils;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.core.security.authorization.PrivilegeBits;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.ACLTemplate;
import org.apache.jackrabbit.core.security.authorization.acl.EntryCollector;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilter;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilterImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.util.Text;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileAclUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;

public class PentahoCompiledPermissionsImpl
extends AbstractCompiledPermissions
implements AccessControlListener {
    private final List<String> principalNames;
    private final SessionImpl session;
    private final EntryCollector entryCollector;
    private final AccessControlUtils util;
    private final Map<ItemId, Boolean> readCache = new GrowingLRUMap(1024, 5000);
    private final Object monitor = new Object();
    private final Object readMonitor = new Object();

    PentahoCompiledPermissionsImpl(Set<Principal> principals, SessionImpl session, EntryCollector entryCollector, AccessControlUtils util, boolean listenToEvents) throws RepositoryException {
        this.session = session;
        this.entryCollector = entryCollector;
        this.util = util;
        this.principalNames = new ArrayList<String>(principals.size());
        for (Principal princ : principals) {
            this.principalNames.add(princ.getName());
        }
        if (listenToEvents) {
            entryCollector.addListener((AccessControlListener)this);
        }
    }

    private AbstractCompiledPermissions.Result buildResult(NodeImpl node, boolean isExistingNode, boolean isAcItem, EntryFilterImpl filter) throws RepositoryException {
        NodeId nodeId;
        NodeImpl n = ACLProvider.getNode((NodeImpl)node, (boolean)isAcItem);
        Iterator entries = this.entryCollector.collectEntries(n, (EntryFilter)filter).iterator();
        int allows = 0;
        int denies = 0;
        PrivilegeBits allowBits = PrivilegeBits.getInstance();
        PrivilegeBits denyBits = PrivilegeBits.getInstance();
        PrivilegeBits parentAllowBits = PrivilegeBits.getInstance();
        PrivilegeBits parentDenyBits = PrivilegeBits.getInstance();
        String parentPath = Text.getRelativeParent((String)filter.getPath(), (int)1);
        NodeId nodeId2 = nodeId = node == null ? null : node.getNodeId();
        while (entries.hasNext()) {
            int permissions;
            boolean isLocalAndDoesNotInheritPermissions;
            ACLTemplate.Entry ace = (ACLTemplate.Entry)entries.next();
            PrivilegeBits entryBits = ace.getPrivilegeBits();
            boolean isLocal = isExistingNode && ace.isLocal(nodeId);
            boolean matchesParent = !isLocal && ace.matches(parentPath);
            boolean bl = isLocalAndDoesNotInheritPermissions = isLocal && this.isValidPentahoNode(node) && !this.isEntriesInheriting(node);
            if (matchesParent || isLocalAndDoesNotInheritPermissions) {
                if (ace.isAllow()) {
                    parentAllowBits.addDifference(entryBits, parentDenyBits);
                } else {
                    parentDenyBits.addDifference(entryBits, parentAllowBits);
                }
            }
            if (ace.isAllow()) {
                allowBits.addDifference(entryBits, denyBits);
                permissions = PrivilegeRegistry.calculatePermissions((PrivilegeBits)allowBits, (PrivilegeBits)parentAllowBits, (boolean)true, (boolean)isAcItem);
                allows |= Permission.diff((int)permissions, (int)denies);
                continue;
            }
            denyBits.addDifference(entryBits, allowBits);
            permissions = PrivilegeRegistry.calculatePermissions((PrivilegeBits)denyBits, (PrivilegeBits)parentDenyBits, (boolean)false, (boolean)isAcItem);
            denies |= Permission.diff((int)permissions, (int)allows);
        }
        return new AbstractCompiledPermissions.Result(allows, denies, allowBits, denyBits);
    }

    protected AbstractCompiledPermissions.Result buildResult(Path absPath) throws RepositoryException {
        NodeImpl node;
        boolean existingNode = false;
        ItemManager itemMgr = this.session.getItemManager();
        try {
            ItemImpl item = itemMgr.getItem(absPath);
            if (item.isNode()) {
                node = (NodeImpl)item;
                existingNode = true;
            } else {
                node = (NodeImpl)item.getParent();
            }
        }
        catch (RepositoryException e) {
            int index;
            Name name;
            Path.Element[] elems = absPath.getElements();
            NodeImpl parent = (NodeImpl)this.session.getRootNode();
            for (int i = 1; i < elems.length - 1 && parent.hasNode(name = elems[i].getName(), index = elems[i].getIndex()); ++i) {
                parent = parent.getNode(name, index);
            }
            node = parent;
        }
        if (node == null) {
            throw new ItemNotFoundException("Item out of hierarchy.");
        }
        boolean isAcItem = this.util.isAcItem(absPath);
        return this.buildResult(node, existingNode, isAcItem, new EntryFilterImpl(this.principalNames, absPath, (PathResolver)this.session));
    }

    protected AbstractCompiledPermissions.Result buildRepositoryResult() throws RepositoryException {
        return this.buildResult(null, true, false, new EntryFilterImpl(this.principalNames, this.session.getQPath("/"), (PathResolver)this.session));
    }

    protected PrivilegeManagerImpl getPrivilegeManagerImpl() throws RepositoryException {
        return (PrivilegeManagerImpl)((JackrabbitWorkspace)this.session.getWorkspace()).getPrivilegeManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache() {
        Object object = this.monitor;
        synchronized (object) {
            this.readCache.clear();
        }
        super.clearCache();
    }

    public void close() {
        this.entryCollector.removeListener((AccessControlListener)this);
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRead(Path path, ItemId itemId) throws RepositoryException {
        ItemId id = itemId == null ? this.session.getHierarchyManager().resolvePath(path) : itemId;
        boolean isExistingNode = id.denotesNode();
        boolean canRead = false;
        Object object = this.monitor;
        synchronized (object) {
            if (this.readCache.containsKey(id)) {
                return this.readCache.get(id);
            }
        }
        ItemManager itemMgr = this.session.getItemManager();
        NodeId nodeId = isExistingNode ? (NodeId)id : ((PropertyId)id).getParentId();
        NodeImpl node = (NodeImpl)itemMgr.getItem((ItemId)nodeId);
        boolean isAcItem = this.util.isAcItem((ItemImpl)node);
        EntryFilterImpl filter = path == null ? new EntryFilterImpl(this.principalNames, id, this.session) : new EntryFilterImpl(this.principalNames, path, (PathResolver)this.session);
        if (isAcItem) {
            AbstractCompiledPermissions.Result result = this.buildResult(node, isExistingNode, isAcItem, filter);
            canRead = result.grants(1);
        } else {
            for (AccessControlEntry accessControlEntry : this.entryCollector.collectEntries(node, (EntryFilter)filter)) {
                ACLTemplate.Entry ace = (ACLTemplate.Entry)accessControlEntry;
                if (!ace.getPrivilegeBits().includesRead()) continue;
                canRead = ace.isAllow();
                break;
            }
        }
        Object object2 = this.monitor;
        synchronized (object2) {
            this.readCache.put(id, canRead);
        }
        return canRead;
    }

    public void acModified(AccessControlModifications modifications) {
        this.clearCache();
    }

    private boolean isEntriesInheriting(NodeImpl node) throws RepositoryException {
        return JcrRepositoryFileAclUtils.getAclMetadata((Session)this.session, node.getPath(), (AccessControlList)new ACLTemplate(node.getNode(AccessControlConstants.N_POLICY))).isEntriesInheriting();
    }

    private boolean isBelowRootFolder(NodeImpl node) throws RepositoryException {
        String tenantRootFolderPath = ServerRepositoryPaths.getTenantRootFolderPath() + "/";
        return node != null && node.getPath().startsWith(tenantRootFolderPath) && node.getPath().replace(tenantRootFolderPath, "").length() > 0;
    }

    private boolean isValidPentahoNode(NodeImpl node) throws RepositoryException {
        return node != null && this.isBelowRootFolder(node) && JcrRepositoryFileUtils.isPentahoHierarchyNode((Session)this.session, new PentahoJcrConstants((Session)this.session), (Node)node);
    }
}

