/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.repository2.messages.Messages;
import org.springframework.util.Assert;

public class ExceptionLoggingDecorator
implements IUnifiedRepository {
    private static final Log logger = LogFactory.getLog(ExceptionLoggingDecorator.class);
    private final IUnifiedRepository delegatee;
    private final Map<String, ExceptionConverter> exceptionConverterMap;

    public ExceptionLoggingDecorator(IUnifiedRepository delegatee, Map<String, ExceptionConverter> exceptionConverterMap) {
        Assert.notNull((Object)delegatee);
        this.delegatee = delegatee;
        this.exceptionConverterMap = exceptionConverterMap;
    }

    public boolean canUnlockFile(final Serializable fileId) {
        return this.callLogThrow(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.canUnlockFile(fileId);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.canUnlockFile", new Object[]{fileId}));
    }

    public RepositoryFile createFile(final Serializable parentFolderId, final RepositoryFile file, final IRepositoryFileData data, final String versionMessage) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.createFile(parentFolderId, file, data, versionMessage);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.createFile", new Object[]{file.getName()}));
    }

    public RepositoryFile createFolder(final Serializable parentFolderId, final RepositoryFile file, final String versionMessage) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.createFolder(parentFolderId, file, versionMessage);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.createFolder", new Object[]{file.getName()}));
    }

    public void deleteFile(final Serializable fileId, final boolean permanent, final String versionMessage) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.deleteFile(fileId, permanent, versionMessage);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.deleteFile", new Object[]{fileId}));
    }

    public void deleteFile(final Serializable fileId, final String versionMessage) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.deleteFile(fileId, versionMessage);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.deleteFile", new Object[]{fileId}));
    }

    public void deleteFileAtVersion(final Serializable fileId, final Serializable versionId) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.deleteFileAtVersion(fileId, versionId);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.deleteFileAtVersion", new Object[]{fileId, versionId}));
    }

    public RepositoryFileAcl getAcl(final Serializable fileId) {
        return this.callLogThrow(new Callable<RepositoryFileAcl>(){

            @Override
            public RepositoryFileAcl call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getAcl(fileId);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getAcl", new Object[]{fileId}));
    }

    public List<RepositoryFile> getChildren(final RepositoryRequest repositoryRequest) {
        return this.callLogThrow(new Callable<List<RepositoryFile>>(){

            @Override
            public List<RepositoryFile> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getChildren(repositoryRequest);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getChildren", new Object[]{repositoryRequest.getPath()}));
    }

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable folderId) {
        return this.getChildren(folderId, "", false);
    }

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable folderId, String filter) {
        return this.getChildren(folderId, filter, false);
    }

    @Deprecated
    public List<RepositoryFile> getChildren(Serializable folderId, String filter, Boolean showHiddenFiles) {
        return this.getChildren(new RepositoryRequest(folderId.toString(), showHiddenFiles, Integer.valueOf(-1), filter));
    }

    public <T extends IRepositoryFileData> T getDataAtVersionForExecute(final Serializable fileId, final Serializable versionId, final Class<T> dataClass) {
        return (T)((IRepositoryFileData)this.callLogThrow(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getDataAtVersionForExecute(fileId, versionId, dataClass);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getDataAtVersion", new Object[]{fileId, versionId})));
    }

    public <T extends IRepositoryFileData> T getDataAtVersionForRead(final Serializable fileId, final Serializable versionId, final Class<T> dataClass) {
        return (T)((IRepositoryFileData)this.callLogThrow(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getDataAtVersionForRead(fileId, versionId, dataClass);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getDataAtVersion", new Object[]{fileId, versionId})));
    }

    public <T extends IRepositoryFileData> T getDataForExecute(final Serializable fileId, final Class<T> dataClass) {
        return (T)((IRepositoryFileData)this.callLogThrow(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getDataForExecute(fileId, dataClass);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getData", new Object[]{fileId})));
    }

    public <T extends IRepositoryFileData> List<T> getDataForExecuteInBatch(final List<RepositoryFile> files, final Class<T> dataClass) {
        return (List)this.callLogThrow(new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getDataForReadInBatch(files, dataClass);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getDataInBatch"));
    }

    public <T extends IRepositoryFileData> T getDataForRead(final Serializable fileId, final Class<T> dataClass) {
        return (T)((IRepositoryFileData)this.callLogThrow(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getDataForRead(fileId, dataClass);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getData", new Object[]{fileId})));
    }

    public <T extends IRepositoryFileData> List<T> getDataForReadInBatch(final List<RepositoryFile> files, final Class<T> dataClass) {
        return (List)this.callLogThrow(new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getDataForReadInBatch(files, dataClass);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getDataInBatch"));
    }

    public List<RepositoryFile> getDeletedFiles(final String origParentFolderPath) {
        return this.callLogThrow(new Callable<List<RepositoryFile>>(){

            @Override
            public List<RepositoryFile> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getDeletedFiles(origParentFolderPath);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getDeletedFilesInFolder", new Object[]{origParentFolderPath}));
    }

    public List<RepositoryFile> getDeletedFiles(final String origParentFolderPath, final String filter) {
        return this.callLogThrow(new Callable<List<RepositoryFile>>(){

            @Override
            public List<RepositoryFile> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getDeletedFiles(origParentFolderPath, filter);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getDeletedFilesInFolder", new Object[]{origParentFolderPath}));
    }

    public List<RepositoryFile> getDeletedFiles() {
        return this.callLogThrow(new Callable<List<RepositoryFile>>(){

            @Override
            public List<RepositoryFile> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getDeletedFiles();
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getDeletedFiles"));
    }

    public List<RepositoryFileAce> getEffectiveAces(final Serializable fileId) {
        return this.callLogThrow(new Callable<List<RepositoryFileAce>>(){

            @Override
            public List<RepositoryFileAce> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getEffectiveAces(fileId);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getEffectiveAces", new Object[]{fileId}));
    }

    public List<RepositoryFileAce> getEffectiveAces(final Serializable fileId, final boolean forceEntriesInheriting) {
        return this.callLogThrow(new Callable<List<RepositoryFileAce>>(){

            @Override
            public List<RepositoryFileAce> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getEffectiveAces(fileId, forceEntriesInheriting);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getEffectiveAces", new Object[]{fileId}));
    }

    public RepositoryFile getFile(final String path) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getFile(path);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getFile", new Object[]{path}));
    }

    public RepositoryFile getFile(final String path, final boolean loadLocaleMaps) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getFile(path, loadLocaleMaps);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getFile", new Object[]{path}));
    }

    public RepositoryFile getFileAtVersion(final Serializable fileId, final Serializable versionId) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getFileAtVersion(fileId, versionId);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getFileAtVersion", new Object[]{fileId, versionId}));
    }

    public RepositoryFile getFileById(final Serializable fileId) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getFileById(fileId);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getFileById", new Object[]{fileId}));
    }

    public RepositoryFile getFileById(final Serializable fileId, final boolean loadLocaleMaps) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getFileById(fileId, loadLocaleMaps);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getFileById", new Object[]{fileId}));
    }

    public RepositoryFile getFile(final String path, final IPentahoLocale locale) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getFile(path, locale);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getFile", new Object[]{path}));
    }

    public RepositoryFile getFileById(final Serializable fileId, final IPentahoLocale locale) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getFileById(fileId, locale);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getFileById", new Object[]{fileId}));
    }

    public RepositoryFile getFile(final String path, final boolean loadLocaleMaps, final IPentahoLocale locale) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getFile(path, loadLocaleMaps, locale);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getFile", new Object[]{path}));
    }

    public RepositoryFile getFileById(final Serializable fileId, final boolean loadLocaleMaps, final IPentahoLocale locale) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getFileById(fileId, loadLocaleMaps, locale);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getFileById", new Object[]{fileId}));
    }

    public List<VersionSummary> getVersionSummaries(final Serializable fileId) {
        return this.callLogThrow(new Callable<List<VersionSummary>>(){

            @Override
            public List<VersionSummary> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getVersionSummaries(fileId);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getVersionSummaries", new Object[]{fileId}));
    }

    public VersionSummary getVersionSummary(final Serializable fileId, final Serializable versionId) {
        return this.callLogThrow(new Callable<VersionSummary>(){

            @Override
            public VersionSummary call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getVersionSummary(fileId, versionId);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getVersionSummary", new Object[]{fileId, versionId}));
    }

    public List<VersionSummary> getVersionSummaryInBatch(final List<RepositoryFile> files) {
        return this.callLogThrow(new Callable<List<VersionSummary>>(){

            @Override
            public List<VersionSummary> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getVersionSummaryInBatch(files);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getVersionSummaryInBatch"));
    }

    public boolean hasAccess(final String path, final EnumSet<RepositoryFilePermission> permissions) {
        return this.callLogThrow(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.hasAccess(path, permissions);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.hasAccess", new Object[]{path}));
    }

    public void lockFile(final Serializable fileId, final String message) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.lockFile(fileId, message);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.lockFile", new Object[]{fileId}));
    }

    public void moveFile(final Serializable fileId, final String destAbsPath, final String versionMessage) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.moveFile(fileId, destAbsPath, versionMessage);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.moveFile", new Object[]{fileId, destAbsPath}));
    }

    public void copyFile(final Serializable fileId, final String destAbsPath, final String versionMessage) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.copyFile(fileId, destAbsPath, versionMessage);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.copyFile", new Object[]{fileId, destAbsPath}));
    }

    public void restoreFileAtVersion(final Serializable fileId, final Serializable versionId, final String versionMessage) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.restoreFileAtVersion(fileId, versionId, versionMessage);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.restoreFileAtVersion", new Object[]{fileId, versionId}));
    }

    public void undeleteFile(final Serializable fileId, final String versionMessage) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.undeleteFile(fileId, versionMessage);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.undeleteFile", new Object[]{fileId}));
    }

    public void unlockFile(final Serializable fileId) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.unlockFile(fileId);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.unlockFile", new Object[]{fileId}));
    }

    public RepositoryFileAcl updateAcl(final RepositoryFileAcl acl) {
        return this.callLogThrow(new Callable<RepositoryFileAcl>(){

            @Override
            public RepositoryFileAcl call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.updateAcl(acl);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.updateAcl", new Object[]{acl != null ? acl.getId() : null}));
    }

    public RepositoryFile updateFile(final RepositoryFile file, final IRepositoryFileData data, final String versionMessage) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.updateFile(file, data, versionMessage);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.updateFile", new Object[]{file != null ? file.getId() : null}));
    }

    public RepositoryFileTree getTree(final RepositoryRequest repositoryRequest) {
        return this.callLogThrow(new Callable<RepositoryFileTree>(){

            @Override
            public RepositoryFileTree call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getTree(repositoryRequest);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getTree", new Object[]{repositoryRequest.getPath()}));
    }

    @Deprecated
    public RepositoryFileTree getTree(String path, int depth, String filter, boolean showHidden) {
        return this.getTree(new RepositoryRequest(path, Boolean.valueOf(showHidden), Integer.valueOf(depth), filter));
    }

    public RepositoryFile createFile(final Serializable parentFolderId, final RepositoryFile file, final IRepositoryFileData data, final RepositoryFileAcl acl, final String versionMessage) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.createFile(parentFolderId, file, data, acl, versionMessage);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.createFile", new Object[]{file.getName()}));
    }

    public RepositoryFile createFolder(final Serializable parentFolderId, final RepositoryFile file, final RepositoryFileAcl acl, final String versionMessage) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.createFolder(parentFolderId, file, acl, versionMessage);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.createFolder", new Object[]{file.getName()}));
    }

    private <T> T callLogThrow(Callable<T> callable, String message) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            String refNum = UUID.randomUUID().toString();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getInstance().getString("ExceptionLoggingDecorator.referenceNumber", new Object[]{refNum}), (Throwable)e);
            }
            List throwablesInStack = ExceptionUtils.getThrowableList((Throwable)e);
            Collections.reverse(throwablesInStack);
            for (Throwable t : throwablesInStack) {
                String className = t.getClass().getName();
                if (!this.exceptionConverterMap.containsKey(className)) continue;
                throw this.exceptionConverterMap.get(className).convertException((Exception)t, message, refNum);
            }
            throw new UnifiedRepositoryException(Messages.getInstance().getString("ExceptionLoggingDecorator.generalException", new Object[]{message, refNum}));
        }
    }

    public List<RepositoryFile> getReferrers(final Serializable fileId) {
        return this.callLogThrow(new Callable<List<RepositoryFile>>(){

            @Override
            public List<RepositoryFile> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getReferrers(fileId);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getReferrers", new Object[]{fileId}));
    }

    public void setFileMetadata(final Serializable fileId, final Map<String, Serializable> metadataMap) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.setFileMetadata(fileId, metadataMap);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.setFileMetadata", new Object[]{fileId, metadataMap}));
    }

    public Map<String, Serializable> getFileMetadata(final Serializable fileId) {
        return this.callLogThrow(new Callable<Map<String, Serializable>>(){

            @Override
            public Map<String, Serializable> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getFileMetadata(fileId);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getFileMetadata", new Object[]{fileId}));
    }

    public List<Character> getReservedChars() {
        return this.callLogThrow(new Callable<List<Character>>(){

            @Override
            public List<Character> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getReservedChars();
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getReservedChars"));
    }

    public List<Locale> getAvailableLocalesForFileById(final Serializable fileId) {
        return this.callLogThrow(new Callable<List<Locale>>(){

            @Override
            public List<Locale> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getAvailableLocalesForFileById(fileId);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getAvailableLocalesForFile", new Object[]{fileId}));
    }

    public List<Locale> getAvailableLocalesForFileByPath(final String relPath) {
        return this.callLogThrow(new Callable<List<Locale>>(){

            @Override
            public List<Locale> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getAvailableLocalesForFileByPath(relPath);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getAvailableLocalesForFile", new Object[]{relPath}));
    }

    public List<Locale> getAvailableLocalesForFile(final RepositoryFile repositoryFile) {
        return this.callLogThrow(new Callable<List<Locale>>(){

            @Override
            public List<Locale> call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getAvailableLocalesForFile(repositoryFile);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getAvailableLocalesForFile", new Object[]{repositoryFile.getId()}));
    }

    public Properties getLocalePropertiesForFileById(final Serializable fileId, final String locale) {
        return this.callLogThrow(new Callable<Properties>(){

            @Override
            public Properties call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getLocalePropertiesForFileById(fileId, locale);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getLocalePropertiesForFile", new Object[]{fileId}));
    }

    public Properties getLocalePropertiesForFileByPath(final String relPath, final String locale) {
        return this.callLogThrow(new Callable<Properties>(){

            @Override
            public Properties call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getLocalePropertiesForFileByPath(relPath, locale);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getLocalePropertiesForFile", new Object[]{relPath}));
    }

    public Properties getLocalePropertiesForFile(final RepositoryFile repositoryFile, final String locale) {
        return this.callLogThrow(new Callable<Properties>(){

            @Override
            public Properties call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.getLocalePropertiesForFile(repositoryFile, locale);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.getLocalePropertiesForFile", new Object[]{repositoryFile.getId()}));
    }

    public void setLocalePropertiesForFileById(final Serializable fileId, final String locale, final Properties properties) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.setLocalePropertiesForFileById(fileId, locale, properties);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.setLocalePropertiesForFile", new Object[]{fileId}));
    }

    public void setLocalePropertiesForFileByPath(final String relPath, final String locale, final Properties properties) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.setLocalePropertiesForFileByPath(relPath, locale, properties);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.setLocalePropertiesForFile", new Object[]{relPath}));
    }

    public void setLocalePropertiesForFile(final RepositoryFile repositoryFile, final String locale, final Properties properties) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.setLocalePropertiesForFile(repositoryFile, locale, properties);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.setLocalePropertiesForFile", new Object[]{repositoryFile.getId()}));
    }

    public void deleteLocalePropertiesForFile(final RepositoryFile repositoryFile, final String locale) {
        this.callLogThrow(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExceptionLoggingDecorator.this.delegatee.deleteLocalePropertiesForFile(repositoryFile, locale);
                return null;
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.deleteLocalePropertiesForFile", new Object[]{repositoryFile.getId()}));
    }

    public RepositoryFile updateFolder(final RepositoryFile folder, final String versionMessage) {
        return this.callLogThrow(new Callable<RepositoryFile>(){

            @Override
            public RepositoryFile call() throws Exception {
                return ExceptionLoggingDecorator.this.delegatee.updateFolder(folder, versionMessage);
            }
        }, Messages.getInstance().getString("ExceptionLoggingDecorator.updateFile", new Object[]{folder != null ? folder.getId() : null}));
    }

    public static interface ExceptionConverter {
        public UnifiedRepositoryException convertException(Exception var1, String var2, String var3);
    }
}

