/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IRepositoryAccessVoter;
import org.pentaho.platform.api.repository2.unified.IRepositoryAccessVoterManager;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.springframework.util.Assert;

public class RepositoryAccessVoterManagerInst
implements IRepositoryAccessVoterManager {
    private IAuthorizationPolicy authorizationPolicy;
    private List<IRepositoryAccessVoter> voters;

    public RepositoryAccessVoterManagerInst(IAuthorizationPolicy authorizationPolicy) {
        this.authorizationPolicy = authorizationPolicy;
    }

    public RepositoryAccessVoterManagerInst(List<IRepositoryAccessVoter> voters, IAuthorizationPolicy authorizationPolicy) {
        this(authorizationPolicy);
        Assert.notNull(voters);
        this.voters = new ArrayList<IRepositoryAccessVoter>();
        this.voters.addAll(voters);
    }

    public void registerVoter(IRepositoryAccessVoter voter) {
        this.voters.add(voter);
    }

    public boolean hasAccess(RepositoryFile file, RepositoryFilePermission operation, RepositoryFileAcl repositoryFileAcl, IPentahoSession session) {
        if (this.voters != null && !this.authorizationPolicy.isAllowed("org.pentaho.security.administerSecurity")) {
            for (IRepositoryAccessVoter voter : this.voters) {
                if (voter.hasAccess(file, operation, repositoryFileAcl, session)) continue;
                return false;
            }
        }
        return true;
    }
}

