/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.messages.Messages;
import org.pentaho.platform.repository2.unified.IRepositoryFileDao;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileDaoInst;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.util.Assert;

public class JcrRepositoryFileDaoFacade
implements IRepositoryFileDao {
    private JcrTemplate jcrTemplate;
    private JcrRepositoryFileDaoInst jcrRepositoryFileDao;

    public JcrRepositoryFileDaoFacade(JcrTemplate jcrTemplate, JcrRepositoryFileDaoInst jcrRepositoryFileDao) {
        this.jcrTemplate = jcrTemplate;
        this.jcrRepositoryFileDao = jcrRepositoryFileDao;
    }

    private void checkPath(String path) {
        Assert.hasText((String)path);
        Assert.isTrue((boolean)path.startsWith("/"));
    }

    @Override
    public RepositoryFile getFileByAbsolutePath(final String absPath) {
        this.checkPath(absPath);
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.internalGetFile(session, absPath, false, null);
            }
        });
    }

    @Override
    public RepositoryFile getFile(final String relPath, final boolean loadMaps) {
        this.checkPath(relPath);
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.getFileByRelPath(session, relPath, loadMaps, null);
            }
        });
    }

    @Override
    public void moveFile(Serializable fileId, String destRelPath, String versionMessage) {
        this.copyOrMoveFile(fileId, destRelPath, versionMessage, false);
    }

    @Override
    public void copyFile(Serializable fileId, String destRelPath, String versionMessage) {
        this.copyOrMoveFile(fileId, destRelPath, versionMessage, true);
    }

    private void copyOrMoveFile(final Serializable fileId, final String destRelPath, final String versionMessage, final boolean copy) {
        Assert.notNull((Object)fileId);
        this.checkKiosk();
        this.jcrTemplate.execute((JcrCallback)new VoidJcrCallback(){

            @Override
            public void runInJcr(Session session) throws RepositoryException, IOException {
                JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.internalCopyOrMove(session, JcrRepositoryFileDaoFacade.this.getFileById(fileId), destRelPath, versionMessage, copy);
            }
        });
    }

    @Override
    public VersionSummary getVersionSummary(final Serializable fileId, final Serializable versionId) {
        Assert.notNull((Object)fileId);
        return (VersionSummary)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.getVersionSummary(session, fileId, versionId);
            }
        });
    }

    @Override
    public void restoreFileAtVersion(final Serializable fileId, final Serializable versionId, final String versionMessage) {
        Assert.notNull((Object)fileId);
        Assert.notNull((Object)versionId);
        this.checkKiosk();
        this.jcrTemplate.execute((JcrCallback)new VoidJcrCallback(){

            @Override
            public void runInJcr(Session session) throws RepositoryException, IOException {
                JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.restoreFileAtVersion(session, fileId, versionId, versionMessage);
            }
        });
    }

    @Override
    public boolean canUnlockFile(final Serializable fileId) {
        return (Boolean)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.canUnlockFile(session, fileId);
            }
        });
    }

    @Override
    public RepositoryFileTree getTree(final RepositoryRequest repositoryRequest) {
        Assert.hasText((String)repositoryRequest.getPath());
        return (RepositoryFileTree)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.getTree(session, repositoryRequest);
            }
        });
    }

    @Override
    @Deprecated
    public RepositoryFileTree getTree(String relPath, int depth, String filter, boolean showHidden) {
        return this.getTree(new RepositoryRequest(relPath, Boolean.valueOf(showHidden), Integer.valueOf(depth), filter));
    }

    @Override
    public List<RepositoryFile> getReferrers(final Serializable fileId) {
        if (fileId == null) {
            return Collections.emptyList();
        }
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.getReferrers(session, fileId);
            }
        });
    }

    @Override
    public void setFileMetadata(final Serializable fileId, final Map<String, Serializable> metadataMap) {
        Assert.notNull((Object)fileId);
        this.checkKiosk();
        this.jcrTemplate.execute((JcrCallback)new VoidJcrCallback(){

            @Override
            public void runInJcr(Session session) throws RepositoryException, IOException {
                JcrRepositoryFileUtils.setFileMetadata(session, fileId, metadataMap);
            }
        });
    }

    @Override
    public Map<String, Serializable> getFileMetadata(final Serializable fileId) {
        Assert.notNull((Object)fileId);
        return (Map)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws IOException, RepositoryException {
                return JcrRepositoryFileUtils.getFileMetadata(session, fileId);
            }
        });
    }

    @Override
    public List<Locale> getAvailableLocalesForFileById(Serializable fileId) {
        return this.getAvailableLocalesForFile(this.getFileById(fileId, true));
    }

    @Override
    public List<Locale> getAvailableLocalesForFileByPath(String relPath) {
        return this.getAvailableLocalesForFile(this.getFileById((Serializable)((Object)relPath), true));
    }

    @Override
    public List<Locale> getAvailableLocalesForFile(RepositoryFile repositoryFile) {
        return this.jcrRepositoryFileDao.getAvailableLocalesForFile(repositoryFile);
    }

    @Override
    public Properties getLocalePropertiesForFileById(Serializable fileId, String locale) {
        return this.getLocalePropertiesForFile(this.getFileById(fileId, true), locale);
    }

    @Override
    public Properties getLocalePropertiesForFileByPath(String relPath, String locale) {
        return this.getLocalePropertiesForFile(this.getFileById((Serializable)((Object)relPath), true), locale);
    }

    @Override
    public Properties getLocalePropertiesForFile(RepositoryFile repositoryFile, String locale) {
        return this.jcrRepositoryFileDao.getLocalePropertiesForFile(repositoryFile, locale);
    }

    @Override
    public void setLocalePropertiesForFileById(Serializable fileId, String locale, Properties properties) {
        RepositoryFile repositoryFile = this.getFileById(fileId, true);
        this.setLocalePropertiesForFile(repositoryFile, locale, properties);
    }

    @Override
    public void setLocalePropertiesForFileByPath(String relPath, String locale, Properties properties) {
        RepositoryFile repositoryFile = this.getFileById((Serializable)((Object)relPath), true);
        this.setLocalePropertiesForFile(repositoryFile, locale, properties);
    }

    @Override
    public void setLocalePropertiesForFile(final RepositoryFile repositoryFile, final String locale, final Properties properties) {
        Assert.notNull((Object)repositoryFile);
        Assert.notNull((Object)locale);
        Assert.notNull((Object)properties);
        this.checkKiosk();
        this.jcrTemplate.execute((JcrCallback)new VoidJcrCallback(){

            @Override
            public void runInJcr(Session session) throws IOException, RepositoryException {
                JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.setLocalePropertiesForFile(session, repositoryFile, locale, properties);
            }
        });
    }

    @Override
    public void deleteLocalePropertiesForFile(final RepositoryFile repositoryFile, final String locale) {
        Assert.notNull((Object)repositoryFile);
        Assert.notNull((Object)locale);
        this.checkKiosk();
        this.jcrTemplate.execute((JcrCallback)new VoidJcrCallback(){

            @Override
            public void runInJcr(Session session) throws RepositoryException, IOException {
                JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.deleteLocalePropertiesForFile(session, repositoryFile, locale);
            }
        });
    }

    @Override
    public RepositoryFile updateFolder(final RepositoryFile file, final String versionMessage) {
        Assert.notNull((Object)file);
        Assert.isTrue((boolean)file.isFolder());
        this.checkKiosk();
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.internalUpdateFolder(session, file, versionMessage);
            }
        });
    }

    @Override
    public void undeleteFile(final Serializable fileId, final String versionMessage) {
        Assert.notNull((Object)fileId);
        this.checkKiosk();
        this.jcrTemplate.execute((JcrCallback)new VoidJcrCallback(){

            @Override
            public void runInJcr(Session session) throws RepositoryException, IOException {
                JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.undeleteFile(session, fileId, versionMessage);
            }
        });
    }

    @Override
    public void deleteFile(final Serializable fileId, final String versionMessage) {
        Assert.notNull((Object)fileId);
        this.checkKiosk();
        this.jcrTemplate.execute((JcrCallback)new VoidJcrCallback(){

            @Override
            public void runInJcr(Session session) throws RepositoryException, IOException {
                JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.deleteFile(session, fileId, versionMessage);
            }
        });
    }

    @Override
    public void deleteFileAtVersion(final Serializable fileId, final Serializable versionId) {
        Assert.notNull((Object)fileId);
        Assert.notNull((Object)versionId);
        this.checkKiosk();
        this.jcrTemplate.execute((JcrCallback)new VoidJcrCallback(){

            @Override
            public void runInJcr(Session session) throws RepositoryException, IOException {
                JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.deleteFileAtVersion(session, fileId, versionId);
            }
        });
    }

    @Override
    public List<RepositoryFile> getDeletedFiles(final String origParentFolderPath, final String filter) {
        Assert.hasLength((String)origParentFolderPath);
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.getDeletedFiles(session, origParentFolderPath, filter);
            }
        });
    }

    @Override
    public List<RepositoryFile> getDeletedFiles() {
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.getDeletedFiles(session);
            }
        });
    }

    @Override
    public void permanentlyDeleteFile(final Serializable fileId, final String versionMessage) {
        Assert.notNull((Object)fileId);
        this.checkKiosk();
        this.jcrTemplate.execute((JcrCallback)new VoidJcrCallback(){

            @Override
            public void runInJcr(Session session) throws RepositoryException, IOException {
                JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.permanentlyDeleteFile(session, fileId, versionMessage);
            }
        });
    }

    @Override
    public <T extends IRepositoryFileData> T getData(final Serializable fileId, final Serializable versionId, final Class<T> contentClass) {
        Assert.notNull((Object)fileId);
        return (T)((IRepositoryFileData)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.getData(session, fileId, versionId, contentClass);
            }
        }));
    }

    @Override
    public List<RepositoryFile> getChildren(final RepositoryRequest repositoryRequest) {
        Assert.notNull((Object)repositoryRequest.getPath());
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.getChildren(session, repositoryRequest);
            }
        });
    }

    @Override
    public List<RepositoryFile> getChildren(final Serializable folderId, final String filter, final Boolean showHiddenFiles) {
        Assert.notNull((Object)folderId);
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.getChildren(session, folderId, filter, showHiddenFiles);
            }
        });
    }

    @Override
    public RepositoryFile updateFile(final RepositoryFile file, final IRepositoryFileData content, final String versionMessage) {
        Assert.notNull((Object)file);
        Assert.isTrue((!file.isFolder() ? 1 : 0) != 0);
        Assert.notNull((Object)content);
        this.checkKiosk();
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.internalUpdateFile(session, file, content, versionMessage);
            }
        });
    }

    @Override
    public void lockFile(final Serializable fileId, final String message) {
        Assert.notNull((Object)fileId);
        this.checkKiosk();
        this.jcrTemplate.execute((JcrCallback)new VoidJcrCallback(){

            @Override
            public void runInJcr(Session session) throws RepositoryException, IOException {
                JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.lockFile(session, fileId, message);
            }
        });
    }

    @Override
    public void unlockFile(final Serializable fileId) {
        Assert.notNull((Object)fileId);
        this.checkKiosk();
        this.jcrTemplate.execute((JcrCallback)new VoidJcrCallback(){

            @Override
            public void runInJcr(Session session) throws RepositoryException, IOException {
                JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.unlockFile(session, fileId);
            }
        });
    }

    @Override
    public List<VersionSummary> getVersionSummaries(final Serializable fileId) {
        Assert.notNull((Object)fileId);
        return (List)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.getVersionSummaries(session, fileId);
            }
        });
    }

    @Override
    public RepositoryFile createFile(final Serializable parentFolderId, final RepositoryFile file, final IRepositoryFileData content, final RepositoryFileAcl acl, final String versionMessage) {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
        Assert.notNull((Object)file);
        Assert.isTrue((!file.isFolder() ? 1 : 0) != 0);
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.internalCreateFile(session, parentFolderId, file, content, acl, versionMessage);
            }
        });
    }

    @Override
    public RepositoryFile createFolder(final Serializable parentFolderId, final RepositoryFile folder, final RepositoryFileAcl acl, final String versionMessage) {
        Assert.notNull((Object)folder);
        Assert.isTrue((boolean)folder.isFolder());
        this.checkKiosk();
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.internalCreateFolder(session, parentFolderId, folder, acl, versionMessage);
            }
        });
    }

    @Override
    public List<Character> getReservedChars() {
        return JcrRepositoryFileUtils.getReservedChars();
    }

    private void checkKiosk() {
        if (this.isKioskEnabled()) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0006_ACCESS_DENIED"));
        }
    }

    private boolean isKioskEnabled() {
        if (PentahoSystem.getInitializedOK()) {
            return "true".equals(PentahoSystem.getSystemSetting((String)"kiosk-mode", (String)"false"));
        }
        return false;
    }

    @Override
    public RepositoryFile getFile(String relPath) {
        return this.getFile(relPath, false, null);
    }

    @Override
    public RepositoryFile getFile(String relPath, IPentahoLocale locale) {
        return this.getFile(relPath, false, locale);
    }

    @Override
    public RepositoryFile getFile(final String relPath, final boolean loadLocaleMaps, final IPentahoLocale locale) {
        Assert.hasText((String)relPath);
        Assert.isTrue((boolean)relPath.startsWith("/"));
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.getFileByRelPath(session, relPath, loadLocaleMaps, locale);
            }
        });
    }

    @Override
    public RepositoryFile getFileById(Serializable fileId) {
        return this.getFileById(fileId, null);
    }

    @Override
    public RepositoryFile getFileById(Serializable fileId, boolean loadMaps) {
        return this.getFileById(fileId, loadMaps, null);
    }

    @Override
    public RepositoryFile getFileById(Serializable fileId, IPentahoLocale locale) {
        return this.getFileById(fileId, false, locale);
    }

    @Override
    public RepositoryFile getFile(final Serializable fileId, final Serializable versionId) {
        Assert.notNull((Object)fileId);
        Assert.notNull((Object)versionId);
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.getFile(session, fileId, versionId);
            }
        });
    }

    @Override
    public RepositoryFile getFileById(final Serializable fileId, final boolean loadLocaleMaps, final IPentahoLocale locale) {
        return (RepositoryFile)this.jcrTemplate.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException, IOException {
                return JcrRepositoryFileDaoFacade.this.jcrRepositoryFileDao.checkAndGetFileById(session, fileId, loadLocaleMaps, locale);
            }
        });
    }

    static abstract class VoidJcrCallback
    implements JcrCallback {
        VoidJcrCallback() {
        }

        public Object doInJcr(Session session) throws IOException, RepositoryException {
            this.runInJcr(session);
            return null;
        }

        public abstract void runInJcr(Session var1) throws IOException, RepositoryException;
    }
}

