/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader reader;
    private char[] charBuf = new char[4096];
    private byte[] byteBuf;
    private int bufPos = 0;
    private int bufExtent = 0;
    private boolean atEnd = false;

    public ReaderInputStream(Reader reader) {
        this.reader = reader;
    }

    public int available() {
        int n = this.bufExtent - this.bufPos;
        return n;
    }

    public void close() throws IOException {
        this.bufPos = 0;
        this.bufExtent = 0;
        this.reader.close();
    }

    public int read() throws IOException {
        if (this.bufPos >= this.bufExtent) {
            this.fillBuffer();
        }
        byte by = this.byteBuf[this.bufPos];
        ++this.bufPos;
        return by;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        boolean bl = false;
        while (n2 > 0 && !bl) {
            if (this.bufPos >= this.bufExtent) {
                this.fillBuffer();
            }
            if (this.bufPos >= this.bufExtent) break;
            int n4 = Math.min(n2, this.bufExtent - this.bufPos);
            System.arraycopy(this.byteBuf, this.bufPos, byArray, n, n4);
            this.bufPos += n4;
            n += n4;
            n2 -= n4;
            n3 += n4;
            bl = this.atEnd;
        }
        if (n3 == 0) {
            n3 = -1;
        }
        return n3;
    }

    private void fillBuffer() throws IOException {
        this.bufPos = 0;
        this.bufExtent = 0;
        int n = this.reader.read(this.charBuf);
        if (n < this.charBuf.length) {
            this.atEnd = true;
        }
        if (n < 0) {
            return;
        }
        String string = new String(this.charBuf, 0, n);
        this.byteBuf = string.getBytes();
        this.bufExtent = this.byteBuf.length;
    }

    public void reset() throws IOException {
        this.bufPos = 0;
        this.bufExtent = 0;
        this.reader.reset();
    }
}

