/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.parameters;

import de.simplicit.vjdbc.parameters.PreparedStatementParameter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ByteStreamParameter
implements PreparedStatementParameter {
    static final long serialVersionUID = 8868161011164192986L;
    public static final int TYPE_ASCII = 1;
    public static final int TYPE_UNICODE = 2;
    public static final int TYPE_BINARY = 3;
    private int _type;
    private byte[] _value;
    private long _length;

    public ByteStreamParameter() {
    }

    public ByteStreamParameter(int type, InputStream x, long length) throws SQLException {
        this._type = type;
        this._length = length;
        BufferedInputStream s = new BufferedInputStream(x);
        try {
            int br;
            ByteArrayOutputStream bos = new ByteArrayOutputStream((int)(length >= 0L ? length : 1024L));
            byte[] buf = new byte[1024];
            while ((br = s.read(buf)) >= 0) {
                if (br <= 0) continue;
                bos.write(buf, 0, br);
            }
            this._value = bos.toByteArray();
            if (this._length < 0L) {
                this._length = this._value.length;
            }
        }
        catch (IOException e) {
            throw new SQLException("InputStream conversion to byte-array failed");
        }
        finally {
            try {
                s.close();
            }
            catch (IOException e) {}
        }
    }

    public byte[] getValue() {
        return this._value;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._type = in.readInt();
        this._value = (byte[])in.readObject();
        this._length = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._type);
        out.writeObject(this._value);
        out.writeLong(this._length);
    }

    @Override
    public void setParameter(PreparedStatement pstmt, int index) throws SQLException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this._value);
        switch (this._type) {
            case 1: {
                pstmt.setAsciiStream(index, (InputStream)bais, this._length);
                break;
            }
            case 2: {
                pstmt.setUnicodeStream(index, bais, (int)this._length);
                break;
            }
            case 3: {
                pstmt.setBinaryStream(index, (InputStream)bais, this._length);
            }
        }
    }

    public String toString() {
        return "ByteStream: " + this._length + " bytes";
    }
}

