/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.kettle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.openformula.ui.DefaultFieldDefinition;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataFactoryEditorSupport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaModel;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaArgument;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaParameter;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelEvent;
import org.pentaho.reporting.libraries.designtime.swing.background.DataPreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.libraries.designtime.swing.icons.IconLoader;
import org.pentaho.reporting.ui.datasources.kettle.FileKettleQueryEntry;
import org.pentaho.reporting.ui.datasources.kettle.KettleQueryEntry;
import org.pentaho.reporting.ui.datasources.kettle.Messages;
import org.pentaho.reporting.ui.datasources.kettle.embedded.KettleParameterInfo;
import org.pentaho.reporting.ui.datasources.kettle.parameter.FormulaParameterDialog;

public class KettleDataSourceDialog
extends CommonDialog {
    private static final Log logger = LogFactory.getLog(KettleDataSourceDialog.class);
    private DesignTimeContext designTimeContext;
    private JTextField fileTextField;
    private JTextField nameTextField;
    private JList stepsList;
    private JList queryNameList;
    private DefaultListModel queryListModel;
    private boolean inUpdateFromList;
    private Action editParameterAction;
    private PreviewAction previewAction;
    private JCheckBox stopOnErrorsCheckBox;

    private void refreshStepList(FileKettleQueryEntry fe) throws KettleException, ReportDataFactoryException {
        DataFactoryContext dataFactoryContext = this.getDesignTimeContext().getDataFactoryContext();
        List<StepMeta> data = fe.getSteps(dataFactoryContext);
        this.stepsList.setListData(data.toArray(new StepMeta[data.size()]));
        String selectedStepName = fe.getSelectedStep();
        if (selectedStepName != null) {
            for (StepMeta stepMeta : data) {
                if (!selectedStepName.equals(stepMeta.getName())) continue;
                this.stepsList.setSelectedValue(stepMeta, true);
                break;
            }
        }
    }

    public KettleDataSourceDialog(DesignTimeContext designTimeContext, JDialog parent) {
        super((Dialog)parent);
        this.initDialog(designTimeContext);
    }

    public KettleDataSourceDialog(DesignTimeContext designTimeContext, JFrame parent) {
        super((Frame)parent);
        this.initDialog(designTimeContext);
    }

    public KettleDataSourceDialog(DesignTimeContext designTimeContext) {
        this.initDialog(designTimeContext);
    }

    private void initDialog(DesignTimeContext designTimeContext) {
        if (designTimeContext == null) {
            throw new NullPointerException();
        }
        this.designTimeContext = designTimeContext;
        this.stopOnErrorsCheckBox = new JCheckBox(Messages.getString("KettleDataSourceDialog.StopOnErrors", new Object[0]));
        this.stopOnErrorsCheckBox.setEnabled(false);
        this.stopOnErrorsCheckBox.addActionListener(new StopOnErrorSync());
        this.editParameterAction = new EditParameterAction();
        this.editParameterAction.setEnabled(false);
        this.queryListModel = new DefaultListModel();
        this.queryNameList = new JList(this.queryListModel);
        this.queryNameList.setSelectionMode(0);
        this.queryNameList.setVisibleRowCount(5);
        this.queryNameList.addListSelectionListener(this.getQueryNameListener());
        this.previewAction = new PreviewAction();
        this.fileTextField = new JTextField(30);
        this.fileTextField.setEnabled(false);
        this.fileTextField.getDocument().addDocumentListener(new FileSyncHandler());
        this.stepsList = new JList();
        this.stepsList.setSelectionMode(0);
        this.stepsList.addListSelectionListener(new StepsListListener());
        this.stepsList.addListSelectionListener(this.previewAction);
        this.nameTextField = new JTextField(30);
        this.nameTextField.setEnabled(false);
        this.nameTextField.getDocument().addDocumentListener(new NameSyncHandler());
        this.setTitle(this.getDialogTitle());
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        super.init();
    }

    protected JCheckBox getStopOnErrorsCheckBox() {
        return this.stopOnErrorsCheckBox;
    }

    protected Action getPreviewAction() {
        return this.previewAction;
    }

    protected Action getEditParameterAction() {
        return this.editParameterAction;
    }

    protected DesignTimeContext getDesignTimeContext() {
        return this.designTimeContext;
    }

    protected KettleQueryEntry getSelectedQuery() {
        return (KettleQueryEntry)this.queryNameList.getSelectedValue();
    }

    protected void updateQueryName(String name) {
        this.nameTextField.setText(name);
    }

    protected String getDialogTitle() {
        return Messages.getString("KettleDataSourceDialog.Title", new Object[0]);
    }

    protected String getDialogId() {
        return "KettleDataSourceDialog";
    }

    protected Component createContentPane() {
        JPanel previewAndParameterPanel = this.createTransformParameterPanel();
        JPanel queryListPanel = this.createQueryListPanel();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        mainPanel.add((Component)new JLabel(Messages.getString("KettleDataSourceDialog.QueryName", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        mainPanel.add((Component)this.nameTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        mainPanel.add((Component)this.createDatasourcePanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        mainPanel.add((Component)previewAndParameterPanel, gbc);
        JSplitPane panel = new JSplitPane(1);
        panel.setLeftComponent(queryListPanel);
        panel.setRightComponent(mainPanel);
        panel.setDividerLocation(250);
        return panel;
    }

    private JPanel createQueryListPanel() {
        RemoveQueryAction removeQueryAction = new RemoveQueryAction();
        this.queryNameList.addListSelectionListener(removeQueryAction);
        JPanel queryListButtonsPanel = new JPanel(new FlowLayout(2));
        queryListButtonsPanel.add((Component)new BorderlessButton((Action)new AddQueryAction()));
        queryListButtonsPanel.add((Component)new BorderlessButton((Action)removeQueryAction));
        JPanel queryListPanel = new JPanel(new BorderLayout());
        queryListPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        queryListPanel.add((Component)new JScrollPane(this.queryNameList), "Center");
        queryListPanel.add((Component)queryListButtonsPanel, "North");
        return queryListPanel;
    }

    private JPanel createTransformParameterPanel() {
        JPanel stopOnErrorsPanel = new JPanel(new FlowLayout(2, 5, 5));
        stopOnErrorsPanel.add(this.stopOnErrorsCheckBox);
        JPanel previewAndParameterPanel = new JPanel(new FlowLayout(2, 5, 5));
        previewAndParameterPanel.add(new JButton(this.editParameterAction));
        previewAndParameterPanel.add(new JButton(this.previewAction));
        JPanel transParameterPanel = new JPanel(new BorderLayout());
        transParameterPanel.add((Component)stopOnErrorsPanel, "North");
        transParameterPanel.add((Component)previewAndParameterPanel, "Center");
        return transParameterPanel;
    }

    protected JPanel createDatasourcePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        BrowseAction browseAction = new BrowseAction();
        this.queryNameList.addListSelectionListener(browseAction);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 13);
        panel.add((Component)new JLabel(Messages.getString("KettleDataSourceDialog.FileName", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)this.fileTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        panel.add((Component)new JButton(browseAction), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)new JLabel(Messages.getString("KettleDataSourceDialog.Steps", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        panel.add((Component)new JScrollPane(this.stepsList), gbc);
        return panel;
    }

    public KettleDataFactory performConfiguration(DesignTimeContext context, KettleDataFactory dataFactory, String queryName) throws KettleException {
        this.configureFromDataFactory(dataFactory, queryName);
        if (!this.performEdit()) {
            return null;
        }
        KettleDataFactory kettleDataFactory = new KettleDataFactory();
        for (KettleQueryEntry queryEntry : this.getQueryEntries()) {
            KettleTransformationProducer producer = queryEntry.createProducer();
            kettleDataFactory.setQuery(queryEntry.getName(), producer);
        }
        return kettleDataFactory;
    }

    protected KettleQueryEntry[] getQueryEntries() {
        Object[] data = new KettleQueryEntry[this.queryListModel.size()];
        this.queryListModel.copyInto(data);
        return data;
    }

    protected void configureFromDataFactory(KettleDataFactory dataFactory, String selectedQueryName) throws KettleException {
        this.queryListModel.clear();
        if (dataFactory == null) {
            return;
        }
        KettleQueryEntry selectedDataSet = null;
        String[] queryNames = dataFactory.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            KettleTransformationProducer producer = dataFactory.getQuery(queryName);
            KettleQueryEntry dataSet = this.createQueryEntry(queryName, producer);
            this.queryListModel.addElement(dataSet);
            if (!ObjectUtilities.equal((Object)selectedQueryName, (Object)queryName)) continue;
            selectedDataSet = dataSet;
        }
        this.queryNameList.setSelectedValue(selectedDataSet, true);
    }

    protected boolean validateInputs(boolean onConfirm) {
        this.getConfirmAction().setEnabled(this.queryNameList.getModel().getSize() > 0);
        return this.queryNameList.getModel().getSize() != 0;
    }

    protected KettleQueryEntry createNewQueryEntry(String queryName) throws KettleException {
        return new FileKettleQueryEntry(queryName);
    }

    protected KettleQueryEntry createQueryEntry(String queryName, KettleTransformationProducer producer) throws KettleException {
        return new FileKettleQueryEntry(queryName, producer);
    }

    protected ListSelectionListener getQueryNameListener() {
        return new QueryNameListSelectionListener();
    }

    protected void clearComponents() {
        this.nameTextField.setText("");
        this.fileTextField.setText("");
        this.stepsList.setListData(new StepMeta[0]);
    }

    protected String findNextName() {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this.queryListModel.getSize(); ++i) {
            KettleQueryEntry o = (KettleQueryEntry)this.queryListModel.getElementAt(i);
            names.add(o.getName());
        }
        String queryName = Messages.getString("KettleDataSourceDialog.Query", new Object[0]);
        for (int i = 1; i < 1000; ++i) {
            String newQuery = Messages.getString("KettleDataSourceDialog.Query", new Object[0]) + " " + i;
            if (names.contains(newQuery)) continue;
            queryName = newQuery;
            break;
        }
        return queryName;
    }

    private class StopOnErrorSync
    implements ActionListener {
        private StopOnErrorSync() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KettleQueryEntry selectedQuery = KettleDataSourceDialog.this.getSelectedQuery();
            if (selectedQuery != null) {
                selectedQuery.setStopOnErrors(KettleDataSourceDialog.this.stopOnErrorsCheckBox.isSelected());
            }
        }
    }

    private class EditParameterAction
    extends AbstractAction {
        private EditParameterAction() {
            this.putValue("Name", Messages.getString("KettleDataSourceDialog.EditParameter.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KettleQueryEntry queryEntry = (KettleQueryEntry)KettleDataSourceDialog.this.queryNameList.getSelectedValue();
            if (queryEntry == null) {
                return;
            }
            try {
                FormulaParameterDialog dialog = new FormulaParameterDialog((Dialog)((Object)KettleDataSourceDialog.this), KettleDataSourceDialog.this.designTimeContext);
                FieldDefinition[] fields = this.createFieldDefinitions();
                FormulaParameter[] parameters = queryEntry.getParameters();
                FormulaArgument[] arguments = queryEntry.getArguments();
                KettleParameterInfo[] declaredParameters = queryEntry.getDeclaredParameters(KettleDataSourceDialog.this.getDesignTimeContext().getDataFactoryContext());
                FormulaParameterDialog.EditResult editResult = dialog.performEdit(arguments, parameters, fields, declaredParameters);
                if (editResult == null) {
                    return;
                }
                queryEntry.setArguments(editResult.getArgumentNames());
                queryEntry.setParameters(editResult.getParameterMappings());
            }
            catch (Exception e1) {
                KettleDataSourceDialog.this.designTimeContext.error(e1);
            }
            catch (Throwable t1) {
                KettleDataSourceDialog.this.designTimeContext.error((Exception)new RuntimeException("Fatal error", t1));
            }
        }

        private FieldDefinition[] createFieldDefinitions() {
            DataSchemaModel dataSchemaModel = KettleDataSourceDialog.this.designTimeContext.getDataSchemaModel();
            String[] reportFields = dataSchemaModel.getColumnNames();
            FieldDefinition[] fields = new FieldDefinition[reportFields.length];
            for (int i = 0; i < reportFields.length; ++i) {
                String reportField = reportFields[i];
                fields[i] = new DefaultFieldDefinition(reportField);
            }
            return fields;
        }
    }

    private static class KettlePreviewWorker
    implements PreviewWorker {
        private KettleDataFactory dataFactory;
        private TableModel resultTableModel;
        private ReportDataFactoryException exception;
        private String query;

        private KettlePreviewWorker(KettleDataFactory dataFactory, String query) {
            if (dataFactory == null) {
                throw new NullPointerException();
            }
            this.query = query;
            this.dataFactory = dataFactory;
        }

        public ReportDataFactoryException getException() {
            return this.exception;
        }

        public TableModel getResultTableModel() {
            return this.resultTableModel;
        }

        public void close() {
        }

        public void cancelProcessing(CancelEvent event) {
            this.dataFactory.cancelRunningQuery();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.resultTableModel = this.dataFactory.queryData(this.query, (DataRow)new ReportParameterValues());
            }
            catch (ReportDataFactoryException e) {
                this.exception = e;
            }
            finally {
                this.dataFactory.close();
            }
        }
    }

    private class PreviewAction
    extends AbstractAction
    implements ListSelectionListener {
        private PreviewAction() {
            this.putValue("Name", Messages.getString("KettleDataSourceDialog.Preview.Name", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                KettleQueryEntry kettleQueryEntry = (KettleQueryEntry)KettleDataSourceDialog.this.queryNameList.getSelectedValue();
                KettleTransformationProducer fileProducer = kettleQueryEntry.createProducer();
                KettleDataFactory dataFactory = new KettleDataFactory();
                dataFactory.setQuery(kettleQueryEntry.getName(), fileProducer);
                DataFactoryEditorSupport.configureDataFactoryForPreview((DataFactory)dataFactory, (DesignTimeContext)KettleDataSourceDialog.this.designTimeContext);
                DataPreviewDialog previewDialog = new DataPreviewDialog((Dialog)((Object)KettleDataSourceDialog.this));
                KettlePreviewWorker worker = new KettlePreviewWorker(dataFactory, kettleQueryEntry.getName());
                previewDialog.showData((PreviewWorker)worker);
                ReportDataFactoryException factoryException = worker.getException();
                if (factoryException != null) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)KettleDataSourceDialog.this), (String)Messages.getString("KettleDataSourceDialog.PreviewError.Title", new Object[0]), (String)Messages.getString("KettleDataSourceDialog.PreviewError.Message", new Object[0]), (Exception)((Object)factoryException));
                }
            }
            catch (Exception ex) {
                ExceptionDialog.showExceptionDialog((Component)((Object)KettleDataSourceDialog.this), (String)Messages.getString("KettleDataSourceDialog.PreviewError.Title", new Object[0]), (String)Messages.getString("KettleDataSourceDialog.PreviewError.Message", new Object[0]), (Exception)ex);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(KettleDataSourceDialog.this.stepsList.getSelectedValue() != null);
        }
    }

    private class RemoveQueryAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveQueryAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getDeleteIcon());
            this.putValue("ShortDescription", Messages.getString("KettleDataSourceDialog.RemoveQuery.Description", new Object[0]));
            this.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedValue = KettleDataSourceDialog.this.queryNameList.getSelectedValue();
            if (selectedValue == null) {
                return;
            }
            KettleDataSourceDialog.this.inUpdateFromList = true;
            try {
                KettleDataSourceDialog.this.clearComponents();
                KettleDataSourceDialog.this.queryListModel.removeElement(selectedValue);
            }
            finally {
                KettleDataSourceDialog.this.inUpdateFromList = false;
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(KettleDataSourceDialog.this.queryNameList.getSelectedValue() != null);
        }
    }

    private class AddQueryAction
    extends AbstractAction {
        public AddQueryAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getAddIcon());
            this.putValue("ShortDescription", Messages.getString("KettleDataSourceDialog.AddQuery.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String queryName = KettleDataSourceDialog.this.findNextName();
            try {
                KettleQueryEntry newQuery = KettleDataSourceDialog.this.createNewQueryEntry(queryName);
                KettleDataSourceDialog.this.queryListModel.addElement(newQuery);
                KettleDataSourceDialog.this.queryNameList.setSelectedValue(newQuery, true);
            }
            catch (KettleException e1) {
                KettleDataSourceDialog.this.getDesignTimeContext().error((Exception)((Object)e1));
            }
        }
    }

    protected class QueryNameListSelectionListener
    implements ListSelectionListener {
        protected QueryNameListSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            KettleQueryEntry value = KettleDataSourceDialog.this.getSelectedQuery();
            if (value == null) {
                KettleDataSourceDialog.this.nameTextField.setEnabled(false);
                KettleDataSourceDialog.this.fileTextField.setEnabled(false);
                KettleDataSourceDialog.this.stepsList.setEnabled(false);
                KettleDataSourceDialog.this.editParameterAction.setEnabled(false);
                KettleDataSourceDialog.this.stopOnErrorsCheckBox.setEnabled(false);
                KettleDataSourceDialog.this.stopOnErrorsCheckBox.setSelected(false);
                this.handleSelection(value);
                return;
            }
            KettleDataSourceDialog.this.inUpdateFromList = true;
            KettleDataSourceDialog.this.nameTextField.setEnabled(true);
            KettleDataSourceDialog.this.fileTextField.setEnabled(true);
            try {
                KettleDataSourceDialog.this.nameTextField.setText(value.getName());
                KettleDataSourceDialog.this.editParameterAction.setEnabled(true);
                KettleDataSourceDialog.this.stopOnErrorsCheckBox.setSelected(value.isStopOnErrors());
                KettleDataSourceDialog.this.stopOnErrorsCheckBox.setEnabled(true);
                this.handleSelection(value);
            }
            finally {
                KettleDataSourceDialog.this.inUpdateFromList = false;
            }
        }

        protected void handleSelection(KettleQueryEntry value) {
            if (value instanceof FileKettleQueryEntry) {
                this.handleSelection((FileKettleQueryEntry)value);
            }
        }

        protected void handleSelection(FileKettleQueryEntry selectedQuery) {
            try {
                KettleDataSourceDialog.this.fileTextField.setText(selectedQuery.getFile());
                KettleDataSourceDialog.this.refreshStepList(selectedQuery);
                KettleDataSourceDialog.this.stepsList.setEnabled(true);
                KettleDataSourceDialog.this.editParameterAction.setEnabled(true);
                KettleDataSourceDialog.this.stopOnErrorsCheckBox.setEnabled(true);
            }
            catch (ReportDataFactoryException rdfe) {
                logger.warn((Object)"Non-critical failure while executing the query", (Throwable)rdfe);
                KettleDataSourceDialog.this.stepsList.setEnabled(false);
                KettleDataSourceDialog.this.editParameterAction.setEnabled(false);
                KettleDataSourceDialog.this.stopOnErrorsCheckBox.setEnabled(false);
            }
            catch (Exception e1) {
                KettleDataSourceDialog.this.designTimeContext.error(e1);
                KettleDataSourceDialog.this.stepsList.setEnabled(false);
                KettleDataSourceDialog.this.editParameterAction.setEnabled(false);
                KettleDataSourceDialog.this.stopOnErrorsCheckBox.setEnabled(false);
            }
            catch (Throwable t1) {
                KettleDataSourceDialog.this.designTimeContext.error((Exception)new RuntimeException("Fatal error", t1));
                KettleDataSourceDialog.this.stepsList.setEnabled(false);
                KettleDataSourceDialog.this.editParameterAction.setEnabled(false);
                KettleDataSourceDialog.this.stopOnErrorsCheckBox.setEnabled(false);
            }
        }
    }

    private class StepsListListener
    implements ListSelectionListener {
        private StepsListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent aEvt) {
            KettleQueryEntry queryEntry = (KettleQueryEntry)KettleDataSourceDialog.this.queryNameList.getSelectedValue();
            if (queryEntry instanceof FileKettleQueryEntry) {
                FileKettleQueryEntry fe = (FileKettleQueryEntry)queryEntry;
                StepMeta selectedValue = (StepMeta)KettleDataSourceDialog.this.stepsList.getSelectedValue();
                if (selectedValue != null) {
                    fe.setSelectedStep(selectedValue.getName());
                }
            }
        }
    }

    private class FileSyncHandler
    implements DocumentListener,
    Runnable {
        private boolean armed;

        private FileSyncHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            if (this.armed) {
                return;
            }
            this.armed = true;
            SwingUtilities.invokeLater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String fileName = KettleDataSourceDialog.this.fileTextField.getText();
            KettleQueryEntry selectedQuery = (KettleQueryEntry)KettleDataSourceDialog.this.queryNameList.getSelectedValue();
            if (!(selectedQuery instanceof FileKettleQueryEntry)) {
                return;
            }
            FileKettleQueryEntry fe = (FileKettleQueryEntry)selectedQuery;
            fe.setFile(fileName);
            try {
                KettleDataSourceDialog.this.inUpdateFromList = true;
                KettleDataSourceDialog.this.refreshStepList(fe);
                KettleDataSourceDialog.this.stepsList.setEnabled(true);
                KettleDataSourceDialog.this.editParameterAction.setEnabled(true);
                KettleDataSourceDialog.this.stopOnErrorsCheckBox.setEnabled(true);
            }
            catch (ReportDataFactoryException rdfe) {
                logger.warn((Object)"Non-critical failure while executing the query", (Throwable)rdfe);
                KettleDataSourceDialog.this.stepsList.setEnabled(false);
                KettleDataSourceDialog.this.editParameterAction.setEnabled(false);
                KettleDataSourceDialog.this.stopOnErrorsCheckBox.setEnabled(false);
            }
            catch (Exception e1) {
                KettleDataSourceDialog.this.designTimeContext.error(e1);
                KettleDataSourceDialog.this.stepsList.setEnabled(false);
                KettleDataSourceDialog.this.editParameterAction.setEnabled(false);
                KettleDataSourceDialog.this.stopOnErrorsCheckBox.setEnabled(false);
            }
            catch (Throwable t1) {
                KettleDataSourceDialog.this.designTimeContext.error((Exception)new RuntimeException("Fatal error", t1));
                KettleDataSourceDialog.this.stepsList.setEnabled(false);
                KettleDataSourceDialog.this.editParameterAction.setEnabled(false);
                KettleDataSourceDialog.this.stopOnErrorsCheckBox.setEnabled(false);
            }
            finally {
                KettleDataSourceDialog.this.inUpdateFromList = false;
                this.armed = false;
            }
        }
    }

    private class NameSyncHandler
    implements DocumentListener {
        private NameSyncHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            if (KettleDataSourceDialog.this.inUpdateFromList) {
                return;
            }
            String queryName = KettleDataSourceDialog.this.nameTextField.getText();
            KettleQueryEntry selectedQuery = (KettleQueryEntry)KettleDataSourceDialog.this.queryNameList.getSelectedValue();
            selectedQuery.setName(queryName);
            KettleDataSourceDialog.this.queryNameList.repaint();
        }
    }

    private class BrowseAction
    extends AbstractAction
    implements ListSelectionListener {
        private BrowseAction() {
            this.putValue("Name", Messages.getString("KettleDataSourceDialog.Browse.Name", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileFilter[] fileFilters = new FileFilter[]{new FilesystemFilter(new String[]{".ktr"}, Messages.getString("KettleDataSourceDialog.KtrFileDescription", new Object[0]) + " (*.ktr)", true)};
            File reportContextFile = DesignTimeUtil.getContextAsFile((AbstractReportDefinition)KettleDataSourceDialog.this.designTimeContext.getReport());
            CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser("kettle");
            String fileText = KettleDataSourceDialog.this.fileTextField.getText();
            if (!StringUtils.isEmpty((String)fileText)) {
                if (reportContextFile != null) {
                    fileChooser.setSelectedFile(new File(reportContextFile.getParentFile(), KettleDataSourceDialog.this.fileTextField.getText()));
                } else {
                    fileChooser.setSelectedFile(new File(KettleDataSourceDialog.this.fileTextField.getText()));
                }
            }
            fileChooser.setFilters(fileFilters);
            if (!fileChooser.showDialog((Component)((Object)KettleDataSourceDialog.this), 0)) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String path = reportContextFile != null ? IOUtils.getInstance().createRelativePath(file.getPath(), reportContextFile.getAbsolutePath()) : file.getPath();
            KettleQueryEntry queryEntry = (KettleQueryEntry)KettleDataSourceDialog.this.queryNameList.getSelectedValue();
            if (queryEntry instanceof FileKettleQueryEntry) {
                FileKettleQueryEntry fe = (FileKettleQueryEntry)queryEntry;
                fe.setFile(path);
            }
            KettleDataSourceDialog.this.fileTextField.setText(path);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(KettleDataSourceDialog.this.queryNameList.getSelectedValue() != null);
        }
    }
}

