/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class PrettyPrinter {
    public static String format(String value, Unit unit) {
        StringBuilder human = new StringBuilder();
        switch (unit) {
            case TIME_INTERVAL: {
                human.append(PrettyPrinter.humanReadableTTL(Long.valueOf(value)));
                break;
            }
            case LONG: {
                byte[] longBytes = Bytes.toBytesBinary(value);
                human.append(String.valueOf(Bytes.toLong(longBytes)));
                break;
            }
            case BOOLEAN: {
                byte[] booleanBytes = Bytes.toBytesBinary(value);
                human.append(String.valueOf(Bytes.toBoolean(booleanBytes)));
                break;
            }
            default: {
                human.append(value);
            }
        }
        return human.toString();
    }

    private static String humanReadableTTL(long interval) {
        StringBuilder sb = new StringBuilder();
        if (interval == Integer.MAX_VALUE) {
            sb.append("FOREVER");
            return sb.toString();
        }
        if (interval < 60L) {
            sb.append(interval);
            sb.append(" SECOND").append(interval == 1L ? "" : "S");
            return sb.toString();
        }
        int days = (int)(interval / 86400L);
        int hours = (int)(interval - (long)(86400 * days)) / 3600;
        int minutes = (int)(interval - (long)(86400 * days) - (long)(3600 * hours)) / 60;
        int seconds = (int)(interval - (long)(86400 * days) - (long)(3600 * hours) - (long)(60 * minutes));
        sb.append(interval);
        sb.append(" SECONDS (");
        if (days > 0) {
            sb.append(days);
            sb.append(" DAY").append(days == 1 ? "" : "S");
        }
        if (hours > 0) {
            sb.append(days > 0 ? " " : "");
            sb.append(hours);
            sb.append(" HOUR").append(hours == 1 ? "" : "S");
        }
        if (minutes > 0) {
            sb.append(days + hours > 0 ? " " : "");
            sb.append(minutes);
            sb.append(" MINUTE").append(minutes == 1 ? "" : "S");
        }
        if (seconds > 0) {
            sb.append(days + hours + minutes > 0 ? " " : "");
            sb.append(seconds);
            sb.append(" SECOND").append(minutes == 1 ? "" : "S");
        }
        sb.append(")");
        return sb.toString();
    }

    public static enum Unit {
        TIME_INTERVAL,
        LONG,
        BOOLEAN,
        NONE;

    }
}

