/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.joda.time.DateTime;

public class WeeksBetween
extends EvalFunc<Long> {
    @Override
    public Long exec(Tuple input) throws IOException {
        if (input == null || input.size() < 2) {
            return null;
        }
        DateTime startDate = (DateTime)input.get(0);
        DateTime endDate = (DateTime)input.get(1);
        return (startDate.getMillis() - endDate.getMillis()) / 604800000L;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(this.getSchemaName(this.getClass().getName().toLowerCase(), input), 15));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 30));
        s.add(new Schema.FieldSchema(null, 30));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        return funcList;
    }
}

