/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.ResultSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.row.ValueMetaInterface;

public class MSAccessDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    @Override
    public int[] getAccessTypeList() {
        return new int[]{1};
    }

    @Override
    public boolean supportsSetCharacterStream() {
        return false;
    }

    @Override
    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    @Override
    public String getDriverClass() {
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:odbc:" + databaseName;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return false;
    }

    @Override
    public String getSchemaTableCombination(String schema_name, String table_part) {
        return this.getBackwardsCompatibleSchemaTableCombination(schema_name, table_part);
    }

    @Override
    public int getMaxTextFieldLength() {
        return 65536;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public boolean supportsSetLong() {
        return false;
    }

    @Override
    public boolean supportsViews() {
        return false;
    }

    @Override
    public boolean supportsSynonyms() {
        return false;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP COLUMN " + v.getName() + Const.CR;
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "DATETIME";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BIT";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (use_autoinc) {
                        retval = retval + "COUNTER PRIMARY KEY";
                        break;
                    }
                    retval = retval + "LONG PRIMARY KEY";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        retval = retval + "DOUBLE";
                        break;
                    }
                    if (length > 5) {
                        retval = retval + "LONG";
                        break;
                    }
                    retval = retval + "INTEGER";
                    break;
                }
                retval = retval + "DOUBLE";
                break;
            }
            case 2: {
                if (length > 0) {
                    if (length < 256) {
                        retval = retval + "TEXT(" + length + ")";
                        break;
                    }
                    retval = retval + "MEMO";
                    break;
                }
                retval = retval + "TEXT";
                break;
            }
            case 8: {
                retval = retval + " LONGBINARY";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"ADD", "ALL", "ALPHANUMERIC", "ALTER", "AND", "ANY", "APPLICATION", "AS", "ASC", "ASSISTANT", "AUTOINCREMENT", "AVG", "BETWEEN", "BINARY", "BIT", "BOOLEAN", "BY", "BYTE", "CHAR", "CHARACTER", "COLUMN", "COMPACTDATABASE", "CONSTRAINT", "CONTAINER", "COUNT", "COUNTER", "CREATE", "CREATEDATABASE", "CREATEFIELD", "CREATEGROUP", "CREATEINDEX", "CREATEOBJECT", "CREATEPROPERTY", "CREATERELATION", "CREATETABLEDEF", "CREATEUSER", "CREATEWORKSPACE", "CURRENCY", "CURRENTUSER", "DATABASE", "DATE", "DATETIME", "DELETE", "DESC", "DESCRIPTION", "DISALLOW", "DISTINCT", "DISTINCTROW", "DOCUMENT", "DOUBLE", "DROP", "ECHO", "ELSE", "END", "EQV", "ERROR", "EXISTS", "EXIT", "FALSE", "FIELD", "FIELDS", "FILLCACHE", "FLOAT", "FLOAT4", "FLOAT8", "FOREIGN", "FORM", "FORMS", "FROM", "FULL", "FUNCTION", "GENERAL", "GETOBJECT", "GETOPTION", "GOTOPAGE", "GROUP", "GUID", "HAVING", "IDLE", "IEEEDOUBLE", "IEEESINGLE", "IF", "IGNORE", "IMP", "IN", "INDEX", "INDEX", "INDEXES", "INNER", "INSERT", "INSERTTEXT", "INT", "INTEGER", "INTEGER1", "INTEGER2", "INTEGER4", "INTO", "IS", "JOIN", "KEY", "LASTMODIFIED", "LEFT", "LEVEL", "LIKE", "LOGICAL", "LOGICAL1", "LONG", "LONGBINARY", "LONGTEXT", "MACRO", "MATCH", "MAX", "MIN", "MOD", "MEMO", "MODULE", "MONEY", "MOVE", "NAME", "NEWPASSWORD", "NO", "NOT", "NULL", "NUMBER", "NUMERIC", "OBJECT", "OLEOBJECT", "OFF", "ON", "OPENRECORDSET", "OPTION", "OR", "ORDER", "OUTER", "OWNERACCESS", "PARAMETER", "PARAMETERS", "PARTIAL", "PERCENT", "PIVOT", "PRIMARY", "PROCEDURE", "PROPERTY", "QUERIES", "QUERY", "QUIT", "REAL", "RECALC", "RECORDSET", "REFERENCES", "REFRESH", "REFRESHLINK", "REGISTERDATABASE", "RELATION", "REPAINT", "REPAIRDATABASE", "REPORT", "REPORTS", "REQUERY", "RIGHT", "SCREEN", "SECTION", "SELECT", "SET", "SETFOCUS", "SETOPTION", "SHORT", "SINGLE", "SMALLINT", "SOME", "SQL", "STDEV", "STDEVP", "STRING", "SUM", "TABLE", "TABLEDEF", "TABLEDEFS", "TABLEID", "TEXT", "TIME", "TIMESTAMP", "TOP", "TRANSFORM", "TRUE", "TYPE", "UNION", "UNIQUE", "UPDATE", "USER", "VALUE", "VALUES", "VAR", "VARP", "VARBINARY", "VARCHAR", "WHERE", "WITH", "WORKSPACE", "XOR", "YEAR", "YES", "YESNO"};
    }

    @Override
    public String getStartQuote() {
        return "[";
    }

    @Override
    public String getEndQuote() {
        return "]";
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[0];
    }

    @Override
    public boolean supportsGetBlob() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkIndexExists(Database database, String schemaName, String tableName, String[] idx_fields) throws KettleDatabaseException {
        String tablename = database.getDatabaseMeta().getQuotedSchemaTableCombination(schemaName, tableName);
        boolean[] exists = new boolean[idx_fields.length];
        for (int i = 0; i < exists.length; ++i) {
            exists[i] = false;
        }
        try {
            ResultSet indexList = null;
            try {
                indexList = database.getDatabaseMetaData().getIndexInfo(null, null, tablename, false, true);
                while (indexList.next()) {
                    String column = indexList.getString("COLUMN_NAME");
                    int idx = Const.indexOfString(column, idx_fields);
                    if (idx < 0) continue;
                    exists[idx] = true;
                }
            }
            finally {
                if (indexList != null) {
                    indexList.close();
                }
            }
            boolean all = true;
            for (int i = 0; i < exists.length && all; ++i) {
                if (exists[i]) continue;
                all = false;
            }
            return all;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to determine if indexes exists on table [" + tablename + "]", e);
        }
    }

    @Override
    public String getSQLInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + versionField + ") values (1)";
    }
}

