/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.sql;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleSQLException;
import org.pentaho.di.core.jdbc.ThinUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.sql.SQLField;

public class SQLFields {
    private String tableAlias;
    private RowMetaInterface serviceFields;
    private String fieldsClause;
    private List<SQLField> fields;
    private SQLFields selectFields;
    private boolean distinct;

    public SQLFields(String tableAlias, RowMetaInterface serviceFields, String fieldsClause) throws KettleSQLException {
        this(tableAlias, serviceFields, fieldsClause, false);
    }

    public SQLFields(String tableAlias, RowMetaInterface serviceFields, String fieldsClause, boolean orderClause) throws KettleSQLException {
        this(tableAlias, serviceFields, fieldsClause, orderClause, null);
    }

    public SQLFields(String tableAlias, RowMetaInterface serviceFields, String fieldsClause, boolean orderClause, SQLFields selectFields) throws KettleSQLException {
        this.tableAlias = tableAlias;
        this.serviceFields = serviceFields;
        this.fieldsClause = fieldsClause;
        this.selectFields = selectFields;
        this.fields = new ArrayList<SQLField>();
        this.distinct = false;
        this.parse(orderClause);
    }

    private void parse(boolean orderClause) throws KettleSQLException {
        if (Const.isEmpty(this.fieldsClause)) {
            return;
        }
        if (this.fieldsClause.startsWith("DISTINCT ")) {
            this.distinct = true;
            this.fieldsClause = this.fieldsClause.substring("DISTINCT ".length());
        }
        ArrayList<String> strings = new ArrayList<String>();
        int startIndex = 0;
        for (int index = 0; index < this.fieldsClause.length(); ++index) {
            if ((index = ThinUtil.skipChars(this.fieldsClause, index, '\"', '\'', '(')) >= this.fieldsClause.length()) {
                strings.add(this.fieldsClause.substring(startIndex));
                startIndex = -1;
                break;
            }
            if (this.fieldsClause.charAt(index) != ',') continue;
            strings.add(this.fieldsClause.substring(startIndex, index));
            startIndex = index + 1;
        }
        if (startIndex >= 0) {
            strings.add(this.fieldsClause.substring(startIndex));
        }
        this.fields.clear();
        for (String string : strings) {
            String fieldString = ThinUtil.stripTableAlias(Const.trim(string), this.tableAlias);
            if ("*".equals(fieldString)) {
                for (ValueMetaInterface valueMeta : this.serviceFields.getValueMetaList()) {
                    this.fields.add(new SQLField(this.tableAlias, "\"" + valueMeta.getName() + "\"", this.serviceFields, orderClause, this.selectFields));
                }
                continue;
            }
            this.fields.add(new SQLField(this.tableAlias, fieldString, this.serviceFields, orderClause, this.selectFields));
        }
        this.indexFields();
    }

    public List<SQLField> getFields() {
        return this.fields;
    }

    public List<SQLField> getNonAggregateFields() {
        ArrayList<SQLField> list = new ArrayList<SQLField>();
        for (SQLField field : this.fields) {
            if (field.getAggregation() != null) continue;
            list.add(field);
        }
        return list;
    }

    public List<SQLField> getAggregateFields() {
        ArrayList<SQLField> list = new ArrayList<SQLField>();
        for (SQLField field : this.fields) {
            if (field.getAggregation() == null) continue;
            list.add(field);
        }
        return list;
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public SQLField findByName(String fieldName) {
        for (SQLField field : this.fields) {
            if (!field.getField().equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        return null;
    }

    public RowMetaInterface getServiceFields() {
        return this.serviceFields;
    }

    public void setServiceFields(RowMetaInterface serviceFields) {
        this.serviceFields = serviceFields;
    }

    public String getFieldsClause() {
        return this.fieldsClause;
    }

    public void setFieldsClause(String fieldsClause) {
        this.fieldsClause = fieldsClause;
    }

    public SQLFields getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(SQLFields selectFields) {
        this.selectFields = selectFields;
    }

    public void setFields(List<SQLField> fields) {
        this.fields = fields;
        this.indexFields();
    }

    private void indexFields() {
        for (int i = 0; i < this.fields.size(); ++i) {
            this.fields.get(i).setFieldIndex(i);
        }
    }

    public boolean hasAggregates() {
        for (SQLField field : this.fields) {
            if (field.getAggregation() == null) continue;
            return true;
        }
        return false;
    }

    public List<SQLField> getIifFunctionFields() {
        ArrayList<SQLField> list = new ArrayList<SQLField>();
        for (SQLField field : this.fields) {
            if (field.getIif() == null) continue;
            list.add(field);
        }
        return list;
    }

    public List<SQLField> getRegularFields() {
        ArrayList<SQLField> list = new ArrayList<SQLField>();
        for (SQLField field : this.fields) {
            if (field.getIif() != null || field.getAggregation() != null || field.getValueData() != null) continue;
            list.add(field);
        }
        return list;
    }

    public List<SQLField> getConstantFields() {
        ArrayList<SQLField> list = new ArrayList<SQLField>();
        for (SQLField field : this.fields) {
            if (field.getValueMeta() == null || field.getValueData() == null) continue;
            list.add(field);
        }
        return list;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }
}

