/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.vfs.FileObject;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleAttributeInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.DTDIgnoringEntityResolver;
import org.pentaho.di.core.xml.XMLHandlerCache;
import org.pentaho.di.core.xml.XMLHandlerCacheEntry;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLHandler {
    private static XMLHandlerCache cache = XMLHandlerCache.getInstance();
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

    public static String getXMLHeader() {
        return XMLHandler.getXMLHeader("UTF-8");
    }

    public static String getXMLHeader(String encoding) {
        return "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>" + Const.CR;
    }

    public static String getTagValue(Node n, KettleAttributeInterface code) {
        return XMLHandler.getTagValue(n, code.getXmlCode());
    }

    public static String getTagValue(Node n, String tag) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || childnode.getFirstChild() == null) continue;
            return childnode.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static String getTagValueWithAttribute(Node n, String tag, String attribute) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || childnode.getAttributes().getNamedItem(attribute) == null || childnode.getFirstChild() == null) continue;
            return childnode.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static String getTagValue(Node n, String tag, String subtag) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            NodeList tags = childnode.getChildNodes();
            for (int j = 0; j < tags.getLength(); ++j) {
                Node tagnode = tags.item(j);
                if (!tagnode.getNodeName().equalsIgnoreCase(subtag) || tagnode.getFirstChild() == null) continue;
                return tagnode.getFirstChild().getNodeValue();
            }
        }
        return null;
    }

    public static int countNodes(Node n, String tag) {
        int count = 0;
        if (n == null) {
            return 0;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            ++count;
        }
        return count;
    }

    public static List<Node> getNodes(Node n, String tag) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (n == null) {
            return nodes;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            nodes.add(childnode);
        }
        return nodes;
    }

    public static Node getNodeWithTagValue(Node n, String tag, String subtag, String subtagvalue, int nr) {
        int count = 0;
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node tagnode;
            String value;
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || !(value = XMLHandler.getNodeValue(tagnode = XMLHandler.getSubNode(childnode, subtag))).equalsIgnoreCase(subtagvalue)) continue;
            if (count == nr) {
                return childnode;
            }
            ++count;
        }
        return null;
    }

    public static Node getNodeWithAttributeValue(Node n, String tag, String attributeName, String attributeValue) {
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node attribute;
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || (attribute = childnode.getAttributes().getNamedItem(attributeName)) == null || !attributeValue.equals(attribute.getTextContent())) continue;
            return childnode;
        }
        return null;
    }

    public static Node getSubNode(Node n, String tag) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            return childnode;
        }
        return null;
    }

    public static Node getSubNode(Node n, String tag, String subtag) {
        Node t = XMLHandler.getSubNode(n, tag);
        if (t != null) {
            return XMLHandler.getSubNode(t, subtag);
        }
        return null;
    }

    public static Node getSubNodeByNr(Node n, String tag, int nr) {
        return XMLHandler.getSubNodeByNr(n, tag, nr, true);
    }

    public static Node getSubNodeByNr(Node n, String tag, int nr, boolean useCache) {
        if (n == null) {
            return null;
        }
        int count = 0;
        NodeList children = n.getChildNodes();
        int lastChildNr = -1;
        XMLHandlerCacheEntry entry = null;
        if (useCache) {
            entry = new XMLHandlerCacheEntry(n, tag);
            lastChildNr = cache.getLastChildNr(entry);
        }
        if (lastChildNr < 0) {
            lastChildNr = 0;
        } else {
            count = nr;
            ++lastChildNr;
        }
        for (int i = lastChildNr; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            if (count == nr) {
                if (useCache) {
                    cache.storeCache(entry, i);
                }
                return childnode;
            }
            ++count;
        }
        return null;
    }

    public static String getNodeValue(Node n) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            String retval = childnode.getNodeValue();
            if (retval == null) continue;
            return retval;
        }
        return null;
    }

    public static String getTagAttribute(Node node, String attribute) {
        Node attr;
        if (node == null) {
            return null;
        }
        String retval = null;
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null && (attr = nnm.getNamedItem(attribute)) != null) {
            retval = attr.getNodeValue();
        }
        return retval;
    }

    public static Document loadXMLFile(String filename) throws KettleXMLException {
        try {
            return XMLHandler.loadXMLFile(KettleVFS.getFileObject(filename));
        }
        catch (Exception e) {
            throw new KettleXMLException(e);
        }
    }

    public static Document loadXMLFile(FileObject fileObject) throws KettleXMLException {
        return XMLHandler.loadXMLFile(fileObject, null, false, false);
    }

    public static Document loadXMLFile(FileObject fileObject, String systemID, boolean ignoreEntities, boolean namespaceAware) throws KettleXMLException {
        try {
            return XMLHandler.loadXMLFile(KettleVFS.getInputStream(fileObject), systemID, ignoreEntities, namespaceAware);
        }
        catch (IOException e) {
            throw new KettleXMLException("Unable to read file [" + fileObject.toString() + "]", e);
        }
    }

    public static Document loadXMLFile(InputStream inputStream) throws KettleXMLException {
        return XMLHandler.loadXMLFile(inputStream, null, false, false);
    }

    public static Document loadXMLFile(InputStream inputStream, String systemID, boolean ignoreEntities, boolean namespaceAware) throws KettleXMLException {
        try {
            Document doc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setNamespaceAware(namespaceAware);
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (ignoreEntities) {
                db.setEntityResolver(new DTDIgnoringEntityResolver());
            }
            try {
                if (Const.isEmpty(systemID)) {
                    doc = db.parse(inputStream);
                } else {
                    String systemIDwithEndingSlash = systemID.trim();
                    if (!systemIDwithEndingSlash.endsWith("/") && !systemIDwithEndingSlash.endsWith("\\")) {
                        systemIDwithEndingSlash = systemIDwithEndingSlash.concat("/");
                    }
                    doc = db.parse(inputStream, systemIDwithEndingSlash);
                }
            }
            catch (FileNotFoundException ef) {
                throw new KettleXMLException(ef);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            return doc;
        }
        catch (Exception e) {
            throw new KettleXMLException("Error reading information from input stream", e);
        }
    }

    public static Document loadXMLFile(File resource) throws KettleXMLException {
        try {
            return XMLHandler.loadXMLFile(resource.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new KettleXMLException(e);
        }
    }

    public static Document loadXMLFile(URL resource) throws KettleXMLException {
        try {
            Document doc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStream inputStream = resource.openStream();
            try {
                doc = db.parse(inputStream);
            }
            catch (IOException ef) {
                throw new KettleXMLException(ef);
            }
            finally {
                inputStream.close();
            }
            return doc;
        }
        catch (Exception e) {
            throw new KettleXMLException("Error reading information from resource", e);
        }
    }

    public static Document loadXMLString(String string) throws KettleXMLException {
        return XMLHandler.loadXMLString(string, Boolean.FALSE, Boolean.TRUE);
    }

    public static Node loadXMLString(String xml, String tag) throws KettleXMLException {
        Document doc = XMLHandler.loadXMLString(xml);
        return XMLHandler.getSubNode(doc, tag);
    }

    public static Document loadXMLString(String string, Boolean namespaceAware, Boolean deferNodeExpansion) throws KettleXMLException {
        DocumentBuilder db = XMLHandler.createDocumentBuilder(namespaceAware, deferNodeExpansion);
        return XMLHandler.loadXMLString(db, string);
    }

    public static Document loadXMLString(DocumentBuilder db, String string) throws KettleXMLException {
        try {
            Document doc;
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            try {
                doc = db.parse(inputSource);
            }
            catch (IOException ef) {
                throw new KettleXMLException("Error parsing XML", ef);
            }
            finally {
                stringReader.close();
            }
            return doc;
        }
        catch (Exception e) {
            throw new KettleXMLException("Error reading information from XML string : " + Const.CR + string, e);
        }
    }

    public static DocumentBuilder createDocumentBuilder(boolean namespaceAware, boolean deferNodeExpansion) throws KettleXMLException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", deferNodeExpansion);
            dbf.setNamespaceAware(namespaceAware);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new KettleXMLException(e);
        }
    }

    public static String getString() {
        return XMLHandler.class.getName();
    }

    public static String addTagValue(String tag, String val, boolean cr, String ... attributes) {
        Encoder encoder = ESAPI.encoder();
        StringBuffer value = new StringBuffer("<");
        value.append(tag);
        for (int i = 0; i < attributes.length; i += 2) {
            value.append(" ").append(encoder.encodeForXMLAttribute(attributes[i])).append("=\"").append(attributes[i + 1]).append("\" ");
        }
        if (val != null && val.length() > 0) {
            value.append('>');
            value.append(encoder.encodeForXML(val));
            value.append("</");
            value.append(tag);
            value.append('>');
        } else {
            value.append("/>");
        }
        if (cr) {
            value.append(Const.CR);
        }
        return value.toString();
    }

    public static void appendReplacedChars(StringBuffer value, String string) {
        Encoder encoder = ESAPI.encoder();
        value.append(encoder.encodeForXML(string));
    }

    public static void appendReplacedChars(StringBuilder value, String string) {
        Encoder encoder = ESAPI.encoder();
        value.append(encoder.encodeForXML(string));
    }

    public static String addTagValue(KettleAttributeInterface tag, String val) {
        return XMLHandler.addTagValue(tag.getXmlCode(), val);
    }

    public static String addTagValue(String tag, String val) {
        return XMLHandler.addTagValue(tag, val, true, new String[0]);
    }

    public static String addTagValue(KettleAttributeInterface tag, boolean bool) {
        return XMLHandler.addTagValue(tag.getXmlCode(), bool);
    }

    public static String addTagValue(String tag, boolean bool) {
        return XMLHandler.addTagValue(tag, bool, true);
    }

    public static String addTagValue(String tag, boolean bool, boolean cr) {
        return XMLHandler.addTagValue(tag, bool ? "Y" : "N", cr, new String[0]);
    }

    public static String addTagValue(String tag, long l) {
        return XMLHandler.addTagValue(tag, l, true);
    }

    public static String addTagValue(String tag, long l, boolean cr) {
        return XMLHandler.addTagValue(tag, String.valueOf(l), cr, new String[0]);
    }

    public static String addTagValue(KettleAttributeInterface tag, int i) {
        return XMLHandler.addTagValue(tag.getXmlCode(), i);
    }

    public static String addTagValue(String tag, int i) {
        return XMLHandler.addTagValue(tag, i, true);
    }

    public static String addTagValue(String tag, int i, boolean cr) {
        return XMLHandler.addTagValue(tag, "" + i, cr, new String[0]);
    }

    public static String addTagValue(String tag, double d) {
        return XMLHandler.addTagValue(tag, d, true);
    }

    public static String addTagValue(String tag, double d, boolean cr) {
        return XMLHandler.addTagValue(tag, "" + d, cr, new String[0]);
    }

    public static String addTagValue(String tag, Date date) {
        return XMLHandler.addTagValue(tag, date, true);
    }

    public static String addTagValue(String tag, Date date, boolean cr) {
        return XMLHandler.addTagValue(tag, XMLHandler.date2string(date), cr, new String[0]);
    }

    public static String addTagValue(String tag, BigDecimal val) {
        return XMLHandler.addTagValue(tag, val, true);
    }

    public static String addTagValue(String tag, BigDecimal val, boolean cr) {
        return XMLHandler.addTagValue(tag, val != null ? val.toString() : (String)null, true, new String[0]);
    }

    public static String addTagValue(String tag, byte[] val) throws IOException {
        return XMLHandler.addTagValue(tag, val, true);
    }

    public static String addTagValue(String tag, byte[] val, boolean cr) throws IOException {
        String string = val == null ? null : XMLHandler.encodeBinaryData(val);
        return XMLHandler.addTagValue(tag, string, true, new String[0]);
    }

    public static String encodeBinaryData(byte[] val) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(baos);
        BufferedOutputStream bos = new BufferedOutputStream(gzos);
        bos.write(val);
        bos.flush();
        bos.close();
        return new String(Base64.encodeBase64((byte[])baos.toByteArray()));
    }

    public static String[] getNodeAttributes(Node node) {
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null) {
            String[] attributes = new String[nnm.getLength()];
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node attr = nnm.item(i);
                attributes[i] = attr.getNodeName();
            }
            return attributes;
        }
        return null;
    }

    public static String[] getNodeElements(Node node) {
        ArrayList<String> elements = new ArrayList<String>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodeName = nodeList.item(i).getNodeName();
            if (elements.indexOf(nodeName) >= 0) continue;
            elements.add(nodeName);
        }
        if (elements.isEmpty()) {
            return null;
        }
        return elements.toArray(new String[elements.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date stringToDate(String dateString) {
        if (Const.isEmpty(dateString)) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = XMLHandler.simpleDateFormat;
            synchronized (simpleDateFormat) {
                return XMLHandler.simpleDateFormat.parse(dateString);
            }
        }
        catch (ParseException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String date2string(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = XMLHandler.simpleDateFormat;
        synchronized (simpleDateFormat) {
            return XMLHandler.simpleDateFormat.format(date);
        }
    }

    public static byte[] stringToBinary(String string) throws KettleException {
        try {
            byte[] bytes = string == null ? new byte[]{} : Base64.decodeBase64((byte[])string.getBytes());
            if (bytes.length > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                GZIPInputStream gzip = new GZIPInputStream(bais);
                BufferedInputStream bi = new BufferedInputStream(gzip);
                byte[] result = new byte[]{};
                byte[] extra = new byte[1000000];
                int nrExtra = bi.read(extra);
                while (nrExtra >= 0) {
                    int i;
                    int newSize = result.length + nrExtra;
                    byte[] tmp = new byte[newSize];
                    for (i = 0; i < result.length; ++i) {
                        tmp[i] = result[i];
                    }
                    for (i = 0; i < nrExtra; ++i) {
                        tmp[result.length + i] = extra[i];
                    }
                    result = tmp;
                    nrExtra = bi.read(extra);
                }
                bytes = result;
                gzip.close();
            }
            return bytes;
        }
        catch (Exception e) {
            throw new KettleException("Error converting string to binary", e);
        }
    }

    public static String buildCDATA(String string) {
        return XMLHandler.buildCDATA(new StringBuilder(), string).toString();
    }

    public static StringBuilder buildCDATA(StringBuilder builder, String string) {
        return builder.append("<![CDATA[").append(Const.NVL(string, "")).append("]]>");
    }

    public static String openTag(String tag) {
        return XMLHandler.openTag(new StringBuilder(), tag).toString();
    }

    public static StringBuilder openTag(StringBuilder builder, String tag) {
        return builder.append('<').append(tag).append('>');
    }

    public static String closeTag(String tag) {
        return XMLHandler.closeTag(new StringBuilder(), tag).toString();
    }

    public static StringBuilder closeTag(StringBuilder builder, String tag) {
        return builder.append("</").append(tag).append('>');
    }

    public static String formatNode(Node node) throws KettleXMLException {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to format Node as XML", e);
        }
        return sw.toString();
    }
}

