/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.legacycharts;

import org.pentaho.plugin.jfreereport.reportcharts.AreaChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.BarChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.BarLineChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.BubbleChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.ExtendedXYLineChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.LineChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.MultiPieChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.PieChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.RadarChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.RingChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.ScatterPlotChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.WaterfallChartExpressions;
import org.pentaho.plugin.jfreereport.reportcharts.XYAreaChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.XYAreaLineChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.XYBarChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.XYLineChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.CategorySetDataCollector;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.PieDataSetCollector;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.XYSeriesCollector;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.XYZSeriesCollector;
import org.pentaho.reporting.designer.extensions.legacycharts.ChartDataSource;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public enum ChartType {
    BAR(ChartDataSource.CATEGORY, BarChartExpression.class, CategorySetDataCollector.class),
    LINE(ChartDataSource.CATEGORY, LineChartExpression.class, CategorySetDataCollector.class),
    AREA(ChartDataSource.CATEGORY, AreaChartExpression.class, CategorySetDataCollector.class),
    PIE(ChartDataSource.PIE, PieChartExpression.class, PieDataSetCollector.class),
    MULTI_PIE(ChartDataSource.CATEGORY, MultiPieChartExpression.class, CategorySetDataCollector.class),
    BAR_LINE(ChartDataSource.CATEGORY, ChartDataSource.CATEGORY, "linesDataSource", BarLineChartExpression.class, CategorySetDataCollector.class, CategorySetDataCollector.class),
    RING(ChartDataSource.PIE, RingChartExpression.class, PieDataSetCollector.class),
    BUBBLE(ChartDataSource.XYZ, BubbleChartExpression.class, XYZSeriesCollector.class),
    SCATTER_PLOT(ChartDataSource.XY, ScatterPlotChartExpression.class, XYSeriesCollector.class),
    XY_BAR(ChartDataSource.XY, XYBarChartExpression.class, XYSeriesCollector.class),
    XY_LINE(ChartDataSource.XY, XYLineChartExpression.class, XYSeriesCollector.class),
    XY_AREA(ChartDataSource.XY, XYAreaChartExpression.class, XYSeriesCollector.class),
    EXTENDED_XY_LINE(ChartDataSource.XY, ExtendedXYLineChartExpression.class, XYSeriesCollector.class),
    WATERFALL(ChartDataSource.CATEGORY, WaterfallChartExpressions.class, CategorySetDataCollector.class),
    RADAR(ChartDataSource.CATEGORY, RadarChartExpression.class, CategorySetDataCollector.class),
    XY_AREA_LINE(ChartDataSource.XY, ChartDataSource.XY, "secondaryDataSet", XYAreaLineChartExpression.class, XYSeriesCollector.class, XYSeriesCollector.class);

    private ChartDataSource datasource;
    private ChartDataSource secondaryDataSource;
    private Class expressionType;
    private String secondaryDataSourceProperty;
    private Class preferredPrimaryDataSourceImplementation;
    private Class preferredSecondaryDataSourceImplementation;

    private ChartType(ChartDataSource datasource, Class expressionType, Class preferredPrimaryDataSource) {
        this(datasource, null, null, expressionType, preferredPrimaryDataSource, null);
    }

    private ChartType(ChartDataSource datasource, ChartDataSource secondaryDataSource, String secondaryDataSourceProperty, Class expressionType, Class preferredPrimaryDataSource, Class preferredSecondaryDataSource) {
        if (datasource == null) {
            throw new NullPointerException();
        }
        this.secondaryDataSourceProperty = secondaryDataSourceProperty;
        this.datasource = datasource;
        this.secondaryDataSource = secondaryDataSource;
        this.expressionType = expressionType;
        this.preferredPrimaryDataSourceImplementation = preferredPrimaryDataSource;
        this.preferredSecondaryDataSourceImplementation = preferredSecondaryDataSource;
    }

    public ChartDataSource getDatasource() {
        return this.datasource;
    }

    public ChartDataSource getSecondaryDataSource() {
        return this.secondaryDataSource;
    }

    public String getPrimaryDataSourceProperty() {
        return "dataSource";
    }

    public Class getPreferredPrimaryDataSourceImplementation() {
        return this.preferredPrimaryDataSourceImplementation;
    }

    public Class getPreferredSecondaryDataSourceImplementation() {
        return this.preferredSecondaryDataSourceImplementation;
    }

    public String getSecondaryDataSourceProperty() {
        return this.secondaryDataSourceProperty;
    }

    public Class getExpressionType() {
        return this.expressionType;
    }

    public static ChartType getTypeByChartExpression(Class aClass) {
        ChartType[] types = ChartType.values();
        for (int i = 0; i < types.length; ++i) {
            ChartType type = types[i];
            if (!ObjectUtilities.equal((Object)type.getExpressionType(), (Object)aClass)) continue;
            return type;
        }
        return null;
    }
}

