/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.thrift2.generated.TCellVisibility;
import org.apache.hadoop.hbase.thrift2.generated.TColumnIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TDurability;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TIncrement
implements TBase<TIncrement, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("TIncrement");
    private static final TField ROW_FIELD_DESC = new TField("row", 11, 1);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 2);
    private static final TField ATTRIBUTES_FIELD_DESC = new TField("attributes", 13, 4);
    private static final TField DURABILITY_FIELD_DESC = new TField("durability", 8, 5);
    private static final TField CELL_VISIBILITY_FIELD_DESC = new TField("cellVisibility", 12, 6);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ByteBuffer row;
    public List<TColumnIncrement> columns;
    public Map<ByteBuffer, ByteBuffer> attributes;
    public TDurability durability;
    public TCellVisibility cellVisibility;
    private _Fields[] optionals = new _Fields[]{_Fields.ATTRIBUTES, _Fields.DURABILITY, _Fields.CELL_VISIBILITY};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TIncrement() {
    }

    public TIncrement(ByteBuffer row, List<TColumnIncrement> columns) {
        this();
        this.row = row;
        this.columns = columns;
    }

    public TIncrement(TIncrement other) {
        if (other.isSetRow()) {
            this.row = TBaseHelper.copyBinary((ByteBuffer)other.row);
        }
        if (other.isSetColumns()) {
            ArrayList<TColumnIncrement> __this__columns = new ArrayList<TColumnIncrement>();
            for (TColumnIncrement tColumnIncrement : other.columns) {
                __this__columns.add(new TColumnIncrement(tColumnIncrement));
            }
            this.columns = __this__columns;
        }
        if (other.isSetAttributes()) {
            HashMap<ByteBuffer, ByteBuffer> __this__attributes = new HashMap<ByteBuffer, ByteBuffer>();
            for (Map.Entry entry : other.attributes.entrySet()) {
                ByteBuffer other_element_key = (ByteBuffer)entry.getKey();
                ByteBuffer other_element_value = (ByteBuffer)entry.getValue();
                ByteBuffer __this__attributes_copy_key = TBaseHelper.copyBinary((ByteBuffer)other_element_key);
                ByteBuffer __this__attributes_copy_value = TBaseHelper.copyBinary((ByteBuffer)other_element_value);
                __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
            }
            this.attributes = __this__attributes;
        }
        if (other.isSetDurability()) {
            this.durability = other.durability;
        }
        if (other.isSetCellVisibility()) {
            this.cellVisibility = new TCellVisibility(other.cellVisibility);
        }
    }

    public TIncrement deepCopy() {
        return new TIncrement(this);
    }

    public void clear() {
        this.row = null;
        this.columns = null;
        this.attributes = null;
        this.durability = null;
        this.cellVisibility = null;
    }

    public byte[] getRow() {
        this.setRow(TBaseHelper.rightSize((ByteBuffer)this.row));
        return this.row == null ? null : this.row.array();
    }

    public ByteBuffer bufferForRow() {
        return this.row;
    }

    public TIncrement setRow(byte[] row) {
        this.setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
        return this;
    }

    public TIncrement setRow(ByteBuffer row) {
        this.row = row;
        return this;
    }

    public void unsetRow() {
        this.row = null;
    }

    public boolean isSetRow() {
        return this.row != null;
    }

    public void setRowIsSet(boolean value) {
        if (!value) {
            this.row = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public Iterator<TColumnIncrement> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(TColumnIncrement elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<TColumnIncrement>();
        }
        this.columns.add(elem);
    }

    public List<TColumnIncrement> getColumns() {
        return this.columns;
    }

    public TIncrement setColumns(List<TColumnIncrement> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public int getAttributesSize() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
        if (this.attributes == null) {
            this.attributes = new HashMap<ByteBuffer, ByteBuffer>();
        }
        this.attributes.put(key, val);
    }

    public Map<ByteBuffer, ByteBuffer> getAttributes() {
        return this.attributes;
    }

    public TIncrement setAttributes(Map<ByteBuffer, ByteBuffer> attributes) {
        this.attributes = attributes;
        return this;
    }

    public void unsetAttributes() {
        this.attributes = null;
    }

    public boolean isSetAttributes() {
        return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
        if (!value) {
            this.attributes = null;
        }
    }

    public TDurability getDurability() {
        return this.durability;
    }

    public TIncrement setDurability(TDurability durability) {
        this.durability = durability;
        return this;
    }

    public void unsetDurability() {
        this.durability = null;
    }

    public boolean isSetDurability() {
        return this.durability != null;
    }

    public void setDurabilityIsSet(boolean value) {
        if (!value) {
            this.durability = null;
        }
    }

    public TCellVisibility getCellVisibility() {
        return this.cellVisibility;
    }

    public TIncrement setCellVisibility(TCellVisibility cellVisibility) {
        this.cellVisibility = cellVisibility;
        return this;
    }

    public void unsetCellVisibility() {
        this.cellVisibility = null;
    }

    public boolean isSetCellVisibility() {
        return this.cellVisibility != null;
    }

    public void setCellVisibilityIsSet(boolean value) {
        if (!value) {
            this.cellVisibility = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ROW: {
                if (value == null) {
                    this.unsetRow();
                    break;
                }
                this.setRow((ByteBuffer)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
                break;
            }
            case ATTRIBUTES: {
                if (value == null) {
                    this.unsetAttributes();
                    break;
                }
                this.setAttributes((Map)value);
                break;
            }
            case DURABILITY: {
                if (value == null) {
                    this.unsetDurability();
                    break;
                }
                this.setDurability((TDurability)((Object)value));
                break;
            }
            case CELL_VISIBILITY: {
                if (value == null) {
                    this.unsetCellVisibility();
                    break;
                }
                this.setCellVisibility((TCellVisibility)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ROW: {
                return this.getRow();
            }
            case COLUMNS: {
                return this.getColumns();
            }
            case ATTRIBUTES: {
                return this.getAttributes();
            }
            case DURABILITY: {
                return this.getDurability();
            }
            case CELL_VISIBILITY: {
                return this.getCellVisibility();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ROW: {
                return this.isSetRow();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
            case ATTRIBUTES: {
                return this.isSetAttributes();
            }
            case DURABILITY: {
                return this.isSetDurability();
            }
            case CELL_VISIBILITY: {
                return this.isSetCellVisibility();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TIncrement) {
            return this.equals((TIncrement)that);
        }
        return false;
    }

    public boolean equals(TIncrement that) {
        if (that == null) {
            return false;
        }
        boolean this_present_row = this.isSetRow();
        boolean that_present_row = that.isSetRow();
        if (this_present_row || that_present_row) {
            if (!this_present_row || !that_present_row) {
                return false;
            }
            if (!this.row.equals(that.row)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!this.columns.equals(that.columns)) {
                return false;
            }
        }
        boolean this_present_attributes = this.isSetAttributes();
        boolean that_present_attributes = that.isSetAttributes();
        if (this_present_attributes || that_present_attributes) {
            if (!this_present_attributes || !that_present_attributes) {
                return false;
            }
            if (!this.attributes.equals(that.attributes)) {
                return false;
            }
        }
        boolean this_present_durability = this.isSetDurability();
        boolean that_present_durability = that.isSetDurability();
        if (this_present_durability || that_present_durability) {
            if (!this_present_durability || !that_present_durability) {
                return false;
            }
            if (!this.durability.equals((Object)that.durability)) {
                return false;
            }
        }
        boolean this_present_cellVisibility = this.isSetCellVisibility();
        boolean that_present_cellVisibility = that.isSetCellVisibility();
        if (this_present_cellVisibility || that_present_cellVisibility) {
            if (!this_present_cellVisibility || !that_present_cellVisibility) {
                return false;
            }
            if (!this.cellVisibility.equals(that.cellVisibility)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public int compareTo(TIncrement other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        TIncrement typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetRow()).compareTo(typedOther.isSetRow());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRow() && (lastComparison = TBaseHelper.compareTo((Comparable)this.row, (Comparable)typedOther.row)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(typedOther.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, typedOther.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAttributes()).compareTo(typedOther.isSetAttributes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAttributes() && (lastComparison = TBaseHelper.compareTo(this.attributes, typedOther.attributes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDurability()).compareTo(typedOther.isSetDurability());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDurability() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.durability), (Comparable)((Object)typedOther.durability))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCellVisibility()).compareTo(typedOther.isSetCellVisibility());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCellVisibility() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.cellVisibility), (Comparable)((Object)typedOther.cellVisibility))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TIncrement(");
        boolean first = true;
        sb.append("row:");
        if (this.row == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.row, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        if (this.isSetAttributes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("attributes:");
            if (this.attributes == null) {
                sb.append("null");
            } else {
                sb.append(this.attributes);
            }
            first = false;
        }
        if (this.isSetDurability()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("durability:");
            if (this.durability == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.durability);
            }
            first = false;
        }
        if (this.isSetCellVisibility()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("cellVisibility:");
            if (this.cellVisibility == null) {
                sb.append("null");
            } else {
                sb.append(this.cellVisibility);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.row == null) {
            throw new TProtocolException("Required field 'row' was not present! Struct: " + this.toString());
        }
        if (this.columns == null) {
            throw new TProtocolException("Required field 'columns' was not present! Struct: " + this.toString());
        }
        if (this.cellVisibility != null) {
            this.cellVisibility.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TIncrementStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TIncrementTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ROW, new FieldMetaData("row", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TColumnIncrement.class))));
        tmpMap.put(_Fields.ATTRIBUTES, new FieldMetaData("attributes", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11, true), new FieldValueMetaData(11, true))));
        tmpMap.put(_Fields.DURABILITY, new FieldMetaData("durability", 2, (FieldValueMetaData)new EnumMetaData(16, TDurability.class)));
        tmpMap.put(_Fields.CELL_VISIBILITY, new FieldMetaData("cellVisibility", 2, (FieldValueMetaData)new StructMetaData(12, TCellVisibility.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TIncrement.class, metaDataMap);
    }

    private static class TIncrementTupleScheme
    extends TupleScheme<TIncrement> {
        private TIncrementTupleScheme() {
        }

        public void write(TProtocol prot, TIncrement struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeBinary(struct.row);
            oprot.writeI32(struct.columns.size());
            for (TColumnIncrement _iter79 : struct.columns) {
                _iter79.write((TProtocol)oprot);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetAttributes()) {
                optionals.set(0);
            }
            if (struct.isSetDurability()) {
                optionals.set(1);
            }
            if (struct.isSetCellVisibility()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetAttributes()) {
                oprot.writeI32(struct.attributes.size());
                for (Map.Entry<ByteBuffer, ByteBuffer> _iter80 : struct.attributes.entrySet()) {
                    oprot.writeBinary(_iter80.getKey());
                    oprot.writeBinary(_iter80.getValue());
                }
            }
            if (struct.isSetDurability()) {
                oprot.writeI32(struct.durability.getValue());
            }
            if (struct.isSetCellVisibility()) {
                struct.cellVisibility.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, TIncrement struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.row = iprot.readBinary();
            struct.setRowIsSet(true);
            TList _list81 = new TList(12, iprot.readI32());
            struct.columns = new ArrayList<TColumnIncrement>(_list81.size);
            for (int _i82 = 0; _i82 < _list81.size; ++_i82) {
                TColumnIncrement _elem83 = new TColumnIncrement();
                _elem83.read((TProtocol)iprot);
                struct.columns.add(_elem83);
            }
            struct.setColumnsIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                TMap _map84 = new TMap(11, 11, iprot.readI32());
                struct.attributes = new HashMap<ByteBuffer, ByteBuffer>(2 * _map84.size);
                for (int _i85 = 0; _i85 < _map84.size; ++_i85) {
                    ByteBuffer _key86 = iprot.readBinary();
                    ByteBuffer _val87 = iprot.readBinary();
                    struct.attributes.put(_key86, _val87);
                }
                struct.setAttributesIsSet(true);
            }
            if (incoming.get(1)) {
                struct.durability = TDurability.findByValue(iprot.readI32());
                struct.setDurabilityIsSet(true);
            }
            if (incoming.get(2)) {
                struct.cellVisibility = new TCellVisibility();
                struct.cellVisibility.read((TProtocol)iprot);
                struct.setCellVisibilityIsSet(true);
            }
        }
    }

    private static class TIncrementTupleSchemeFactory
    implements SchemeFactory {
        private TIncrementTupleSchemeFactory() {
        }

        public TIncrementTupleScheme getScheme() {
            return new TIncrementTupleScheme();
        }
    }

    private static class TIncrementStandardScheme
    extends StandardScheme<TIncrement> {
        private TIncrementStandardScheme() {
        }

        public void read(TProtocol iprot, TIncrement struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.row = iprot.readBinary();
                            struct.setRowIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list70 = iprot.readListBegin();
                            struct.columns = new ArrayList<TColumnIncrement>(_list70.size);
                            for (int _i71 = 0; _i71 < _list70.size; ++_i71) {
                                TColumnIncrement _elem72 = new TColumnIncrement();
                                _elem72.read(iprot);
                                struct.columns.add(_elem72);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 13) {
                            TMap _map73 = iprot.readMapBegin();
                            struct.attributes = new HashMap<ByteBuffer, ByteBuffer>(2 * _map73.size);
                            for (int _i74 = 0; _i74 < _map73.size; ++_i74) {
                                ByteBuffer _key75 = iprot.readBinary();
                                ByteBuffer _val76 = iprot.readBinary();
                                struct.attributes.put(_key75, _val76);
                            }
                            iprot.readMapEnd();
                            struct.setAttributesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.durability = TDurability.findByValue(iprot.readI32());
                            struct.setDurabilityIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 12) {
                            struct.cellVisibility = new TCellVisibility();
                            struct.cellVisibility.read(iprot);
                            struct.setCellVisibilityIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TIncrement struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.row != null) {
                oprot.writeFieldBegin(ROW_FIELD_DESC);
                oprot.writeBinary(struct.row);
                oprot.writeFieldEnd();
            }
            if (struct.columns != null) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columns.size()));
                for (TColumnIncrement tColumnIncrement : struct.columns) {
                    tColumnIncrement.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.attributes != null && struct.isSetAttributes()) {
                oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.attributes.size()));
                for (Map.Entry entry : struct.attributes.entrySet()) {
                    oprot.writeBinary((ByteBuffer)entry.getKey());
                    oprot.writeBinary((ByteBuffer)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.durability != null && struct.isSetDurability()) {
                oprot.writeFieldBegin(DURABILITY_FIELD_DESC);
                oprot.writeI32(struct.durability.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.cellVisibility != null && struct.isSetCellVisibility()) {
                oprot.writeFieldBegin(CELL_VISIBILITY_FIELD_DESC);
                struct.cellVisibility.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TIncrementStandardSchemeFactory
    implements SchemeFactory {
        private TIncrementStandardSchemeFactory() {
        }

        public TIncrementStandardScheme getScheme() {
            return new TIncrementStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ROW(1, "row"),
        COLUMNS(2, "columns"),
        ATTRIBUTES(4, "attributes"),
        DURABILITY(5, "durability"),
        CELL_VISIBILITY(6, "cellVisibility");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ROW;
                }
                case 2: {
                    return COLUMNS;
                }
                case 4: {
                    return ATTRIBUTES;
                }
                case 5: {
                    return DURABILITY;
                }
                case 6: {
                    return CELL_VISIBILITY;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

