/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.FieldDefinitionSource;
import org.pentaho.openformula.ui.FormulaEditorModel;
import org.pentaho.openformula.ui.FunctionInformationPanel;
import org.pentaho.openformula.ui.FunctionListPanel;
import org.pentaho.openformula.ui.FunctionParameterContext;
import org.pentaho.openformula.ui.FunctionParameterEditor;
import org.pentaho.openformula.ui.Messages;
import org.pentaho.openformula.ui.MultiplexFunctionParameterEditor;
import org.pentaho.openformula.ui.ParameterUpdateEvent;
import org.pentaho.openformula.ui.ParameterUpdateListener;
import org.pentaho.openformula.ui.model2.FunctionInformation;
import org.pentaho.openformula.ui.util.FunctionParameterEditHelper;
import org.pentaho.openformula.ui.util.InlineEditTextArea;
import org.pentaho.openformula.ui.util.SelectFieldAction;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.HorizontalLayout;
import org.pentaho.reporting.libraries.designtime.swing.ToolbarButton;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeUtil;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class FormulaEditorPanel
extends JComponent
implements FieldDefinitionSource {
    private boolean ignoreTextEvents;
    private FunctionListPanel functionSelectorPanel;
    private MultiplexFunctionParameterEditor functionParameterEditor;
    private FunctionInformationPanel functionInformationPanel;
    private FormulaContext formulaContext;
    private InlineEditTextArea functionTextArea;
    private JLabel errorTextHolder;
    private JLabel errorIconHolder;
    private FieldDefinition[] fields;
    private FormulaEditorModel editorModel;
    private ImageIcon errorIcon;
    private SelectFieldAction selectFieldsAction;
    private JToolBar operatorPanel;
    private DocumentSyncHandler docSyncHandler;
    private ParameterUpdateHandler parameterUpdateHandler;

    public FormulaEditorPanel() {
        this.init();
    }

    public FormulaEditorModel getEditorModel() {
        return this.editorModel;
    }

    public DocumentSyncHandler getDocSyncHandler() {
        return this.docSyncHandler;
    }

    public void setDocSyncHandler(DocumentSyncHandler docSyncHandler) {
        this.docSyncHandler = docSyncHandler;
    }

    protected MultiplexFunctionParameterEditor getFunctionParameterEditor() {
        return this.functionParameterEditor;
    }

    protected void insertText(String text) {
        int start = this.functionTextArea.getCaretPosition();
        String formulaTextOriginal = this.editorModel.getFormulaText();
        StringBuilder formulaText = new StringBuilder(formulaTextOriginal);
        int textLength = text.length();
        if ("=".equals(formulaTextOriginal)) {
            if (text.startsWith("=")) {
                formulaText.append(text.substring(1));
                --textLength;
            } else {
                formulaText.append(text);
            }
        } else {
            String formulaFrag = text;
            if (formulaTextOriginal.length() == 0 && start == 0) {
                formulaFrag = "=" + text;
            }
            formulaText.insert(start, formulaFrag);
        }
        this.ignoreTextEvents = true;
        this.editorModel.setFormulaText(formulaText.toString());
        this.functionTextArea.setText(formulaText.toString());
        this.ignoreTextEvents = false;
        this.functionTextArea.setCaretPosition(textLength + start);
        this.functionTextArea.requestFocus();
        this.revalidateParameters(false);
        this.revalidateFormulaSyntax();
    }

    public JToolBar getOperatorPanel() {
        return this.operatorPanel;
    }

    public void setEditor(String function, FunctionParameterEditor editor) {
        this.functionParameterEditor.setEditor(function, editor);
    }

    public FunctionParameterEditor getEditor(String function) {
        return this.functionParameterEditor.getEditor(function);
    }

    public JTextArea getFunctionTextArea() {
        return this.functionTextArea;
    }

    protected void init() {
        this.editorModel = new FormulaEditorModel();
        this.functionInformationPanel = new FunctionInformationPanel();
        this.functionParameterEditor = new MultiplexFunctionParameterEditor();
        this.parameterUpdateHandler = new ParameterUpdateHandler();
        this.functionParameterEditor.addParameterUpdateListener(this.parameterUpdateHandler);
        this.functionTextArea = new InlineEditTextArea();
        this.setDocSyncHandler(new DocumentSyncHandler());
        this.functionTextArea.addPropertyChangeListener("text", this.getDocSyncHandler());
        this.functionTextArea.setRows(6);
        this.functionTextArea.addCaretListener(new CaretHandler());
        this.functionTextArea.setFont(new Font("Monospaced", this.functionTextArea.getFont().getStyle(), this.functionTextArea.getFont().getSize()));
        this.formulaContext = new DefaultFormulaContext();
        this.functionSelectorPanel = new FunctionListPanel();
        this.functionSelectorPanel.addPropertyChangeListener("selectedValue", new FunctionDescriptionUpdateHandler());
        this.functionSelectorPanel.addActionListener(new FunctionDescriptionUpdateHandler());
        this.functionSelectorPanel.setFormulaContext(this.formulaContext);
        this.errorIcon = new ImageIcon(this.getClass().getResource("/org/pentaho/openformula/ui/images/error.gif"));
        this.errorIconHolder = new JLabel();
        this.errorTextHolder = new JLabel();
        this.errorTextHolder.setName("errorTextHolder");
        this.selectFieldsAction = new SelectFieldAction(this, new FieldSelectorListener(), this);
        JSplitPane functionPanel = new JSplitPane(0);
        functionPanel.setTopComponent(this.functionParameterEditor.getEditorComponent());
        functionPanel.setBottomComponent(this.buildFormulaTextPanel());
        functionPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.functionSelectorPanel, "West");
        this.add((Component)this.functionInformationPanel, "South");
        this.add((Component)functionPanel, "Center");
    }

    private JComponent buildFormulaTextPanel() {
        this.operatorPanel = this.createOperatorPanel();
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 0, 5, 0);
        textPanel.add((Component)this.operatorPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        textPanel.add((Component)new JLabel(Messages.getInstance().getString("FormulaEditorDialog.Formula")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        textPanel.add((Component)this.errorIconHolder, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.fill = 1;
        textPanel.add((Component)this.errorTextHolder, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        textPanel.add((Component)new JScrollPane(this.functionTextArea), gbc);
        return textPanel;
    }

    protected JToolBar createOperatorPanel() {
        JToolBar operatorButtonPanel = new JToolBar();
        operatorButtonPanel.setFloatable(false);
        operatorButtonPanel.setOpaque(false);
        operatorButtonPanel.setLayout((LayoutManager)new HorizontalLayout(2));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("+", Messages.getInstance().getString("FormulaEditorDialog.Operator.Add"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("-", Messages.getInstance().getString("FormulaEditorDialog.Operator.Subtract"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("*", Messages.getInstance().getString("FormulaEditorDialog.Operator.Multiply"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("/", Messages.getInstance().getString("FormulaEditorDialog.Operator.Divide"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("^", Messages.getInstance().getString("FormulaEditorDialog.Operator.Power"))));
        operatorButtonPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("=", Messages.getInstance().getString("FormulaEditorDialog.Operator.Equal"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("<>", Messages.getInstance().getString("FormulaEditorDialog.Operator.NotEqual"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("<", Messages.getInstance().getString("FormulaEditorDialog.Operator.Lesser"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction(">", Messages.getInstance().getString("FormulaEditorDialog.Operator.Greater"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("<=", Messages.getInstance().getString("FormulaEditorDialog.Operator.LesserEqual"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction(">=", Messages.getInstance().getString("FormulaEditorDialog.Operator.GreaterEqual"))));
        operatorButtonPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("%", Messages.getInstance().getString("FormulaEditorDialog.Operator.Percentage"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("&", Messages.getInstance().getString("FormulaEditorDialog.Operator.Concatenation"))));
        operatorButtonPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)this.selectFieldsAction));
        return operatorButtonPanel;
    }

    public ParameterUpdateHandler getParameterUpdateHandler() {
        return this.parameterUpdateHandler;
    }

    public String getFormulaText() {
        return this.functionTextArea.getText();
    }

    public void setFormulaText(String formulaText) {
        if (formulaText == null || formulaText.length() == 0) {
            formulaText = "=";
        } else if (!formulaText.startsWith("=")) {
            formulaText = "=" + formulaText;
        }
        this.functionTextArea.setText(formulaText);
        this.functionTextArea.setCaretPosition(formulaText.length());
        this.editorModel.setFormulaText(formulaText);
        this.editorModel.setCaretPosition(this.functionTextArea.getCaretPosition());
        this.revalidateParameters(true);
    }

    public void setFields(FieldDefinition[] fields) {
        if (fields == null) {
            throw new NullPointerException();
        }
        this.fields = (FieldDefinition[])fields.clone();
        this.functionParameterEditor.setFields(fields);
    }

    @Override
    public FieldDefinition[] getFields() {
        return (FieldDefinition[])this.fields.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void revalidateParameters(boolean switchParameterEditor) {
        this.editorModel.revalidateStructure();
        if (this.formulaContext == null) {
            this.functionParameterEditor.clearSelectedFunction();
            return;
        }
        FunctionInformation fnInfo = this.editorModel.getCurrentFunction();
        if (fnInfo == null) {
            this.functionParameterEditor.clearSelectedFunction();
            return;
        }
        FunctionDescription fnDesc = this.formulaContext.getFunctionRegistry().getMetaData(fnInfo.getCanonicalName());
        if (fnDesc == null) {
            this.functionParameterEditor.clearSelectedFunction();
            return;
        }
        this.functionInformationPanel.setSelectedFunction(fnDesc);
        try {
            this.ignoreTextEvents = true;
            this.functionParameterEditor.setSelectedFunction(new FunctionParameterContext(fnDesc, fnInfo, switchParameterEditor, this.editorModel));
        }
        finally {
            this.ignoreTextEvents = false;
        }
    }

    private void refreshInformationPanel() {
        FunctionInformation currentFunction = this.editorModel.getCurrentFunction();
        FunctionDescription description = currentFunction != null ? this.formulaContext.getFunctionRegistry().getMetaData(currentFunction.getCanonicalName()) : this.functionSelectorPanel.getSelectedValue();
        this.functionInformationPanel.setSelectedFunction(description);
    }

    protected void revalidateFormulaSyntax() {
        try {
            String rawFormula = this.editorModel.getFormulaText();
            if (StringUtils.isEmpty((String)rawFormula)) {
                this.errorTextHolder.setText("");
                this.errorTextHolder.setToolTipText(null);
                this.errorIconHolder.setIcon(null);
                return;
            }
            String formulaText = FormulaUtil.extractFormula((String)rawFormula);
            if (StringUtils.isEmpty((String)formulaText)) {
                this.errorTextHolder.setText(Messages.getInstance().getString("FormulaEditorDialog.ShortErrorNoFormulaContext"));
                this.errorTextHolder.setToolTipText(Messages.getInstance().getString("FormulaEditorDialog.ErrorNoFormulaContext"));
                return;
            }
            Formula formula = new Formula(formulaText);
            formula.initialize(this.formulaContext);
            TypeValuePair pair = formula.evaluateTyped();
            if (pair.getValue() instanceof LibFormulaErrorValue) {
                this.errorTextHolder.setText(Messages.getInstance().getString("FormulaEditorDialog.ShortEvaluationError"));
                this.errorTextHolder.setToolTipText(Messages.getInstance().getString("FormulaEditorDialog.EvaluationError"));
            } else {
                this.errorTextHolder.setToolTipText(null);
                this.errorTextHolder.setText(Messages.getInstance().getString("FormulaEditorDialog.EvaluationResult", String.valueOf(pair.getValue())));
            }
            this.errorIconHolder.setIcon(null);
        }
        catch (ParseException pe) {
            this.errorIconHolder.setIcon(this.errorIcon);
            if (pe.currentToken == null) {
                this.errorTextHolder.setText(Messages.getInstance().getString("FormulaEditorDialog.ShortParseError"));
                this.errorTextHolder.setToolTipText(Messages.getInstance().getString("FormulaEditorDialog.GenericParseError", pe.getLocalizedMessage()));
            } else {
                String token = pe.currentToken.toString();
                int line = pe.currentToken.beginLine;
                int column = pe.currentToken.beginColumn;
                this.errorTextHolder.setText(Messages.getInstance().getString("FormulaEditorDialog.ShortParseError"));
                this.errorTextHolder.setToolTipText(Messages.getInstance().getString("FormulaEditorDialog.ParseError", new Object[]{token, line, column}));
            }
        }
        catch (Exception e) {
            this.errorIconHolder.setIcon(this.errorIcon);
            this.errorTextHolder.setText(Messages.getInstance().getString("FormulaEditorDialog.ShortParseError"));
            this.errorTextHolder.setToolTipText(Messages.getInstance().getString("FormulaEditorDialog.GenericParseError", e.getLocalizedMessage()));
        }
    }

    private class InsertOperatorAction
    extends AbstractAction {
        private String symbol;
        private static final int IMAGE_SIZE = 16;

        private InsertOperatorAction(String symbol, String description) {
            this.symbol = symbol;
            this.putValue("SmallIcon", this.createImage(symbol));
            this.putValue("ShortDescription", description);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormulaEditorPanel.this.insertText(this.symbol);
        }

        private ImageIcon createImage(String symbol) {
            BufferedImage bi = new BufferedImage(16, 16, 2);
            Graphics graphics = bi.getGraphics();
            Rectangle2D stringBounds = graphics.getFontMetrics().getStringBounds(symbol, graphics);
            int xspace = (int)Math.max(16.0 - stringBounds.getWidth(), 0.0);
            int yspace = (int)Math.max(16.0 - stringBounds.getHeight(), 0.0);
            graphics.setColor(Color.BLACK);
            double y2 = stringBounds.getY();
            int y1 = (int)((double)(yspace / 2) - y2);
            graphics.drawString(symbol, xspace / 2, y1);
            graphics.dispose();
            return new ImageIcon(bi);
        }
    }

    private class FieldSelectorListener
    implements PropertyChangeListener {
        private FieldSelectorListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FieldDefinition value = (FieldDefinition)evt.getNewValue();
            String text = FormulaUtil.quoteReference((String)value.getName());
            FormulaEditorPanel.this.insertText(text);
        }
    }

    public class ParameterUpdateHandler
    implements ParameterUpdateListener {
        private ParameterUpdateHandler() {
        }

        public boolean isEmbeddedFunction(String parameterText) {
            return parameterText != null && parameterText.contains("(") && parameterText.contains(")");
        }

        @Override
        public synchronized void parameterUpdated(ParameterUpdateEvent event) {
            if (FormulaEditorPanel.this.ignoreTextEvents) {
                return;
            }
            FunctionInformation fn = FormulaEditorPanel.this.editorModel.getCurrentFunction();
            if (fn == null) {
                return;
            }
            FunctionParameterEditHelper.EditResult formulaText = FunctionParameterEditHelper.buildFormulaText(event, fn, FormulaEditorPanel.this.editorModel.getFormulaText());
            FormulaEditorPanel.this.ignoreTextEvents = true;
            FormulaEditorPanel.this.editorModel.setFormulaText(formulaText.text);
            FormulaEditorPanel.this.functionTextArea.setText(formulaText.text);
            FormulaEditorPanel.this.functionTextArea.setCaretPosition(formulaText.caretPositionAfterEdit);
            FormulaEditorPanel.this.editorModel.setCaretPosition(FormulaEditorPanel.this.functionTextArea.getCaretPosition());
            FormulaEditorPanel.this.ignoreTextEvents = false;
            FormulaEditorPanel.this.revalidateParameters(false);
            FormulaEditorPanel.this.revalidateFormulaSyntax();
        }
    }

    private class DocumentSyncHandler
    implements PropertyChangeListener {
        private DocumentSyncHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"text".equals(evt.getPropertyName())) {
                return;
            }
            if (FormulaEditorPanel.this.ignoreTextEvents) {
                return;
            }
            this.run();
        }

        public void run() {
            FormulaEditorPanel.this.editorModel.setFormulaText(FormulaEditorPanel.this.functionTextArea.getText());
            FormulaEditorPanel.this.editorModel.setCaretPosition(FormulaEditorPanel.this.functionTextArea.getCaretPosition());
            FormulaEditorPanel.this.ignoreTextEvents = false;
            FormulaEditorPanel.this.revalidateParameters(false);
            FormulaEditorPanel.this.revalidateFormulaSyntax();
        }
    }

    private class FunctionDescriptionUpdateHandler
    implements PropertyChangeListener,
    ActionListener {
        private FunctionDescriptionUpdateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FormulaEditorPanel.this.refreshInformationPanel();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FunctionDescription selectedFunction = FormulaEditorPanel.this.functionSelectorPanel.getSelectedValue();
            StringBuilder b = new StringBuilder(100);
            b.append(selectedFunction.getCanonicalName());
            b.append('(');
            int count = selectedFunction.isInfiniteParameterCount() ? Math.min(1, selectedFunction.getParameterCount()) : selectedFunction.getParameterCount();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    b.append(";");
                }
                Type type = selectedFunction.getParameterType(i);
                b.append(TypeUtil.getParameterType((Type)type, (Locale)FormulaEditorPanel.this.getLocale()));
            }
            b.append(')');
            try {
                Document document = FormulaEditorPanel.this.functionTextArea.getDocument();
                int selectionStart = FormulaEditorPanel.this.functionTextArea.getSelectionStart();
                document.remove(selectionStart, FormulaEditorPanel.this.functionTextArea.getSelectionEnd() - selectionStart);
                document.insertString(FormulaEditorPanel.this.functionTextArea.getCaretPosition(), b.toString(), null);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (FormulaEditorPanel.this.ignoreTextEvents) {
                return;
            }
            FormulaEditorPanel.this.editorModel.setCaretPosition(FormulaEditorPanel.this.functionTextArea.getCaretPosition());
            FormulaEditorPanel.this.refreshInformationPanel();
            FormulaEditorPanel.this.revalidateParameters(true);
        }
    }
}

