/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui.util;

import javax.swing.JTextArea;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public class InlineEditTextArea
extends JTextArea {
    private final DocProxy doc = new DocProxy(this.getDocument());
    private boolean documentLocked;

    public InlineEditTextArea() {
        super.setDocument(this.doc);
        this.documentLocked = true;
    }

    @Override
    public void setDocument(Document doc) {
        if (this.documentLocked) {
            throw new IllegalStateException();
        }
        super.setDocument(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(String t) {
        String old = this.getText();
        try {
            this.doc.suspendEvents = true;
            super.setText(t);
        }
        finally {
            this.firePropertyChange("text", old, this.getText());
            this.doc.suspendEvents = false;
        }
    }

    private class DocProxy
    implements Document {
        private Document document;
        private boolean suspendEvents;

        private DocProxy(Document document) {
            this.document = document;
        }

        @Override
        public int getLength() {
            return this.document.getLength();
        }

        @Override
        public void addDocumentListener(DocumentListener listener) {
            this.document.addDocumentListener(listener);
        }

        @Override
        public void removeDocumentListener(DocumentListener listener) {
            this.document.removeDocumentListener(listener);
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener listener) {
            this.document.addUndoableEditListener(listener);
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener listener) {
            this.document.removeUndoableEditListener(listener);
        }

        @Override
        public Object getProperty(Object key) {
            return this.document.getProperty(key);
        }

        @Override
        public void putProperty(Object key, Object value) {
            this.document.putProperty(key, value);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            String old = InlineEditTextArea.this.getText();
            this.document.remove(offs, len);
            if (!this.suspendEvents) {
                InlineEditTextArea.this.firePropertyChange("text", old, InlineEditTextArea.this.getText());
            }
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            String old = InlineEditTextArea.this.getText();
            this.document.insertString(offset, str, a);
            if (!this.suspendEvents) {
                InlineEditTextArea.this.firePropertyChange("text", old, InlineEditTextArea.this.getText());
            }
        }

        @Override
        public String getText(int offset, int length) throws BadLocationException {
            return this.document.getText(offset, length);
        }

        @Override
        public void getText(int offset, int length, Segment txt) throws BadLocationException {
            this.document.getText(offset, length, txt);
        }

        @Override
        public Position getStartPosition() {
            return this.document.getStartPosition();
        }

        @Override
        public Position getEndPosition() {
            return this.document.getEndPosition();
        }

        @Override
        public Position createPosition(int offs) throws BadLocationException {
            return this.document.createPosition(offs);
        }

        @Override
        public Element[] getRootElements() {
            return this.document.getRootElements();
        }

        @Override
        public Element getDefaultRootElement() {
            return this.document.getDefaultRootElement();
        }

        @Override
        public void render(Runnable r) {
            this.document.render(r);
        }
    }
}

