/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.launcher;

import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.pentaho.commons.launcher.config.Configuration;
import org.pentaho.commons.launcher.config.Parameters;
import org.pentaho.commons.launcher.util.FileUtil;
import org.pentaho.commons.launcher.util.StringUtil;

public class Launcher {
    public static void main(String[] args) throws Exception {
        Parameters parameters = Parameters.fromArgs(args, System.err);
        URL location = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
        File appDir = FileUtil.computeApplicationDir(location, new File("."), System.err);
        File configurationFile = new File(appDir, "launcher.properties");
        Properties configProperties = new Properties();
        try {
            configProperties.load(new FileReader(configurationFile));
        }
        catch (Exception e) {
            // empty catch block
        }
        Configuration configuration = Configuration.create(configProperties, appDir, parameters);
        if (configuration.isUninstallSecurityManager()) {
            System.setSecurityManager(null);
        }
        for (Map.Entry<String, String> systemProperty : configuration.getSystemProperties().entrySet()) {
            System.setProperty(systemProperty.getKey(), systemProperty.getValue());
        }
        List<URL> jars = FileUtil.populateClasspath(configuration.getClasspath(), appDir, System.err);
        jars.addAll(FileUtil.populateLibraries(configuration.getLibraries(), appDir, System.err));
        URL[] classpathEntries = jars.toArray(new URL[jars.size()]);
        URLClassLoader cl = new URLClassLoader(classpathEntries);
        Thread.currentThread().setContextClassLoader(cl);
        if (StringUtil.isEmpty(configuration.getMainClass())) {
            System.err.println("Invalid main-class entry, cannot proceed.");
            System.err.println("Application Directory: " + appDir);
            System.exit(1);
        }
        if (configuration.isDebug()) {
            System.out.println("Application Directory: " + appDir);
            for (int i = 0; i < classpathEntries.length; ++i) {
                URL url = classpathEntries[i];
                System.out.println("ClassPath[" + i + "] = " + url);
            }
        }
        Class<?> mainClass = cl.loadClass(configuration.getMainClass());
        String[] newArgs = new String[args.length - parameters.getParsedArgs()];
        System.arraycopy(args, parameters.getParsedArgs(), newArgs, 0, newArgs.length);
        Method method = mainClass.getMethod("main", String[].class);
        method.invoke(null, new Object[]{newArgs});
    }
}

