/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterator;
import mondrian.calc.TupleList;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTupleList
extends AbstractList<List<Member>>
implements RandomAccess,
Cloneable,
TupleList {
    protected final int arity;
    protected boolean mutable = true;

    public AbstractTupleList(int arity) {
        this.arity = arity;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    protected abstract TupleIterator tupleIteratorInternal();

    @Override
    public abstract TupleList subList(int var1, int var2);

    @Override
    public TupleList fix() {
        return new DelegatingTupleList(this.arity, new ArrayList<List<Member>>(this));
    }

    @Override
    public final Iterator<List<Member>> iterator() {
        return this.tupleIteratorInternal();
    }

    @Override
    public final TupleIterator tupleIterator() {
        return this.tupleIteratorInternal();
    }

    @Override
    public TupleCursor tupleCursor() {
        return this.tupleIteratorInternal();
    }

    @Override
    public void addCurrent(TupleCursor tupleIter) {
        this.add(tupleIter.current());
    }

    @Override
    public Member get(int slice, int index) {
        return (Member)((List)this.get(index)).get(slice);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AbstractTupleListIterator
    implements TupleIterator {
        int cursor = 0;
        int lastRet = -1;

        protected AbstractTupleListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != AbstractTupleList.this.size();
        }

        @Override
        public List<Member> next() {
            try {
                List next = (List)AbstractTupleList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean forward() {
            if (this.cursor == AbstractTupleList.this.size()) {
                return false;
            }
            this.lastRet = this.cursor++;
            return true;
        }

        @Override
        public List<Member> current() {
            return (List)AbstractTupleList.this.get(this.lastRet);
        }

        @Override
        public void currentToArray(Member[] members, int offset) {
            List<Member> current = this.current();
            if (offset == 0) {
                current.toArray(members);
            } else {
                System.arraycopy(current.toArray(), 0, members, offset, AbstractTupleList.this.arity);
            }
        }

        @Override
        public int getArity() {
            return AbstractTupleList.this.getArity();
        }

        @Override
        public void remove() {
            assert (AbstractTupleList.this.mutable);
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                AbstractTupleList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void setContext(Evaluator evaluator) {
            evaluator.setContext(this.current());
        }

        @Override
        public Member member(int column) {
            return (Member)((List)AbstractTupleList.this.get(this.lastRet)).get(column);
        }
    }
}

