/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Property;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;

class PropertiesFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();

    public PropertiesFunDef(String name, String signature, String description, Syntax syntax, int returnType, int[] parameterTypes) {
        super(name, signature, description, syntax, returnType, parameterTypes);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        final StringCalc stringCalc = compiler.compileString(call.getArg(1));
        return new GenericCalc(call){

            public Object evaluate(Evaluator evaluator) {
                return PropertiesFunDef.properties(memberCalc.evaluateMember(evaluator), stringCalc.evaluateString(evaluator));
            }

            public Calc[] getCalcs() {
                return new Calc[]{memberCalc, stringCalc};
            }
        };
    }

    static Object properties(Member member, String s) {
        boolean matchCase = MondrianProperties.instance().CaseSensitive.get();
        Object o = member.getPropertyValue(s, matchCase);
        if (o == null && !Util.isValidProperty(s, member.getLevel())) {
            throw new MondrianEvaluationException("Property '" + s + "' is not valid for member '" + member + "'");
        }
        return o;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolverImpl
    extends ResolverBase {
        private static final int[] PARAMETER_TYPES = new int[]{6, 9};

        private ResolverImpl() {
            super("Properties", "<Member>.Properties(<String Expression>)", "Returns the value of a member property.", Syntax.Method);
        }

        private boolean matches(Exp[] args, int[] parameterTypes, Validator validator, List<Resolver.Conversion> conversions) {
            if (parameterTypes.length != args.length) {
                return false;
            }
            for (int i = 0; i < args.length; ++i) {
                if (validator.canConvert(i, args[i], parameterTypes[i], conversions)) continue;
                return false;
            }
            return true;
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            if (!this.matches(args, PARAMETER_TYPES, validator, conversions)) {
                return null;
            }
            int returnType = this.deducePropertyCategory(args[0], args[1]);
            return new PropertiesFunDef(this.getName(), this.getSignature(), this.getDescription(), this.getSyntax(), returnType, PARAMETER_TYPES);
        }

        private int deducePropertyCategory(Exp memberExp, Exp propertyNameExp) {
            if (!(propertyNameExp instanceof Literal)) {
                return 13;
            }
            String propertyName = (String)((Literal)propertyNameExp).getValue();
            Hierarchy hierarchy = memberExp.getType().getHierarchy();
            if (hierarchy == null) {
                return 13;
            }
            Level[] levels = hierarchy.getLevels();
            Property property = ResolverImpl.lookupProperty(levels[levels.length - 1], propertyName);
            if (property == null) {
                return 13;
            }
            switch (property.getType()) {
                case TYPE_BOOLEAN: {
                    return 5;
                }
                case TYPE_NUMERIC: {
                    return 7;
                }
                case TYPE_STRING: {
                    return 9;
                }
                case TYPE_DATE: 
                case TYPE_TIME: 
                case TYPE_TIMESTAMP: {
                    return 18;
                }
            }
            throw Util.badValue(property.getType());
        }

        @Override
        public boolean requiresExpression(int k) {
            return true;
        }
    }
}

