/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Formats;
import org.kitesdk.data.View;
import org.kitesdk.data.mapreduce.DatasetKeyOutputFormat;
import org.kitesdk.data.spi.SchemaValidationUtil;

public final class ParquetJob {
    private static final String CONF_AVRO_SCHEMA = "avro.schema";

    private ParquetJob() {
    }

    public static Schema getAvroSchema(Configuration conf) {
        return new Schema.Parser().parse(conf.get(CONF_AVRO_SCHEMA));
    }

    public static void configureImportJob(Configuration conf, Schema schema, String uri, boolean doAppend) throws IOException {
        Dataset dataset;
        if (doAppend) {
            try {
                dataset = (Dataset)Datasets.load((String)uri);
            }
            catch (DatasetNotFoundException ex) {
                dataset = ParquetJob.createDataset(schema, uri);
            }
            Schema writtenWith = dataset.getDescriptor().getSchema();
            if (!SchemaValidationUtil.canRead((Schema)writtenWith, (Schema)schema)) {
                throw new IOException(String.format("Expected schema: %s%nActual schema: %s", writtenWith, schema));
            }
        } else {
            dataset = ParquetJob.createDataset(schema, uri);
        }
        conf.set(CONF_AVRO_SCHEMA, schema.toString());
        DatasetKeyOutputFormat.configure((Configuration)conf).writeTo((View)dataset);
    }

    private static Dataset createDataset(Schema schema, String uri) {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(schema).format(Formats.PARQUET).build();
        return (Dataset)Datasets.create((String)uri, (DatasetDescriptor)descriptor, GenericRecord.class);
    }
}

