/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.io.Serializable;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class FormulaParameter
implements Serializable {
    private String name;
    private String formula;

    public FormulaParameter(String name, String formula) {
        ArgumentNullException.validate((String)"name", (Object)name);
        ArgumentNullException.validate((String)"formula", (Object)formula);
        this.name = name;
        this.formula = formula;
    }

    public String getName() {
        return this.name;
    }

    public String getFormula() {
        return this.formula;
    }

    public static FormulaParameter[] convert(ParameterMapping[] definedVariableNames) {
        FormulaParameter[] args = new FormulaParameter[definedVariableNames.length];
        for (int i = 0; i < definedVariableNames.length; ++i) {
            ParameterMapping definedArgumentName = definedVariableNames[i];
            String formula = '=' + FormulaUtil.quoteReference((String)definedArgumentName.getName());
            args[i] = new FormulaParameter(definedArgumentName.getAlias(), formula);
        }
        return args;
    }

    public static FormulaParameter create(String reportFieldName, String transformationParameterName) {
        String formula = '=' + FormulaUtil.quoteReference((String)reportFieldName);
        return new FormulaParameter(transformationParameterName, formula);
    }

    public static ParameterMapping[] convert(FormulaParameter[] args) {
        ArrayList<ParameterMapping> textList = new ArrayList<ParameterMapping>();
        for (int i = 0; i < args.length; ++i) {
            FormulaParameter arg = args[i];
            try {
                String[] references = FormulaUtil.getReferences((String)arg.getFormula());
                if (references.length <= 0) continue;
                textList.add(new ParameterMapping(references[0], arg.getName()));
                continue;
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return textList.toArray(new ParameterMapping[textList.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormulaParameter that = (FormulaParameter)o;
        if (!this.formula.equals(that.formula)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.formula.hashCode();
        return result;
    }

    public String[] getReferencedFields() throws ParseException {
        return FormulaUtil.getReferences((String)this.getFormula());
    }

    public Object compute(FormulaContext formulaContext) throws EvaluationException, ParseException {
        Formula f = new Formula(FormulaUtil.extractFormula((String)this.formula));
        f.initialize(formulaContext);
        return f.evaluate();
    }
}

