/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerOptionsProcessor {
    protected static final Log LOG = LogFactory.getLog((String)ServerOptionsProcessor.class.getName());
    private final Options options = new Options();
    private CommandLine commandLine;
    private final String serverName;
    private StringBuilder debugMessage = new StringBuilder();

    public ServerOptionsProcessor(String serverName) {
        this.serverName = serverName;
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property");
        this.options.addOption(OptionBuilder.create());
        this.options.addOption(new Option("H", "help", false, "Print help information"));
    }

    public boolean process(String[] argv) {
        try {
            this.commandLine = new GnuParser().parse(this.options, argv);
            if (this.commandLine.hasOption('H')) {
                this.printUsage();
                return false;
            }
            Properties confProps = this.commandLine.getOptionProperties("hiveconf");
            for (String propKey : confProps.stringPropertyNames()) {
                this.debugMessage.append("Setting " + propKey + "=" + confProps.getProperty(propKey) + ";\n");
                System.setProperty(propKey, confProps.getProperty(propKey));
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            this.printUsage();
            return false;
        }
        return true;
    }

    public StringBuilder getDebugMessage() {
        return this.debugMessage;
    }

    private void printUsage() {
        new HelpFormatter().printHelp(this.serverName, this.options);
    }
}

