/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class BundleJobsGetRunningOrPendingJPAExecutor
implements JPAExecutor<List<BundleJobBean>> {
    private int limit;

    public BundleJobsGetRunningOrPendingJPAExecutor(int limit) {
        this.limit = limit;
    }

    @Override
    public String getName() {
        return "BundleJobsGetRunningOrPendingJPAExecutor";
    }

    @Override
    public List<BundleJobBean> execute(EntityManager em) throws JPAExecutorException {
        ArrayList<BundleJobBean> jobList = new ArrayList<BundleJobBean>();
        try {
            Query q = em.createNamedQuery("GET_BUNDLE_JOBS_RUNNING_OR_PENDING");
            if (this.limit > 0) {
                q.setMaxResults(this.limit);
            }
            List bjBeans = q.getResultList();
            for (BundleJobBean j : bjBeans) {
                jobList.add(j);
            }
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return jobList;
    }
}

