/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.Configuration;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ConfigUtils;
import org.apache.oozie.util.FixedJsonInstanceSerializer;
import org.apache.oozie.util.JaasConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;

public class ZKUtils {
    public static final String ZK_CONNECTION_STRING = "oozie.zookeeper.connection.string";
    public static final String ZK_NAMESPACE = "oozie.zookeeper.namespace";
    public static final String OOZIE_INSTANCE_ID = "oozie.instance.id";
    public static final String ZK_SECURE = "oozie.zookeeper.secure";
    private static final String ZK_OOZIE_SERVICE = "servers";
    private static final String ZK_BASE_SERVICES_PATH = "/services";
    private static Set<Object> users = new HashSet<Object>();
    private CuratorFramework client = null;
    private String zkId;
    private long zkRegTime;
    private ServiceDiscovery<Map> sDiscovery;
    private ServiceCache<Map> sCache;
    private List<ACL> saslACL;
    private XLog log = XLog.getLog(this.getClass());
    private static ZKUtils zk = null;

    private ZKUtils() throws Exception {
        this.zkId = System.getProperty(OOZIE_INSTANCE_ID);
        this.createClient();
        this.advertiseService();
        this.checkAndSetACLs();
    }

    public static synchronized ZKUtils register(Object user) throws Exception {
        if (zk == null) {
            zk = new ZKUtils();
        }
        users.add(user);
        return zk;
    }

    public synchronized void unregister(Object user) {
        users.remove(user);
        if (users.isEmpty() && zk != null) {
            zk.teardown();
            zk = null;
        }
    }

    private void createClient() throws Exception {
        Object aclProvider;
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        String zkConnectionString = Services.get().getConf().get(ZK_CONNECTION_STRING, "localhost:2181");
        String zkNamespace = Services.get().getConf().get(ZK_NAMESPACE, "oozie");
        if (Services.get().getConf().getBoolean(ZK_SECURE, false)) {
            this.log.info("Connecting to ZooKeeper with SASL/Kerberos and using 'sasl' ACLs");
            this.setJaasConfiguration();
            System.setProperty("zookeeper.sasl.clientconfig", "Client");
            System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
            this.saslACL = Collections.singletonList(new ACL(31, new Id("sasl", this.getServicePrincipal())));
            aclProvider = new SASLOwnerACLProvider();
        } else {
            this.log.info("Connecting to ZooKeeper without authentication");
            aclProvider = new DefaultACLProvider();
        }
        this.client = CuratorFrameworkFactory.builder().namespace(zkNamespace).connectString(zkConnectionString).retryPolicy((RetryPolicy)retryPolicy).aclProvider((ACLProvider)aclProvider).build();
        this.client.start();
    }

    private void advertiseService() throws Exception {
        new EnsurePath(ZK_BASE_SERVICES_PATH).ensure(this.client.getZookeeperClient());
        FixedJsonInstanceSerializer<Map> instanceSerializer = new FixedJsonInstanceSerializer<Map>(Map.class);
        this.sDiscovery = ServiceDiscoveryBuilder.builder(Map.class).basePath(ZK_BASE_SERVICES_PATH).client(this.client).serializer(instanceSerializer).build();
        this.sDiscovery.start();
        this.sDiscovery.registerService(this.getMetadataInstance());
        this.sCache = this.sDiscovery.serviceCacheBuilder().name(ZK_OOZIE_SERVICE).build();
        this.sCache.start();
        this.zkRegTime = this.sDiscovery.queryForInstance(ZK_OOZIE_SERVICE, this.zkId).getRegistrationTimeUTC();
    }

    private void unadvertiseService() throws Exception {
        this.sCache.close();
        this.sDiscovery.unregisterService(this.getMetadataInstance());
        this.sDiscovery.close();
    }

    private void teardown() {
        try {
            zk.unadvertiseService();
        }
        catch (Exception ex) {
            this.log.warn((Object)("Exception occurred while unadvertising: " + ex.getMessage()), ex);
        }
        this.client.close();
        this.client = null;
    }

    private ServiceInstance<Map> getMetadataInstance() throws Exception {
        String url = ConfigUtils.getOozieEffectiveUrl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("OOZIE_ID", this.zkId);
        map.put("OOZIE_URL", url);
        return ServiceInstance.builder().name(ZK_OOZIE_SERVICE).id(this.zkId).payload(map).build();
    }

    public List<ServiceInstance<Map>> getAllMetaData() {
        List instances = null;
        if (this.sCache != null) {
            instances = this.sCache.getInstances();
        }
        return instances;
    }

    public String getZKId() {
        return this.zkId;
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public int getZKIdIndex(List<ServiceInstance<Map>> oozies) {
        int index = 0;
        for (ServiceInstance<Map> oozie : oozies) {
            long otherRegTime = oozie.getRegistrationTimeUTC();
            if (otherRegTime >= this.zkRegTime) continue;
            ++index;
        }
        return index;
    }

    private void checkAndSetACLs() throws Exception {
        if (Services.get().getConf().getBoolean(ZK_SECURE, false)) {
            List acls;
            String namespace = "/" + this.client.getNamespace();
            if (this.client.getZookeeperClient().getZooKeeper().exists(namespace, null) != null && !((ACL)(acls = this.client.getZookeeperClient().getZooKeeper().getACL(namespace, new Stat())).get(0)).getId().getScheme().equals("sasl")) {
                this.log.info("'sasl' ACLs not set; setting...");
                List children = this.client.getZookeeperClient().getZooKeeper().getChildren(namespace, null);
                for (String child : children) {
                    this.checkAndSetACLs(child);
                }
                this.client.getZookeeperClient().getZooKeeper().setACL(namespace, this.saslACL, -1);
            }
        }
    }

    private void checkAndSetACLs(String path) throws Exception {
        List children = (List)this.client.getChildren().forPath(path);
        for (String child : children) {
            this.checkAndSetACLs(path + "/" + child);
        }
        ((BackgroundPathable)this.client.setACL().withACL(this.saslACL)).forPath(path);
    }

    private void setJaasConfiguration() throws ServiceException, IOException {
        String keytabFile = Services.get().getConf().get("oozie.service.HadoopAccessorService.keytab.file", System.getProperty("user.home") + "/oozie.keytab").trim();
        if (keytabFile.length() == 0) {
            throw new ServiceException(ErrorCode.E0026, "oozie.service.HadoopAccessorService.keytab.file");
        }
        String principal = Services.get().getConf().get("oozie.service.HadoopAccessorService.kerberos.principal", "oozie/localhost@LOCALHOST");
        if (principal.length() == 0) {
            throw new ServiceException(ErrorCode.E0026, "oozie.service.HadoopAccessorService.kerberos.principal");
        }
        JaasConfiguration.addEntry("Client", principal, keytabFile);
        Configuration.setConfiguration(JaasConfiguration.getInstance());
    }

    private String getServicePrincipal() throws ServiceException {
        String principal = Services.get().getConf().get("oozie.service.HadoopAccessorService.kerberos.principal", "oozie/localhost@LOCALHOST");
        if (principal.length() == 0) {
            throw new ServiceException(ErrorCode.E0026, "oozie.service.HadoopAccessorService.kerberos.principal");
        }
        return principal.split("[/@]")[0];
    }

    @VisibleForTesting
    public static Set<Object> getUsers() {
        return users;
    }

    public class SASLOwnerACLProvider
    implements ACLProvider {
        public List<ACL> getDefaultAcl() {
            return ZKUtils.this.saslACL;
        }

        public List<ACL> getAclForPath(String path) {
            return ZKUtils.this.saslACL;
        }
    }

    public abstract class ZKMetadataKeys {
        public static final String OOZIE_ID = "OOZIE_ID";
        public static final String OOZIE_URL = "OOZIE_URL";
    }
}

