/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.PrintfFormat;
import com.wcohen.ss.api.StringWrapper;

public abstract class MemoMatrix {
    private double[][] value;
    private boolean[][] computed;
    protected StringWrapper s;
    protected StringWrapper t;
    protected String cellFormat = "%3g";
    private boolean printNegativeValues = false;

    MemoMatrix(StringWrapper s, StringWrapper t) {
        this.s = s;
        this.t = t;
        this.value = new double[s.length() + 1][t.length() + 1];
        this.computed = new boolean[s.length() + 1][t.length() + 1];
    }

    abstract double compute(int var1, int var2);

    final double get(int i, int j) {
        if (!this.computed[i][j]) {
            this.value[i][j] = this.compute(i, j);
            this.computed[i][j] = true;
        }
        return this.value[i][j];
    }

    protected final char sAt(int i) {
        return this.s.charAt(i - 1);
    }

    protected final char tAt(int i) {
        return this.t.charAt(i - 1);
    }

    final void setPrintNegativeValues(boolean flag) {
        this.printNegativeValues = flag;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("   ");
        for (i = 1; i <= this.s.length(); ++i) {
            buf.append(" " + this.sAt(i) + " ");
        }
        buf.append("\n");
        buf.append("   ");
        for (i = 1; i <= this.s.length(); ++i) {
            buf.append("---");
        }
        buf.append("\n");
        PrintfFormat fmt = new PrintfFormat(this.cellFormat);
        for (int j = 1; j <= this.t.length(); ++j) {
            buf.append(" " + this.tAt(j) + "|");
            for (int i2 = 1; i2 <= this.s.length(); ++i2) {
                double v = this.printNegativeValues ? -this.get(i2, j) : this.get(i2, j);
                buf.append(fmt.sprintf(v));
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    protected static final double max3(double x, double y, double z) {
        return Math.max(x, Math.max(y, z));
    }

    protected static final double max4(double w, double x, double y, double z) {
        return Math.max(Math.max(w, x), Math.max(y, z));
    }
}

