/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemInformation {
    private static final Log logger = LogFactory.getLog(SystemInformation.class);

    public void logSystemInformation() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.getSystemInformation());
        }
    }

    private String getSystemInformation() {
        StringBuilder sb = new StringBuilder(10000);
        sb.append("Current System Configuration\n");
        sb.append("----------------------------\n");
        this.printMapAsTable(sb, new TreeMap<Object, Object>(System.getProperties()));
        sb.append("\n");
        sb.append("\n");
        sb.append("Current System Environment Variables\n");
        sb.append("------------------------------------\n");
        this.printMapAsTable(sb, new TreeMap<String, String>(System.getenv()));
        sb.append("\n");
        sb.append("\n");
        sb.append("Other Properties\n");
        sb.append("----------------\n");
        this.printMapAsTable(sb, SystemInformation.getOtherProperties());
        sb.append("\n");
        sb.append("\n");
        return sb.toString();
    }

    private void printMapAsTable(StringBuilder sb, Map environmentMap) {
        for (Object key : environmentMap.keySet()) {
            String value = (String)environmentMap.get(key);
            value = this.formatLongPathList(value);
            sb.append(String.format("%1$-40s%2$-40s\n", key, value));
        }
    }

    private String formatLongPathList(String value) {
        if (value != null) {
            value = value.replace("\n", "\\n");
            value = value.replace("\f", "\\f");
            if ((value = value.replace("\r", "\\r")).length() > 80) {
                value = value.replace(File.pathSeparator, File.pathSeparator + "\n                                        ");
            }
        }
        return value;
    }

    public static Map<String, String> getOtherProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("File.CurrentDirAbs", new File(".").getAbsolutePath());
        try {
            map.put("File.CurrentDirCanonical", new File(".").getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        map.put("UIManager.LookAndFeel", UIManager.getLookAndFeel().getClass().getName());
        map.put("Toolkit", Toolkit.getDefaultToolkit().getClass().getName());
        if (!GraphicsEnvironment.isHeadless()) {
            map.put("Toolkit.MenuShortcutKeyMask", String.valueOf(Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            map.put("Toolkit.ScreenResolution", String.valueOf(Toolkit.getDefaultToolkit().getScreenResolution()));
            map.put("Toolkit.ScreenSize", String.valueOf(Toolkit.getDefaultToolkit().getScreenSize()));
        }
        map.put("Runtime.availableProcessors", String.valueOf(Runtime.getRuntime().availableProcessors()));
        map.put("Runtime.maximumMemory", String.valueOf(Runtime.getRuntime().maxMemory()));
        SystemInformation.addDesktopProperty(map, "awt.mouse.numButtons");
        SystemInformation.addDesktopProperty(map, "awt.multiClickInterval");
        SystemInformation.addDesktopProperty(map, "DnD.Autoscroll.cursorHysteresis");
        SystemInformation.addDesktopProperty(map, "DnD.Autoscroll.initialDelay");
        SystemInformation.addDesktopProperty(map, "DnD.Autoscroll.interval");
        SystemInformation.addDesktopProperty(map, "DnD.Cursor.CopyDrop");
        SystemInformation.addDesktopProperty(map, "DnD.Cursor.CopyNoDrop");
        SystemInformation.addDesktopProperty(map, "DnD.Cursor.LinkDrop");
        SystemInformation.addDesktopProperty(map, "DnD.Cursor.LinkNoDrop");
        SystemInformation.addDesktopProperty(map, "DnD.Cursor.MoveDrop");
        SystemInformation.addDesktopProperty(map, "DnD.Cursor.MoveNoDrop");
        SystemInformation.addDesktopProperty(map, "DnD.gestureMotionThreshold");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/CanChangeAccels");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/CursorThemeName");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/CursorThemeSize");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/FileChooserBackend");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/FontName");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/IMPreeditStyle");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/IMStatusStyle");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/KeyThemeName");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/MenuBarAccel");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/MenuImages");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/ShowInputMethodMenu");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/ShowUnicodeMenu");
        SystemInformation.addDesktopProperty(map, "gnome.Gtk/ToolbarStyle");
        SystemInformation.addDesktopProperty(map, "gnome.Net/CursorBlink");
        SystemInformation.addDesktopProperty(map, "gnome.Net/CursorBlinkTime");
        SystemInformation.addDesktopProperty(map, "gnome.Net/DndDragThreshold");
        SystemInformation.addDesktopProperty(map, "gnome.Net/DoubleClickTime");
        SystemInformation.addDesktopProperty(map, "gnome.Net/FallbackIconTheme");
        SystemInformation.addDesktopProperty(map, "gnome.Net/IconThemeName");
        SystemInformation.addDesktopProperty(map, "gnome.Net/ThemeName");
        SystemInformation.addDesktopProperty(map, "gnome.Xft/Antialias");
        SystemInformation.addDesktopProperty(map, "gnome.Xft/DPI");
        SystemInformation.addDesktopProperty(map, "gnome.Xft/Hinting");
        SystemInformation.addDesktopProperty(map, "gnome.Xft/HintStyle");
        SystemInformation.addDesktopProperty(map, "gnome.Xft/RGBA");
        SystemInformation.addDesktopProperty(map, "Shell.shellFolderManager");
        SystemInformation.addDesktopProperty(map, "win.3d.backgroundColor");
        SystemInformation.addDesktopProperty(map, "win.3d.darkShadowColor");
        SystemInformation.addDesktopProperty(map, "win.3d.highlightColor");
        SystemInformation.addDesktopProperty(map, "win.3d.lightColor");
        SystemInformation.addDesktopProperty(map, "win.3d.shadowColor");
        SystemInformation.addDesktopProperty(map, "win.ansiFixed.font");
        SystemInformation.addDesktopProperty(map, "win.button.textColor");
        SystemInformation.addDesktopProperty(map, "win.defaultGUI.font");
        SystemInformation.addDesktopProperty(map, "win.frame.backgroundColor");
        SystemInformation.addDesktopProperty(map, "win.frame.textColor");
        SystemInformation.addDesktopProperty(map, "win.item.highlightColor");
        SystemInformation.addDesktopProperty(map, "win.item.highlightTextColor");
        SystemInformation.addDesktopProperty(map, "win.menu.backgroundColor");
        SystemInformation.addDesktopProperty(map, "win.menubar.backgroundColor");
        SystemInformation.addDesktopProperty(map, "win.menu.font");
        SystemInformation.addDesktopProperty(map, "win.menu.keyboardCuesOn");
        SystemInformation.addDesktopProperty(map, "win.menu.textColor");
        SystemInformation.addDesktopProperty(map, "win.scrollbar.backgroundColor");
        SystemInformation.addDesktopProperty(map, "win.scrollbar.width");
        SystemInformation.addDesktopProperty(map, "win.text.grayedTextColor");
        SystemInformation.addDesktopProperty(map, "win.xpstyle.colorName");
        SystemInformation.addDesktopProperty(map, "win.xpstyle.dllName");
        SystemInformation.addDesktopProperty(map, "win.xpstyle.sizeName");
        SystemInformation.addDesktopProperty(map, "win.xpstyle.themeActive");
        return map;
    }

    private static void addDesktopProperty(LinkedHashMap<String, String> map, String key) {
        try {
            Object value = Toolkit.getDefaultToolkit().getDesktopProperty(key);
            if (value != null) {
                map.put(key, value.toString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

