/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.TaggableReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.util.JSON;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.mongodb.MongoDbMeta;
import org.pentaho.mongo.NamedReadPreference;
import org.pentaho.mongo.wrapper.MongoClientWrapper;
import org.pentaho.mongo.wrapper.collection.DefaultMongoCollectionWrapper;
import org.pentaho.mongo.wrapper.collection.MongoCollectionWrapper;
import org.pentaho.mongo.wrapper.field.MongoField;

public class NoAuthMongoClientWrapper
implements MongoClientWrapper {
    private static Class<?> PKG = NoAuthMongoClientWrapper.class;
    public static final int MONGO_DEFAULT_PORT = 27017;
    public static final String LOCAL_DB = "local";
    public static final String REPL_SET_COLLECTION = "system.replset";
    public static final String REPL_SET_SETTINGS = "settings";
    public static final String REPL_SET_LAST_ERROR_MODES = "getLastErrorModes";
    public static final String REPL_SET_MEMBERS = "members";
    private final MongoClient mongo;
    private final LogChannelInterface log;

    public NoAuthMongoClientWrapper(MongoDbMeta meta, VariableSpace vars, LogChannelInterface log) throws KettleException {
        this.log = log;
        this.mongo = this.initConnection(meta, vars, log);
    }

    public NoAuthMongoClientWrapper(MongoClient mongo, LogChannelInterface log) {
        this.mongo = mongo;
        this.log = log;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    private MongoClient initConnection(MongoDbMeta meta, VariableSpace vars, LogChannelInterface log) throws KettleException {
        String[] parts;
        String hostsPorts = vars.environmentSubstitute(meta.getHostnames());
        String singlePort = vars.environmentSubstitute(meta.getPort());
        String connTimeout = meta.getConnectTimeout();
        String socketTimeout = meta.getSocketTimeout();
        String readPreference = meta.getReadPreference();
        String writeConcern = meta.getWriteConcern();
        String wTimeout = meta.getWTimeout();
        boolean journaled = meta.getJournal();
        List<String> tagSet = meta.getReadPrefTagSets();
        boolean useAllReplicaSetMembers = meta.getUseAllReplicaSetMembers();
        int singlePortI = -1;
        try {
            singlePortI = Integer.parseInt(singlePort);
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        if (Const.isEmpty((String)hostsPorts)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Error.EmptyHostsString", (String[])new String[0]));
        }
        ArrayList<ServerAddress> repSet = new ArrayList<ServerAddress>();
        for (String part : parts = hostsPorts.trim().split(",")) {
            int port = singlePortI != -1 ? singlePortI : 27017;
            String[] hp = part.split(":");
            if (hp.length > 2) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Error.MalformedHost", (String[])new String[]{part}));
            }
            String host = hp[0];
            if (hp.length == 2) {
                try {
                    port = Integer.parseInt(hp[1].trim());
                }
                catch (NumberFormatException n) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Error.UnableToParsePortNumber", (String[])new String[]{hp[1]}));
                }
            }
            try {
                ServerAddress s = new ServerAddress(host, port);
                repSet.add(s);
            }
            catch (UnknownHostException u) {
                throw new KettleException((Throwable)u);
            }
        }
        MongoClientOptions.Builder mongoOptsBuilder = new MongoClientOptions.Builder();
        this.configureConnectionOptions(mongoOptsBuilder, connTimeout, socketTimeout, readPreference, writeConcern, wTimeout, journaled, tagSet, vars, log);
        MongoClientOptions opts = mongoOptsBuilder.build();
        return this.getClient(meta, vars, log, repSet, useAllReplicaSetMembers, opts);
    }

    protected MongoClient getClient(MongoDbMeta meta, VariableSpace vars, LogChannelInterface log, List<ServerAddress> repSet, boolean useAllReplicaSetMembers, MongoClientOptions opts) throws KettleException {
        try {
            return repSet.size() > 1 || useAllReplicaSetMembers && repSet.size() >= 1 ? new MongoClient(repSet, opts) : (repSet.size() == 1 ? new MongoClient(repSet.get(0), opts) : new MongoClient(new ServerAddress("localhost"), opts));
        }
        catch (UnknownHostException u) {
            throw new KettleException((Throwable)u);
        }
    }

    private void configureConnectionOptions(MongoClientOptions.Builder optsBuilder, String connTimeout, String socketTimeout, String readPreference, String writeConcern, String wTimeout, boolean journaled, List<String> tagSet, VariableSpace vars, LogChannelInterface log) throws KettleException {
        if (!Const.isEmpty((String)connTimeout)) {
            String connS = vars.environmentSubstitute(connTimeout);
            try {
                int cTimeout = Integer.parseInt(connS);
                if (cTimeout > 0) {
                    optsBuilder.connectTimeout(cTimeout);
                }
            }
            catch (NumberFormatException n) {
                throw new KettleException((Throwable)n);
            }
        }
        if (!Const.isEmpty((String)socketTimeout)) {
            String sockS = vars.environmentSubstitute(socketTimeout);
            try {
                int sockTimeout = Integer.parseInt(sockS);
                if (sockTimeout > 0) {
                    optsBuilder.socketTimeout(sockTimeout);
                }
            }
            catch (NumberFormatException n) {
                throw new KettleException((Throwable)n);
            }
        }
        if (log != null) {
            String rpLogSetting = NamedReadPreference.PRIMARY.getName();
            if (!Const.isEmpty((String)readPreference)) {
                rpLogSetting = readPreference;
            }
            log.logBasic(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.UsingReadPreference", (String[])new String[]{rpLogSetting}));
        }
        DBObject firstTagSet = null;
        DBObject[] remainingTagSets = new DBObject[]{};
        if (tagSet != null && tagSet.size() > 0) {
            if (tagSet.size() > 1) {
                remainingTagSets = new DBObject[tagSet.size() - 1];
            }
            firstTagSet = (DBObject)JSON.parse((String)tagSet.get(0).trim());
            for (int i = 1; i < tagSet.size(); ++i) {
                remainingTagSets[i - 1] = (DBObject)JSON.parse((String)tagSet.get(i).trim());
            }
            if (log != null && !Const.isEmpty((String)readPreference) && !readPreference.equalsIgnoreCase(NamedReadPreference.PRIMARY.getName())) {
                StringBuilder builder = new StringBuilder();
                for (String s : tagSet) {
                    builder.append(s).append(" ");
                }
                log.logBasic(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.UsingReadPreferenceTagSets", (String[])new String[]{builder.toString()}));
            }
        } else if (log != null) {
            log.logBasic(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.NoReadPreferenceTagSetsDefined", (String[])new String[0]));
        }
        if (!Const.isEmpty((String)readPreference)) {
            String rp = vars.environmentSubstitute(readPreference);
            NamedReadPreference preference = NamedReadPreference.byName(rp);
            if (firstTagSet != null && preference.getPreference() instanceof TaggableReadPreference) {
                optsBuilder.readPreference(preference.getTaggableReadPreference(firstTagSet, remainingTagSets));
            } else {
                optsBuilder.readPreference(preference.getPreference());
            }
        }
        writeConcern = vars.environmentSubstitute(writeConcern);
        wTimeout = vars.environmentSubstitute(wTimeout);
        WriteConcern concern = null;
        if (Const.isEmpty((String)writeConcern) && Const.isEmpty((String)wTimeout) && !journaled) {
            concern = new WriteConcern();
            concern.setWObject((Object)new Integer(1));
            if (log != null) {
                log.logBasic(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.ConfiguringWithDefaultWriteConcern", (String[])new String[0]));
            }
        } else {
            int wt = 0;
            if (!Const.isEmpty((String)wTimeout)) {
                try {
                    wt = Integer.parseInt(wTimeout);
                }
                catch (NumberFormatException n) {
                    throw new KettleException((Throwable)n);
                }
            }
            if (!Const.isEmpty((String)writeConcern)) {
                try {
                    int wc = Integer.parseInt(writeConcern);
                    concern = new WriteConcern(wc, wt, false, journaled);
                }
                catch (NumberFormatException n) {
                    concern = new WriteConcern(writeConcern, wt, false, journaled);
                }
            } else {
                concern = new WriteConcern(1, wt, false, journaled);
            }
            if (log != null) {
                String lwc = "w = " + concern.getW() + ", wTimeout = " + concern.getWtimeout() + ", journaled = " + concern.getJ();
                log.logBasic(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.ConfiguringWithWriteConcern", (String[])new String[]{lwc}));
            }
        }
        optsBuilder.writeConcern(concern);
    }

    @Override
    public List<String> getDatabaseNames() throws KettleException {
        try {
            return this.getMongo().getDatabaseNames();
        }
        catch (Exception e) {
            if (e instanceof KettleException) {
                throw (KettleException)((Object)e);
            }
            throw new KettleException((Throwable)e);
        }
    }

    protected DB getDb(String dbName) throws KettleException {
        try {
            return this.getMongo().getDB(dbName);
        }
        catch (Exception e) {
            if (e instanceof KettleException) {
                throw (KettleException)((Object)e);
            }
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public Set<String> getCollectionsNames(String dB) throws KettleException {
        try {
            return this.getDb(dB).getCollectionNames();
        }
        catch (Exception e) {
            if (e instanceof KettleException) {
                throw (KettleException)((Object)e);
            }
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public List<String> getLastErrorModes() throws KettleException {
        ArrayList<String> customLastErrorModes = new ArrayList<String>();
        DB local = this.getDb(LOCAL_DB);
        if (local != null) {
            try {
                DBCollection replset = local.getCollection(REPL_SET_COLLECTION);
                if (replset != null) {
                    DBObject config = replset.findOne();
                    this.extractLastErrorModes(config, customLastErrorModes);
                }
            }
            catch (Exception e) {
                if (e instanceof KettleException) {
                    throw (KettleException)((Object)e);
                }
                throw new KettleException((Throwable)e);
            }
        }
        return customLastErrorModes;
    }

    protected void extractLastErrorModes(DBObject config, List<String> customLastErrorModes) {
        Object getLastErrModes;
        Object settings;
        if (config != null && (settings = config.get(REPL_SET_SETTINGS)) != null && (getLastErrModes = ((DBObject)settings).get(REPL_SET_LAST_ERROR_MODES)) != null) {
            for (String m : ((DBObject)getLastErrModes).keySet()) {
                customLastErrorModes.add(m);
            }
        }
    }

    @Override
    public List<String> getIndexInfo(String dbName, String collection) throws KettleException {
        try {
            DBCollection coll;
            DB db = this.getDb(dbName);
            if (db == null) {
                throw new Exception(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.NonExistentDB", (String[])new String[]{dbName}));
            }
            if (Const.isEmpty((String)collection)) {
                throw new Exception(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
            }
            if (!db.collectionExists(collection)) {
                db.createCollection(collection, null);
            }
            if ((coll = db.getCollection(collection)) == null) {
                throw new Exception(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToGetInfoForCollection", (String[])new String[]{collection}));
            }
            List collInfo = coll.getIndexInfo();
            ArrayList<String> result = new ArrayList<String>();
            if (collInfo == null || collInfo.size() == 0) {
                throw new Exception(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToGetInfoForCollection", (String[])new String[]{collection}));
            }
            for (DBObject index : collInfo) {
                result.add(index.toString());
            }
            return result;
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.GeneralError.Message", (String[])new String[0]) + ":\n\n" + e.getMessage(), (Throwable)e);
            if (e instanceof KettleException) {
                throw (KettleException)((Object)e);
            }
            throw new KettleException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<MongoField> discoverFields(String db, String collection, String query, String fields, boolean isPipeline, int docsToSample) throws KettleException {
        DBCursor cursor = null;
        try {
            int numDocsToSample = docsToSample;
            if (numDocsToSample < 1) {
                numDocsToSample = 100;
            }
            ArrayList<MongoField> discoveredFields = new ArrayList<MongoField>();
            HashMap<String, MongoField> fieldLookup = new HashMap<String, MongoField>();
            try {
                DB database = this.getDb(db);
                if (Const.isEmpty((String)collection)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
                }
                DBCollection dbcollection = database.getCollection(collection);
                Iterator<DBObject> pipeSample = null;
                if (isPipeline) {
                    pipeSample = NoAuthMongoClientWrapper.setUpPipelineSample(query, numDocsToSample, dbcollection);
                } else if (Const.isEmpty((String)query) && Const.isEmpty((String)fields)) {
                    cursor = dbcollection.find().limit(numDocsToSample);
                } else {
                    DBObject dbObject = (DBObject)JSON.parse((String)(Const.isEmpty((String)query) ? "{}" : query));
                    DBObject dbObject2 = (DBObject)JSON.parse((String)fields);
                    cursor = dbcollection.find(dbObject, dbObject2).limit(numDocsToSample);
                }
                int actualCount = 0;
                while (cursor != null ? cursor.hasNext() : pipeSample.hasNext()) {
                    ++actualCount;
                    DBObject nextDoc = cursor != null ? cursor.next() : pipeSample.next();
                    NoAuthMongoClientWrapper.docToFields(nextDoc, fieldLookup);
                }
                NoAuthMongoClientWrapper.postProcessPaths(fieldLookup, discoveredFields, actualCount);
                ArrayList<MongoField> arrayList = discoveredFields;
                return arrayList;
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof KettleException)) throw new KettleException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToDiscoverFields", (String[])new String[0]), (Throwable)ex);
            throw (KettleException)((Object)ex);
        }
    }

    private static Iterator<DBObject> setUpPipelineSample(String query, int numDocsToSample, DBCollection collection) throws KettleException {
        query = query + ", {$limit : " + numDocsToSample + "}";
        List<DBObject> samplePipe = NoAuthMongoClientWrapper.jsonPipelineToDBObjectList(query);
        DBObject first = samplePipe.get(0);
        DBObject[] remainder = new DBObject[samplePipe.size() - 1];
        for (int i = 1; i < samplePipe.size(); ++i) {
            remainder[i - 1] = samplePipe.get(i);
        }
        AggregationOutput result = collection.aggregate(first, remainder);
        return result.results().iterator();
    }

    public static List<DBObject> jsonPipelineToDBObjectList(String jsonPipeline) throws KettleException {
        ArrayList<DBObject> pipeline = new ArrayList<DBObject>();
        StringBuilder b = new StringBuilder(jsonPipeline.trim());
        int bracketCount = -1;
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 0; i < b.length(); ++i) {
            if (b.charAt(i) == '{') {
                if (bracketCount == -1) {
                    b.delete(0, i);
                    bracketCount = 0;
                    i = 0;
                }
                ++bracketCount;
            }
            if (b.charAt(i) == '}') {
                --bracketCount;
            }
            if (bracketCount != 0) continue;
            String part = b.substring(0, i + 1);
            parts.add(part);
            bracketCount = -1;
            if (i == b.length() - 1) break;
            b.delete(0, i + 1);
            i = 0;
        }
        for (String p : parts) {
            if (Const.isEmpty((String)p)) continue;
            DBObject o = (DBObject)JSON.parse((String)p);
            pipeline.add(o);
        }
        if (pipeline.size() == 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToParsePipelineOperators", (String[])new String[0]));
        }
        return pipeline;
    }

    protected static void docToFields(DBObject doc, Map<String, MongoField> lookup) {
        String root = "$";
        String name = "$";
        if (doc instanceof BasicDBObject) {
            NoAuthMongoClientWrapper.processRecord((BasicDBObject)doc, root, name, lookup);
        } else if (doc instanceof BasicDBList) {
            NoAuthMongoClientWrapper.processList((BasicDBList)doc, root, name, lookup);
        }
    }

    private static void processRecord(BasicDBObject rec, String path, String name, Map<String, MongoField> lookup) {
        for (String key : rec.keySet()) {
            Object fieldValue = rec.get(key);
            if (fieldValue instanceof BasicDBObject) {
                NoAuthMongoClientWrapper.processRecord((BasicDBObject)fieldValue, path + "." + key, name + "." + key, lookup);
                continue;
            }
            if (fieldValue instanceof BasicDBList) {
                NoAuthMongoClientWrapper.processList((BasicDBList)fieldValue, path + "." + key, name + "." + key, lookup);
                continue;
            }
            String finalPath = path + "." + key;
            String finalName = name + "." + key;
            if (!lookup.containsKey(finalPath)) {
                MongoField newField = new MongoField();
                int kettleType = NoAuthMongoClientWrapper.mongoToKettleType(fieldValue);
                newField.m_mongoType = String.class;
                if (fieldValue != null) {
                    newField.m_mongoType = fieldValue.getClass();
                }
                newField.m_fieldName = finalName;
                newField.m_fieldPath = finalPath;
                newField.m_kettleType = ValueMeta.getTypeDesc((int)kettleType);
                newField.m_percentageOfSample = 1;
                lookup.put(finalPath, newField);
                continue;
            }
            MongoField m = lookup.get(finalPath);
            Class fieldClass = String.class;
            if (fieldValue != null) {
                fieldClass = fieldValue.getClass();
            }
            if (!m.m_mongoType.isAssignableFrom(fieldClass)) {
                m.m_disparateTypes = true;
            }
            ++m.m_percentageOfSample;
            NoAuthMongoClientWrapper.updateMaxArrayIndexes(m, finalName);
        }
    }

    protected static int mongoToKettleType(Object fieldValue) {
        if (fieldValue == null) {
            return 2;
        }
        if (fieldValue instanceof Symbol || fieldValue instanceof String || fieldValue instanceof Code || fieldValue instanceof ObjectId || fieldValue instanceof MinKey || fieldValue instanceof MaxKey) {
            return 2;
        }
        if (fieldValue instanceof Date) {
            return 3;
        }
        if (fieldValue instanceof Number) {
            try {
                Integer.parseInt(fieldValue.toString());
                return 5;
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        if (fieldValue instanceof Binary) {
            return 8;
        }
        if (fieldValue instanceof BSONTimestamp) {
            return 5;
        }
        return 2;
    }

    private static void processList(BasicDBList list, String path, String name, Map<String, MongoField> lookup) {
        if (list.size() == 0) {
            return;
        }
        String nonPrimitivePath = path + "[-]";
        String primitivePath = path;
        for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            if (element instanceof BasicDBObject) {
                NoAuthMongoClientWrapper.processRecord((BasicDBObject)element, nonPrimitivePath, name + "[" + i + ":" + i + "]", lookup);
                continue;
            }
            if (element instanceof BasicDBList) {
                NoAuthMongoClientWrapper.processList((BasicDBList)element, nonPrimitivePath, name + "[" + i + ":" + i + "]", lookup);
                continue;
            }
            String finalPath = primitivePath + "[" + i + "]";
            String finalName = name + "[" + i + "]";
            if (!lookup.containsKey(finalPath)) {
                MongoField newField = new MongoField();
                int kettleType = NoAuthMongoClientWrapper.mongoToKettleType(element);
                newField.m_mongoType = String.class;
                if (element != null) {
                    newField.m_mongoType = element.getClass();
                }
                newField.m_fieldName = finalPath;
                newField.m_fieldPath = finalName;
                newField.m_kettleType = ValueMeta.getTypeDesc((int)kettleType);
                newField.m_percentageOfSample = 1;
                lookup.put(finalPath, newField);
                continue;
            }
            MongoField m = lookup.get(finalPath);
            Class elementClass = String.class;
            if (element != null) {
                elementClass = element.getClass();
            }
            if (!m.m_mongoType.isAssignableFrom(elementClass)) {
                m.m_disparateTypes = true;
            }
            ++m.m_percentageOfSample;
            NoAuthMongoClientWrapper.updateMaxArrayIndexes(m, finalName);
        }
    }

    protected static void postProcessPaths(Map<String, MongoField> fieldLookup, List<MongoField> discoveredFields, int numDocsProcessed) {
        for (String key : fieldLookup.keySet()) {
            MongoField m = fieldLookup.get(key);
            m.m_occurenceFraction = "" + m.m_percentageOfSample + "/" + numDocsProcessed;
            NoAuthMongoClientWrapper.setMinArrayIndexes(m);
            if (m.m_fieldName.contains("[") && m.m_fieldName.contains(":")) {
                m.m_arrayIndexInfo = m.m_fieldName;
            }
            if (m.m_fieldName.indexOf(46) >= 0) {
                m.m_fieldName = m.m_fieldName.substring(m.m_fieldName.lastIndexOf(46) + 1, m.m_fieldName.length());
            }
            if (m.m_disparateTypes) {
                m.m_kettleType = ValueMeta.getTypeDesc((int)2);
            }
            discoveredFields.add(m);
        }
        HashMap<String, Integer> tempM = new HashMap<String, Integer>();
        for (MongoField m : discoveredFields) {
            if (tempM.get(m.m_fieldName) != null) {
                Integer toUse = (Integer)tempM.get(m.m_fieldName);
                String key = m.m_fieldName;
                m.m_fieldName = key + "_" + toUse;
                toUse = new Integer(toUse + 1);
                tempM.put(key, toUse);
                continue;
            }
            tempM.put(m.m_fieldName, 1);
        }
    }

    protected static void setMinArrayIndexes(MongoField m) {
        if (m.m_fieldName.indexOf(91) < 0) {
            return;
        }
        String temp = m.m_fieldPath;
        String tempComp = m.m_fieldName;
        StringBuffer updated = new StringBuffer();
        while (temp.indexOf(91) >= 0) {
            String firstPart = temp.substring(0, temp.indexOf(91));
            String innerPart = temp.substring(temp.indexOf(91) + 1, temp.indexOf(93));
            if (!innerPart.equals("-")) {
                updated.append(temp);
                temp = "";
                break;
            }
            updated.append(firstPart);
            String innerComp = tempComp.substring(tempComp.indexOf(91) + 1, tempComp.indexOf(93));
            if (temp.indexOf(93) < temp.length() - 1) {
                temp = temp.substring(temp.indexOf(93) + 1, temp.length());
                tempComp = tempComp.substring(tempComp.indexOf(93) + 1, tempComp.length());
            } else {
                temp = "";
            }
            String[] compParts = innerComp.split(":");
            String replace = "[" + compParts[0] + "]";
            updated.append(replace);
        }
        if (temp.length() > 0) {
            updated.append(temp);
        }
        m.m_fieldPath = updated.toString();
    }

    protected static void updateMaxArrayIndexes(MongoField m, String update) {
        if (m.m_fieldName.indexOf(91) < 0) {
            return;
        }
        if (m.m_fieldName.split("\\[").length != update.split("\\[").length) {
            throw new IllegalArgumentException("Field path and update path do not seem to contain the same number of array parts!");
        }
        String temp = m.m_fieldName;
        String tempComp = update;
        StringBuffer updated = new StringBuffer();
        while (temp.indexOf(91) >= 0) {
            String firstPart = temp.substring(0, temp.indexOf(91));
            String innerPart = temp.substring(temp.indexOf(91) + 1, temp.indexOf(93));
            if (innerPart.indexOf(58) < 0) {
                updated.append(temp);
                temp = "";
                break;
            }
            updated.append(firstPart);
            String innerComp = tempComp.substring(tempComp.indexOf(91) + 1, tempComp.indexOf(93));
            if (temp.indexOf(93) < temp.length() - 1) {
                temp = temp.substring(temp.indexOf(93) + 1, temp.length());
                tempComp = tempComp.substring(tempComp.indexOf(93) + 1, tempComp.length());
            } else {
                temp = "";
            }
            String[] origParts = innerPart.split(":");
            String[] compParts = innerComp.split(":");
            int origMax = Integer.parseInt(origParts[1]);
            int compMax = Integer.parseInt(compParts[1]);
            if (compMax > origMax) {
                String newRange = "[" + origParts[0] + ":" + compMax + "]";
                updated.append(newRange);
                continue;
            }
            String oldRange = "[" + innerPart + "]";
            updated.append(oldRange);
        }
        if (temp.length() > 0) {
            updated.append(temp);
        }
        m.m_fieldName = updated.toString();
    }

    @Override
    public List<String> getAllTags() throws KettleException {
        return this.setupAllTags(this.getRepSetMemberRecords());
    }

    private BasicDBList getRepSetMemberRecords() throws KettleException {
        BasicDBList setMembers = null;
        try {
            DB local = this.getDb(LOCAL_DB);
            if (local != null) {
                DBCollection replset = local.getCollection(REPL_SET_COLLECTION);
                if (replset != null) {
                    DBObject config = replset.findOne();
                    if (config != null) {
                        Object members = config.get(REPL_SET_MEMBERS);
                        if (members instanceof BasicDBList) {
                            if (((BasicDBList)members).size() == 0) {
                                if (this.log != null) {
                                    this.log.logBasic(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Warning.NoReplicaSetMembersDefined", (String[])new String[0]));
                                }
                            } else {
                                setMembers = (BasicDBList)members;
                            }
                        } else if (this.log != null) {
                            this.log.logBasic(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Warning.NoReplicaSetMembersDefined", (String[])new String[0]));
                        }
                    } else if (this.log != null) {
                        this.log.logBasic(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Warning.NoReplicaSetMembersDefined", (String[])new String[0]));
                    }
                } else if (this.log != null) {
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Warning.ReplicaSetCollectionUnavailable", (String[])new String[0]));
                }
            } else if (this.log != null) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.Message.Warning.LocalDBNotAvailable", (String[])new String[0]));
            }
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        finally {
            if (this.getMongo() != null) {
                this.getMongo().close();
            }
        }
        return setMembers;
    }

    protected List<String> setupAllTags(BasicDBList members) {
        HashSet<String> tempTags = new HashSet<String>();
        if (members != null && members.size() > 0) {
            for (int i = 0; i < members.size(); ++i) {
                DBObject tags;
                Object m = members.get(i);
                if (m == null || (tags = (DBObject)((DBObject)m).get("tags")) == null) continue;
                for (String tagName : tags.keySet()) {
                    String tagVal = tags.get(tagName).toString();
                    String combined = NoAuthMongoClientWrapper.quote(tagName) + " : " + NoAuthMongoClientWrapper.quote(tagVal);
                    tempTags.add(combined);
                }
            }
        }
        return new ArrayList<String>(tempTags);
    }

    protected static String quote(String string) {
        if (string.indexOf(34) >= 0 && string.indexOf(34) >= 0) {
            string = string.replace("\"", "\\\"");
        }
        string = "\"" + string + "\"";
        return string;
    }

    @Override
    public List<String> getReplicaSetMembersThatSatisfyTagSets(List<DBObject> tagSets) throws KettleException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (DBObject object : this.checkForReplicaSetMembersThatSatisfyTagSets(tagSets, this.getRepSetMemberRecords())) {
                result.add(object.toString());
            }
            return result;
        }
        catch (Exception ex) {
            if (ex instanceof KettleException) {
                throw (KettleException)((Object)ex);
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToGetReplicaSetMembers", (String[])new String[0]), (Throwable)ex);
        }
    }

    protected List<DBObject> checkForReplicaSetMembersThatSatisfyTagSets(List<DBObject> tagSets, BasicDBList members) {
        ArrayList<DBObject> satisfy = new ArrayList<DBObject>();
        if (members != null && members.size() > 0) {
            for (int i = 0; i < members.size(); ++i) {
                DBObject tags;
                Object m = members.get(i);
                if (m == null || (tags = (DBObject)((DBObject)m).get("tags")) == null) continue;
                for (int j = 0; j < tagSets.size(); ++j) {
                    boolean match = true;
                    DBObject toMatch = tagSets.get(j);
                    for (String tagName : toMatch.keySet()) {
                        String tagValue = toMatch.get(tagName).toString();
                        Object matchVal = tags.get(tagName);
                        if (matchVal == null) {
                            match = false;
                            break;
                        }
                        if (matchVal.toString().equals(tagValue)) continue;
                        match = false;
                        break;
                    }
                    if (!match || satisfy.contains(m)) continue;
                    satisfy.add((DBObject)m);
                }
            }
        }
        return satisfy;
    }

    @Override
    public MongoCollectionWrapper getCollection(String db, String name) throws KettleException {
        return this.wrap(this.getDb(db).getCollection(name));
    }

    @Override
    public MongoCollectionWrapper createCollection(String db, String name) throws KettleException {
        return this.wrap(this.getDb(db).createCollection(name, null));
    }

    protected MongoCollectionWrapper wrap(DBCollection collection) {
        return new DefaultMongoCollectionWrapper(collection);
    }

    @Override
    public void dispose() {
        this.getMongo().close();
    }
}

