/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.BlockingService;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class CoprocessorHConnection
implements ClusterConnection {
    private static final NonceGenerator ng = new ConnectionManager.NoNonceGenerator();
    private ClusterConnection delegate;
    private ServerName serverName;
    private HRegionServer server;

    static ClusterConnection getConnectionForEnvironment(CoprocessorEnvironment env) throws IOException {
        RegionCoprocessorEnvironment e;
        RegionServerServices services;
        ClusterConnection connection = ConnectionManager.createConnectionInternal((Configuration)env.getConfiguration());
        if (env instanceof RegionCoprocessorEnvironment && (services = (e = (RegionCoprocessorEnvironment)env).getRegionServerServices()) instanceof HRegionServer) {
            return new CoprocessorHConnection(connection, (HRegionServer)services);
        }
        return connection;
    }

    public CoprocessorHConnection(ClusterConnection delegate, HRegionServer server) {
        this.server = server;
        this.serverName = server.getServerName();
        this.delegate = delegate;
    }

    public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
        if (!this.serverName.equals((Object)serverName)) {
            return this.delegate.getClient(serverName);
        }
        final BlockingService blocking = ClientProtos.ClientService.newReflectiveBlockingService((ClientProtos.ClientService.BlockingInterface)this.server);
        final RpcServerInterface rpc = this.server.getRpcServer();
        final MonitoredRPCHandler status = TaskMonitor.get().createRPCStatus(Thread.currentThread().getName());
        status.pause("Setting up server-local call");
        final long timestamp = EnvironmentEdgeManager.currentTimeMillis();
        BlockingRpcChannel channel = new BlockingRpcChannel(){

            public Message callBlockingMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype) throws ServiceException {
                try {
                    return (Message)rpc.call(blocking, method, request, null, timestamp, status).getFirst();
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
        };
        return ClientProtos.ClientService.newBlockingStub((BlockingRpcChannel)channel);
    }

    public void abort(String why, Throwable e) {
        this.delegate.abort(why, e);
    }

    public boolean isAborted() {
        return this.delegate.isAborted();
    }

    public Configuration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public HTableInterface getTable(String tableName) throws IOException {
        return this.delegate.getTable(tableName);
    }

    public HTableInterface getTable(byte[] tableName) throws IOException {
        return this.delegate.getTable(tableName);
    }

    public HTableInterface getTable(TableName tableName) throws IOException {
        return this.delegate.getTable(tableName);
    }

    public HTableInterface getTable(String tableName, ExecutorService pool) throws IOException {
        return this.delegate.getTable(tableName, pool);
    }

    public HTableInterface getTable(byte[] tableName, ExecutorService pool) throws IOException {
        return this.delegate.getTable(tableName, pool);
    }

    public HTableInterface getTable(TableName tableName, ExecutorService pool) throws IOException {
        return this.delegate.getTable(tableName, pool);
    }

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.delegate.isMasterRunning();
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.delegate.isTableEnabled(tableName);
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.delegate.isTableEnabled(tableName);
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.delegate.isTableDisabled(tableName);
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.delegate.isTableDisabled(tableName);
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.delegate.isTableAvailable(tableName);
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.delegate.isTableAvailable(tableName);
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.delegate.isTableAvailable(tableName, splitKeys);
    }

    public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
        return this.delegate.isTableAvailable(tableName, splitKeys);
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.delegate.listTables();
    }

    public String[] getTableNames() throws IOException {
        return this.delegate.getTableNames();
    }

    public TableName[] listTableNames() throws IOException {
        return this.delegate.listTableNames();
    }

    public HTableDescriptor getHTableDescriptor(TableName tableName) throws IOException {
        return this.delegate.getHTableDescriptor(tableName);
    }

    public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
        return this.delegate.getHTableDescriptor(tableName);
    }

    public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
        return this.delegate.locateRegion(tableName, row);
    }

    public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
        return this.delegate.locateRegion(tableName, row);
    }

    public void clearRegionCache() {
        this.delegate.clearRegionCache();
    }

    public void clearRegionCache(TableName tableName) {
        this.delegate.clearRegionCache(tableName);
    }

    public void clearRegionCache(byte[] tableName) {
        this.delegate.clearRegionCache(tableName);
    }

    public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
        return this.delegate.relocateRegion(tableName, row);
    }

    public HRegionLocation relocateRegion(TableName tableName, byte[] row, int replicaId) throws IOException {
        return this.delegate.relocateRegion(tableName, row, replicaId);
    }

    public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
        return this.delegate.relocateRegion(tableName, row);
    }

    public void updateCachedLocations(TableName tableName, byte[] regionName, byte[] rowkey, Object exception, ServerName source) {
        this.delegate.updateCachedLocations(tableName, regionName, rowkey, exception, source);
    }

    public void updateCachedLocations(TableName tableName, byte[] rowkey, Object exception, HRegionLocation source) {
        this.delegate.updateCachedLocations(tableName, rowkey, exception, source);
    }

    public void updateCachedLocations(byte[] tableName, byte[] rowkey, Object exception, HRegionLocation source) {
        this.delegate.updateCachedLocations(tableName, rowkey, exception, source);
    }

    @Deprecated
    public void updateCachedLocations(TableName tableName, byte[] rowkey, Object exception, ServerName source) {
        this.delegate.updateCachedLocations(tableName, rowkey, exception, source);
    }

    public HRegionLocation locateRegion(byte[] regionName) throws IOException {
        return this.delegate.locateRegion(regionName);
    }

    public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
        return this.delegate.locateRegions(tableName);
    }

    public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
        return this.delegate.locateRegions(tableName);
    }

    public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
        return this.delegate.locateRegions(tableName, useCache, offlined);
    }

    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
        return this.delegate.locateRegion(tableName, row, useCache, retry);
    }

    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
        return this.delegate.locateRegion(tableName, row, useCache, retry, replicaId);
    }

    public List<HRegionLocation> locateRegions(byte[] tableName, boolean useCache, boolean offlined) throws IOException {
        return this.delegate.locateRegions(tableName, useCache, offlined);
    }

    public MasterProtos.MasterService.BlockingInterface getMaster() throws IOException {
        return this.delegate.getMaster();
    }

    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
        return this.delegate.getAdmin(serverName);
    }

    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName, boolean getMaster) throws IOException {
        return this.delegate.getAdmin(serverName, getMaster);
    }

    public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
        return this.delegate.getRegionLocation(tableName, row, reload);
    }

    public HRegionLocation getRegionLocation(byte[] tableName, byte[] row, boolean reload) throws IOException {
        return this.delegate.getRegionLocation(tableName, row, reload);
    }

    public void processBatch(List<? extends Row> actions, TableName tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
        this.delegate.processBatch(actions, tableName, pool, results);
    }

    public void processBatch(List<? extends Row> actions, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
        this.delegate.processBatch(actions, tableName, pool, results);
    }

    public <R> void processBatchCallback(List<? extends Row> list, TableName tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.delegate.processBatchCallback(list, tableName, pool, results, callback);
    }

    public <R> void processBatchCallback(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.delegate.processBatchCallback(list, tableName, pool, results, callback);
    }

    public void setRegionCachePrefetch(TableName tableName, boolean enable) {
        this.delegate.setRegionCachePrefetch(tableName, enable);
    }

    public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
        this.delegate.setRegionCachePrefetch(tableName, enable);
    }

    public boolean getRegionCachePrefetch(TableName tableName) {
        return this.delegate.getRegionCachePrefetch(tableName);
    }

    public boolean getRegionCachePrefetch(byte[] tableName) {
        return this.delegate.getRegionCachePrefetch(tableName);
    }

    public int getCurrentNrHRS() throws IOException {
        return this.delegate.getCurrentNrHRS();
    }

    public HTableDescriptor[] getHTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        return this.delegate.getHTableDescriptorsByTableName(tableNames);
    }

    public HTableDescriptor[] getHTableDescriptors(List<String> tableNames) throws IOException {
        return this.delegate.getHTableDescriptors(tableNames);
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public void clearCaches(ServerName sn) {
        this.delegate.clearCaches(sn);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void deleteCachedRegionLocation(HRegionLocation location) {
        this.delegate.deleteCachedRegionLocation(location);
    }

    public MasterKeepAliveConnection getKeepAliveMasterService() throws MasterNotRunningException {
        return this.delegate.getKeepAliveMasterService();
    }

    public boolean isDeadServer(ServerName serverName) {
        return this.delegate.isDeadServer(serverName);
    }

    public NonceGenerator getNonceGenerator() {
        return ng;
    }

    public AsyncProcess getAsyncProcess() {
        return this.delegate.getAsyncProcess();
    }
}

