/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;

public class ServerRegionReplicaUtil
extends RegionReplicaUtil {
    public static HRegionInfo getRegionInfoForFs(HRegionInfo regionInfo) {
        if (regionInfo == null) {
            return null;
        }
        return RegionReplicaUtil.getRegionInfoForDefaultReplica((HRegionInfo)regionInfo);
    }

    public static boolean isReadOnly(HRegion region) {
        return region.getTableDesc().isReadOnly() || !ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo());
    }

    public static boolean shouldReplayRecoveredEdits(HRegion region) {
        return ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo());
    }

    public static StoreFileInfo getStoreFileInfo(Configuration conf, FileSystem fs, HRegionInfo regionInfo, HRegionInfo regionInfoForFs, String familyName, FileStatus status) throws IOException {
        if (regionInfo.equals((Object)regionInfoForFs)) {
            return new StoreFileInfo(conf, fs, status);
        }
        HFileLink link = new HFileLink(conf, HFileLink.createPath(regionInfoForFs.getTable(), regionInfoForFs.getEncodedName(), familyName, status.getPath().getName()));
        return new StoreFileInfo(conf, fs, status, link);
    }
}

