/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.utils.RestUtils;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ServiceUtils {
    private static final Log log = LogFactory.getLog((Class)ServiceUtils.class);
    protected static final SimpleDateFormat iso8601DateParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    protected static final SimpleDateFormat iso8601DateParser_Walrus = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected static final SimpleDateFormat rfc822DateParser = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseIso8601Date(String dateString) throws ParseException {
        ParseException exception = null;
        SimpleDateFormat simpleDateFormat = iso8601DateParser;
        synchronized (simpleDateFormat) {
            try {
                return iso8601DateParser.parse(dateString);
            }
            catch (ParseException e) {
                exception = e;
            }
        }
        simpleDateFormat = iso8601DateParser_Walrus;
        synchronized (simpleDateFormat) {
            try {
                return iso8601DateParser_Walrus.parse(dateString);
            }
            catch (ParseException parseException) {
            }
        }
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatIso8601Date(Date date) {
        SimpleDateFormat simpleDateFormat = iso8601DateParser;
        synchronized (simpleDateFormat) {
            return iso8601DateParser.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseRfc822Date(String dateString) throws ParseException {
        SimpleDateFormat simpleDateFormat = rfc822DateParser;
        synchronized (simpleDateFormat) {
            return rfc822DateParser.parse(dateString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatRfc822Date(Date date) {
        SimpleDateFormat simpleDateFormat = rfc822DateParser;
        synchronized (simpleDateFormat) {
            return rfc822DateParser.format(date);
        }
    }

    public static String signWithHmacSha1(String awsSecretKey, String canonicalString) throws S3ServiceException {
        if (awsSecretKey == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Canonical string will not be signed, as no AWS Secret Key was provided");
            }
            return null;
        }
        SecretKeySpec signingKey = null;
        try {
            signingKey = new SecretKeySpec(awsSecretKey.getBytes(Constants.DEFAULT_ENCODING), "HmacSHA1");
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to get bytes from secret string", e);
        }
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find sha1 algorithm", e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not initialize the MAC algorithm", e);
        }
        try {
            byte[] b64 = Base64.encodeBase64((byte[])mac.doFinal(canonicalString.getBytes(Constants.DEFAULT_ENCODING)));
            return new String(b64);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to get bytes from canonical string", e);
        }
    }

    public static String readInputStreamToString(InputStream is, String encoding) throws IOException {
        StringBuffer sb;
        block3: {
            sb = new StringBuffer();
            BufferedReader br = null;
            br = encoding != null ? new BufferedReader(new InputStreamReader(is, encoding)) : new BufferedReader(new InputStreamReader(is));
            String line = null;
            try {
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)"Unable to read String from Input Stream", (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static String readInputStreamLineToString(InputStream is, String encoding) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b = -1;
        while ((b = is.read()) != -1 && '\n' != (char)b) {
            baos.write(b);
        }
        return new String(baos.toByteArray(), encoding);
    }

    public static byte[] readInputStreamToBytes(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b = -1;
        while ((b = is.read()) != -1) {
            baos.write(b);
        }
        return baos.toByteArray();
    }

    public static long countBytesInObjects(S3Object[] objects) {
        long byteTotal = 0L;
        for (int i = 0; objects != null && i < objects.length; ++i) {
            byteTotal += objects[i].getContentLength();
        }
        return byteTotal;
    }

    public static Map cleanRestMetadataMap(Map metadata) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cleaning up REST metadata items");
        }
        HashMap cleanMap = new HashMap();
        if (metadata != null) {
            Iterator metadataIter = metadata.entrySet().iterator();
            while (metadataIter.hasNext()) {
                Object value;
                Object key;
                block26: {
                    String keyStr;
                    Map.Entry entry = metadataIter.next();
                    key = entry.getKey();
                    value = entry.getValue();
                    String string = keyStr = key != null ? key.toString() : "";
                    if (keyStr.startsWith("x-amz-meta-")) {
                        key = keyStr.substring("x-amz-meta-".length(), keyStr.length());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Removed Amazon meatadata header prefix from key: " + keyStr + "=>" + key));
                        }
                    } else if (keyStr.startsWith("x-amz-")) {
                        key = keyStr.substring("x-amz-".length(), keyStr.length());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Removed Amazon header prefix from key: " + keyStr + "=>" + key));
                        }
                    } else if (RestUtils.HTTP_HEADER_METADATA_NAMES.contains(keyStr.toLowerCase(Locale.getDefault()))) {
                        key = keyStr;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Leaving HTTP header item unchanged: " + key + "=" + value));
                        }
                    } else if ("ETag".equalsIgnoreCase(keyStr) || "Date".equalsIgnoreCase(keyStr) || "Last-Modified".equalsIgnoreCase(keyStr) || "Content-Range".equalsIgnoreCase(keyStr)) {
                        key = keyStr;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Leaving header item unchanged: " + key + "=" + value));
                        }
                    } else {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Ignoring metadata item: " + keyStr + "=" + value));
                        continue;
                    }
                    if (value instanceof Collection) {
                        if (((Collection)value).size() == 1) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Converted metadata single-item Collection " + value.getClass() + " " + value + " for key: " + key));
                            }
                            value = ((Collection)value).iterator().next();
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Collection " + value + " has too many items to convert to a single string"));
                        }
                    }
                    if (("Date".equals(key) || "Last-Modified".equals(key)) && !(value instanceof Date)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Parsing date string '" + value + "' into Date object for key: " + key));
                        }
                        try {
                            value = ServiceUtils.parseRfc822Date(value.toString());
                        }
                        catch (ParseException pe) {
                            try {
                                value = ServiceUtils.parseIso8601Date(value.toString());
                            }
                            catch (ParseException pe2) {
                                if (!log.isWarnEnabled()) break block26;
                                log.warn((Object)("Date string is not RFC 822 compliant for metadata field " + key), (Throwable)pe);
                            }
                        }
                    }
                }
                cleanMap.put(key, value);
            }
        }
        return cleanMap;
    }

    public static String toHex(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i]);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb.append(hex);
        }
        return sb.toString().toLowerCase(Locale.getDefault());
    }

    public static byte[] fromHex(String hexData) {
        byte[] result = new byte[(hexData.length() + 1) / 2];
        String hexNumber = null;
        int byteOffset = 0;
        for (int stringOffset = 0; stringOffset < hexData.length(); stringOffset += 2) {
            hexNumber = hexData.substring(stringOffset, stringOffset + 2);
            result[byteOffset++] = (byte)Integer.parseInt(hexNumber, 16);
        }
        return result;
    }

    public static String toBase64(byte[] data) {
        byte[] b64 = Base64.encodeBase64((byte[])data);
        return new String(b64);
    }

    public static String join(List items, String delimiter) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.size(); ++i) {
            sb.append(items.get(i));
            if (i >= items.size() - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String join(Object[] items, String delimiter) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            sb.append(items[i]);
            if (i >= items.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String join(int[] ints, String delimiter) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ints.length; ++i) {
            sb.append(ints[i]);
            if (i >= ints.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static byte[] fromBase64(String b64Data) {
        byte[] decoded = Base64.decodeBase64((byte[])b64Data.getBytes());
        return decoded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeMD5Hash(InputStream is) throws NoSuchAlgorithmException, IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {
                System.err.println("Unable to close input stream of hash candidate: " + e);
            }
        }
    }

    public static byte[] computeMD5Hash(byte[] data) throws NoSuchAlgorithmException, IOException {
        return ServiceUtils.computeMD5Hash(new ByteArrayInputStream(data));
    }

    public static String findBucketNameInHostname(String host, String s3Endpoint) {
        String bucketName = null;
        bucketName = host.endsWith(s3Endpoint) ? host.substring(0, host.length() - s3Endpoint.length() - 1) : host;
        return bucketName;
    }

    public static S3Object buildObjectFromUrl(String host, String urlPath, String s3Endpoint) throws UnsupportedEncodingException {
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        String bucketName = null;
        String objectKey = null;
        if (!s3Endpoint.equals(host)) {
            bucketName = ServiceUtils.findBucketNameInHostname(host, s3Endpoint);
        } else {
            int slashIndex = urlPath.indexOf("/");
            bucketName = URLDecoder.decode(urlPath.substring(0, slashIndex), Constants.DEFAULT_ENCODING);
            urlPath = urlPath.substring(bucketName.length() + 1);
        }
        objectKey = URLDecoder.decode(urlPath, Constants.DEFAULT_ENCODING);
        S3Object object = new S3Object(objectKey);
        object.setBucketName(bucketName);
        return object;
    }

    public static boolean isBucketNameValidDNSName(String bucketName) {
        if (bucketName == null || bucketName.length() > 63 || bucketName.length() < 3) {
            return false;
        }
        if (!Pattern.matches("^[a-z0-9][a-z0-9.-]+$", bucketName)) {
            return false;
        }
        if (Pattern.matches("([0-9]{1,3}\\.){3}[0-9]{1,3}", bucketName)) {
            return false;
        }
        String[] fragments = bucketName.split("\\.");
        for (int i = 0; i < fragments.length; ++i) {
            if (!Pattern.matches("^-.*", fragments[i]) && !Pattern.matches(".*-$", fragments[i]) && !Pattern.matches("^$", fragments[i])) continue;
            return false;
        }
        return true;
    }

    public static String generateS3HostnameForBucket(String bucketName, boolean isDnsBucketNamingDisabled, String s3Endpoint) {
        if (ServiceUtils.isBucketNameValidDNSName(bucketName) && !isDnsBucketNamingDisabled) {
            return bucketName + "." + s3Endpoint;
        }
        return s3Endpoint;
    }

    public static String getUserAgentDescription(String applicationDescription) {
        return "JetS3t/0.7.4-dev (" + System.getProperty("os.name") + "/" + System.getProperty("os.version") + ";" + " " + System.getProperty("os.arch") + (System.getProperty("user.region") != null ? "; " + System.getProperty("user.region") : "") + (System.getProperty("user.language") != null ? "; " + System.getProperty("user.language") : "") + (System.getProperty("java.version") != null ? "; JVM " + System.getProperty("java.version") : "") + ")" + (applicationDescription != null ? " " + applicationDescription : "");
    }

    public static XMLReader loadXMLReader() throws S3ServiceException {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            String[] altXmlReaderClasspaths = new String[]{"org.apache.crimson.parser.XMLReaderImpl", "org.xmlpull.v1.sax2.Driver"};
            for (int i = 0; i < altXmlReaderClasspaths.length; ++i) {
                String xmlReaderClasspath = altXmlReaderClasspaths[i];
                try {
                    return XMLReaderFactory.createXMLReader(xmlReaderClasspath);
                }
                catch (SAXException sAXException) {
                    continue;
                }
            }
            throw new S3ServiceException("Failed to initialize a SAX XMLReader");
        }
    }

    static {
        iso8601DateParser.setTimeZone(new SimpleTimeZone(0, "GMT"));
        rfc822DateParser.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }
}

