/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.ui;

import java.awt.Window;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.HypersonicDatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.ui.datasources.jdbc.DatabaseMapping;
import org.pentaho.reporting.ui.datasources.jdbc.connection.DriverConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JndiConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.ui.XulDatabaseHandler;
import org.pentaho.ui.database.Messages;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swing.SwingXulLoader;

public class XulDatabaseDialog {
    private static final Log log = LogFactory.getLog(XulDatabaseDialog.class);
    private static final String DIALOG_DEFINITION_FILE = "org/pentaho/ui/database/databasedialog.xul";
    private static final String OVERLAY_DEFINITION_FILE = "org/pentaho/reporting/ui/datasources/jdbc/ui/databasedialogOverlay.xul";
    private XulDialog dialog;
    private XulDatabaseHandler handler;
    private DatabaseMeta meta;
    private static final String HSQLDB_PREFIX = "jdbc:hsqldb:hsql://";
    private static final String HSQLDB_MEM_PREFIX = "jdbc:hsqldb:mem:";
    private static final String HSQLDB_LOCAL_PREFIX = "jdbc:hsqldb:.";
    private DesignTimeContext designTimeContext;

    public XulDatabaseDialog(Window parent, DesignTimeContext designTimeContext) throws XulException {
        this.designTimeContext = designTimeContext;
        SwingXulLoader loader = new SwingXulLoader();
        if (parent != null) {
            loader.setOuterContext((Object)parent);
        }
        XulDomContainer container = loader.loadXul(DIALOG_DEFINITION_FILE, (Object)Messages.getBundle());
        container.getDocumentRoot().addOverlay(OVERLAY_DEFINITION_FILE);
        container.initialize();
        this.handler = new XulDatabaseHandler();
        container.addEventHandler((XulEventHandler)this.handler);
        Document documentRoot = container.getDocumentRoot();
        XulComponent root = documentRoot.getRootElement();
        if (!(root instanceof XulDialog)) {
            throw new XulException("Error getting Xul Database Dialog root, element of type: " + root);
        }
        this.dialog = (XulDialog)root;
        this.dialog.setResizable(Boolean.TRUE);
    }

    private void setData(JdbcConnectionDefinition def) {
        if (def instanceof DriverConnectionDefinition) {
            DriverConnectionDefinition jdbcDef = (DriverConnectionDefinition)def;
            this.meta = new DatabaseMeta();
            this.meta.setUsername(jdbcDef.getUsername());
            this.meta.setPassword(jdbcDef.getPassword());
            this.meta.setName(jdbcDef.getName());
            if (jdbcDef.getDatabaseType() != null) {
                log.debug((Object)("Database type is known: " + jdbcDef.getDatabaseType()));
                try {
                    this.meta.setDatabaseType(jdbcDef.getDatabaseType());
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
                this.meta.setDBName(jdbcDef.getDatabaseName());
                this.meta.setHostname(jdbcDef.getHostName());
                this.meta.setDBPort(jdbcDef.getPort());
                this.meta.getAttributes().setProperty("CUSTOM_URL", jdbcDef.getConnectionString());
                this.meta.getAttributes().setProperty("CUSTOM_DRIVER_CLASS", jdbcDef.getDriverClass());
            } else if (String.valueOf(jdbcDef.getConnectionString()).startsWith(HSQLDB_MEM_PREFIX)) {
                this.meta.setDatabaseType(DatabaseMapping.getGenericInterface().getPluginId());
                this.meta.getAttributes().put("CUSTOM_URL", jdbcDef.getConnectionString());
                this.meta.getAttributes().put("CUSTOM_DRIVER_CLASS", jdbcDef.getDriverClass());
            } else if (String.valueOf(jdbcDef.getConnectionString()).startsWith(HSQLDB_LOCAL_PREFIX)) {
                this.meta.setDatabaseType(DatabaseMapping.getGenericInterface().getPluginId());
                this.meta.getAttributes().put("CUSTOM_URL", jdbcDef.getConnectionString());
                this.meta.getAttributes().put("CUSTOM_DRIVER_CLASS", jdbcDef.getDriverClass());
            } else {
                DatabaseInterface databaseInterface = DatabaseMapping.getMappingForDriver(jdbcDef.getDriverClass());
                this.meta.setDatabaseType(databaseInterface.getPluginId());
                log.debug((Object)("Database type is unknown, using " + databaseInterface));
                try {
                    String connectionString;
                    String pattern = databaseInterface instanceof HypersonicDatabaseMeta ? ((connectionString = jdbcDef.getConnectionString()).startsWith(HSQLDB_PREFIX) ? (connectionString.indexOf(58, HSQLDB_PREFIX.length()) == -1 ? "jdbc:hsqldb:hsql://{0}/{2}" : "jdbc:hsqldb:hsql://{0}:{1}/{2}") : databaseInterface.getURL("{0}", "{1}", "{2}")) : databaseInterface.getURL("{0}", "{1}", "{2}");
                    if (pattern != null && pattern.length() > 0) {
                        MessageFormat format = new MessageFormat(pattern);
                        Object[] objects = format.parse(jdbcDef.getConnectionString());
                        if (objects[0] != null) {
                            this.meta.setHostname(String.valueOf(objects[0]));
                        }
                        if (objects[1] != null) {
                            this.meta.setDBPort(String.valueOf(objects[1]));
                        }
                        if (objects[2] != null) {
                            this.meta.setDBName(String.valueOf(objects[2]));
                        }
                    }
                }
                catch (Exception e) {
                    this.designTimeContext.error((Exception)((Object)new XulException("Unable to parse database-URL, please report your database driver to Pentaho to include it in our list of databases.", (Throwable)e)));
                    this.meta.setDatabaseType(DatabaseMapping.getGenericInterface().getPluginId());
                    this.meta.getAttributes().put("CUSTOM_URL", jdbcDef.getConnectionString());
                    this.meta.getAttributes().put("CUSTOM_DRIVER_CLASS", jdbcDef.getDriverClass());
                }
            }
            Properties properties = jdbcDef.getProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith("::pentaho-reporting::") || "user".equals(key) || "password".equals(key)) continue;
                this.meta.addExtraOption(this.meta.getPluginId(), key, (String)entry.getValue());
            }
        } else if (def instanceof JndiConnectionDefinition) {
            JndiConnectionDefinition jndiDef = (JndiConnectionDefinition)def;
            this.meta = new DatabaseMeta();
            this.meta.setDBName(jndiDef.getJndiName());
            this.meta.setName(jndiDef.getName());
            try {
                if (jndiDef.getDatabaseType() != null) {
                    this.meta.setDatabaseType(jndiDef.getDatabaseType());
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.meta.setAccessType(4);
        } else {
            this.meta = null;
        }
    }

    public JdbcConnectionDefinition open(JdbcConnectionDefinition definition) {
        this.setData(definition);
        try {
            log.debug((Object)"showing database dialog");
            if (this.meta != null) {
                this.handler.setData(this.meta);
            }
            this.dialog.show();
            log.debug((Object)"dialog closed, getting DabaseMeta");
            if (!this.handler.isConfirmed()) {
                return null;
            }
            DatabaseMeta database = (DatabaseMeta)this.handler.getData();
            if (database == null) {
                log.debug((Object)"DatabaseMeta is null");
                return null;
            }
            return this.convertDbMeta(database);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private JdbcConnectionDefinition convertDbMeta(DatabaseMeta meta) throws KettleDatabaseException {
        if (meta.getAccessType() == 4) {
            return new JndiConnectionDefinition(meta.getName(), meta.getDatabaseName(), meta.getDatabaseInterface().getPluginName(), null, null);
        }
        Map map = meta.getExtraOptions();
        Properties properties = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String realKey = key.substring(meta.getPluginId().length() + 1);
            String value = (String)entry.getValue();
            if ("><EMPTY><".equals(value)) {
                properties.put(realKey, "");
                continue;
            }
            properties.put(realKey, value);
        }
        return new DriverConnectionDefinition(meta.getName(), meta.getDriverClass(), meta.getURL(), meta.getUsername(), meta.getPassword(), meta.getHostname(), meta.getDatabaseName(), meta.getDatabaseInterface().getPluginId(), meta.getDatabasePortNumberString(), properties);
    }
}

