/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.AbstractThreadUnsafeSortedColumns;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.Allocator;

public class ArrayBackedSortedColumns
extends AbstractThreadUnsafeSortedColumns {
    private final boolean reversed;
    private final ArrayList<Column> columns;
    public static final ColumnFamily.Factory<ArrayBackedSortedColumns> factory = new ColumnFamily.Factory<ArrayBackedSortedColumns>(){

        @Override
        public ArrayBackedSortedColumns create(CFMetaData metadata, boolean insertReversed) {
            return new ArrayBackedSortedColumns(metadata, insertReversed);
        }
    };

    private ArrayBackedSortedColumns(CFMetaData metadata, boolean reversed) {
        super(metadata);
        this.reversed = reversed;
        this.columns = new ArrayList();
    }

    private ArrayBackedSortedColumns(Collection<Column> columns, CFMetaData metadata, boolean reversed) {
        super(metadata);
        this.reversed = reversed;
        this.columns = new ArrayList<Column>(columns);
    }

    @Override
    public ColumnFamily.Factory getFactory() {
        return factory;
    }

    @Override
    public ColumnFamily cloneMe() {
        return new ArrayBackedSortedColumns(this.columns, this.metadata, this.reversed);
    }

    @Override
    public boolean isInsertReversed() {
        return this.reversed;
    }

    private Comparator<ByteBuffer> internalComparator() {
        return this.reversed ? this.getComparator().reverseComparator : this.getComparator();
    }

    @Override
    public Column getColumn(ByteBuffer name) {
        int pos = this.binarySearch(name);
        return pos >= 0 ? this.columns.get(pos) : null;
    }

    @Override
    public void addColumn(Column column, Allocator allocator) {
        if (this.columns.isEmpty()) {
            this.columns.add(column);
            return;
        }
        int c = this.internalComparator().compare(this.columns.get(this.getColumnCount() - 1).name(), column.name());
        assert (c <= 0) : "Added column does not sort as the " + (this.reversed ? "first" : "last") + " column";
        if (c < 0) {
            this.columns.add(column);
        } else if (c == 0) {
            this.resolveAgainst(this.getColumnCount() - 1, column, allocator);
        } else {
            int pos = this.binarySearch(column.name());
            if (pos >= 0) {
                this.resolveAgainst(pos, column, allocator);
            } else {
                this.columns.add(-pos - 1, column);
            }
        }
    }

    private void resolveAgainst(int i, Column column, Allocator allocator) {
        Column oldColumn = this.columns.get(i);
        Column reconciledColumn = column.reconcile(oldColumn, allocator);
        this.columns.set(i, reconciledColumn);
    }

    private int binarySearch(ByteBuffer name) {
        return ArrayBackedSortedColumns.binarySearch(this.columns, this.internalComparator(), name, 0);
    }

    private static int binarySearch(List<Column> columns, Comparator<ByteBuffer> comparator, ByteBuffer name, int start) {
        int low = start;
        int mid = columns.size();
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >> 1;
            result = comparator.compare(name, columns.get(mid).name());
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result < 0 ? 1 : 2);
    }

    @Override
    public void addAll(ColumnFamily cm, Allocator allocator, Function<Column, Column> transformation) {
        this.delete(cm.deletionInfo());
        if (cm.getColumnCount() == 0) {
            return;
        }
        Column[] copy = this.columns.toArray(new Column[this.getColumnCount()]);
        int idx = 0;
        Iterator<Column> other = this.reversed ? cm.reverseIterator(ColumnSlice.ALL_COLUMNS_ARRAY) : cm.iterator();
        Column otherColumn = other.next();
        this.columns.clear();
        while (idx < copy.length && otherColumn != null) {
            int c = this.internalComparator().compare(copy[idx].name(), otherColumn.name());
            if (c < 0) {
                this.columns.add(copy[idx]);
                ++idx;
                continue;
            }
            if (c > 0) {
                this.columns.add((Column)transformation.apply((Object)otherColumn));
                otherColumn = other.hasNext() ? other.next() : null;
                continue;
            }
            this.columns.add(copy[idx]);
            this.resolveAgainst(this.getColumnCount() - 1, (Column)transformation.apply((Object)otherColumn), allocator);
            ++idx;
            otherColumn = other.hasNext() ? other.next() : null;
        }
        while (idx < copy.length) {
            this.columns.add(copy[idx++]);
        }
        while (otherColumn != null) {
            this.columns.add((Column)transformation.apply((Object)otherColumn));
            otherColumn = other.hasNext() ? other.next() : null;
        }
    }

    @Override
    public boolean replace(Column oldColumn, Column newColumn) {
        if (!oldColumn.name().equals(newColumn.name())) {
            throw new IllegalArgumentException();
        }
        int pos = this.binarySearch(oldColumn.name());
        if (pos >= 0) {
            this.columns.set(pos, newColumn);
        }
        return pos >= 0;
    }

    @Override
    public Collection<Column> getSortedColumns() {
        return this.reversed ? new ReverseSortedCollection() : this.columns;
    }

    @Override
    public Collection<Column> getReverseSortedColumns() {
        return this.reversed ? new ForwardSortedCollection() : new ReverseSortedCollection();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public void clear() {
        this.setDeletionInfo(DeletionInfo.live());
        this.columns.clear();
    }

    @Override
    public Iterable<ByteBuffer> getColumnNames() {
        return Iterables.transform(this.columns, (Function)new Function<Column, ByteBuffer>(){

            public ByteBuffer apply(Column column) {
                return column.name;
            }
        });
    }

    @Override
    public Iterator<Column> iterator() {
        return this.reversed ? Lists.reverse(this.columns).iterator() : this.columns.iterator();
    }

    @Override
    public Iterator<Column> iterator(ColumnSlice[] slices) {
        return new SlicesIterator(this.columns, this.getComparator(), slices, this.reversed);
    }

    @Override
    public Iterator<Column> reverseIterator(ColumnSlice[] slices) {
        return new SlicesIterator(this.columns, this.getComparator(), slices, !this.reversed);
    }

    private class ForwardSortedCollection
    extends AbstractCollection<Column> {
        private ForwardSortedCollection() {
        }

        @Override
        public int size() {
            return ArrayBackedSortedColumns.this.columns.size();
        }

        @Override
        public Iterator<Column> iterator() {
            return ArrayBackedSortedColumns.this.columns.iterator();
        }
    }

    private class ReverseSortedCollection
    extends AbstractCollection<Column> {
        private ReverseSortedCollection() {
        }

        @Override
        public int size() {
            return ArrayBackedSortedColumns.this.columns.size();
        }

        @Override
        public Iterator<Column> iterator() {
            return new Iterator<Column>(){
                int idx;
                boolean shouldCallNext;
                {
                    this.idx = ReverseSortedCollection.this.size() - 1;
                    this.shouldCallNext = true;
                }

                @Override
                public boolean hasNext() {
                    return this.idx >= 0;
                }

                @Override
                public Column next() {
                    this.shouldCallNext = false;
                    return (Column)ArrayBackedSortedColumns.this.columns.get(this.idx--);
                }

                @Override
                public void remove() {
                    if (this.shouldCallNext) {
                        throw new IllegalStateException();
                    }
                    ArrayBackedSortedColumns.this.columns.remove(this.idx + 1);
                    this.shouldCallNext = true;
                }
            };
        }
    }

    private static class SlicesIterator
    extends AbstractIterator<Column> {
        private final List<Column> list;
        private final ColumnSlice[] slices;
        private final Comparator<ByteBuffer> comparator;
        private int idx = 0;
        private int previousSliceEnd = 0;
        private Iterator<Column> currentSlice;

        public SlicesIterator(List<Column> list, AbstractType<?> comparator, ColumnSlice[] slices, boolean reversed) {
            this.list = reversed ? Lists.reverse(list) : list;
            this.slices = slices;
            this.comparator = reversed ? comparator.reverseComparator : comparator;
        }

        protected Column computeNext() {
            if (this.currentSlice == null) {
                int finishIdx;
                int startIdx;
                if (this.idx >= this.slices.length) {
                    return (Column)this.endOfData();
                }
                ColumnSlice slice = this.slices[this.idx++];
                int n = startIdx = slice.start.remaining() == 0 ? 0 : ArrayBackedSortedColumns.binarySearch(this.list, this.comparator, slice.start, this.previousSliceEnd);
                if (startIdx < 0) {
                    startIdx = -startIdx - 1;
                }
                int n2 = finishIdx = slice.finish.remaining() == 0 ? this.list.size() - 1 : ArrayBackedSortedColumns.binarySearch(this.list, this.comparator, slice.finish, this.previousSliceEnd);
                finishIdx = finishIdx >= 0 ? ++finishIdx : -finishIdx - 1;
                this.currentSlice = startIdx == 0 && finishIdx == this.list.size() ? this.list.iterator() : this.list.subList(startIdx, finishIdx).iterator();
                int n3 = this.previousSliceEnd = finishIdx > 0 ? finishIdx - 1 : 0;
            }
            if (this.currentSlice.hasNext()) {
                return this.currentSlice.next();
            }
            this.currentSlice = null;
            return this.computeNext();
        }
    }
}

