/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Collection;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;

public class LeveledCompactionTask
extends CompactionTask {
    private final int level;
    private final long maxSSTableBytes;

    public LeveledCompactionTask(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int level, int gcBefore, long maxSSTableBytes) {
        super(cfs, sstables, gcBefore);
        this.level = level;
        this.maxSSTableBytes = maxSSTableBytes;
    }

    @Override
    protected boolean newSSTableSegmentThresholdReached(SSTableWriter writer) {
        return writer.getOnDiskFilePointer() > this.maxSSTableBytes;
    }

    @Override
    protected boolean partialCompactionsAcceptable() {
        return false;
    }

    @Override
    protected int getLevel() {
        return this.level;
    }
}

