/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j;

import org.olap4j.Cell;
import org.olap4j.metadata.Property;
import org.pentaho.reporting.engine.classic.core.wizard.ConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class MDXMetaDataCellAttributes
implements DataAttributes {
    private static final String[] NAMESPACES = new String[]{"http://reporting.pentaho.org/namespaces/engine/meta-attributes/mdx"};
    private static final String[] PROPERTIES = new String[]{"CELL_EVALUATION_LIST", "CELL_ORDINAL", "FORMATTED_VALUE", "NON_EMPTY_BEHAVIOR", "SOLVE_ORDER", "VALUE", "DATATYPE", "ACTION_TYPE", "UPDATEABLE", "BACK_COLOR", "FORE_COLOR", "FONT_FLAGS", "FONT_SIZE", "FONT_NAME", "FORMAT_STRING", "LANGUAGE"};
    private DataAttributes backend;
    private Cell cell;

    public MDXMetaDataCellAttributes(DataAttributes backend, Cell cell) {
        if (cell == null) {
            throw new NullPointerException();
        }
        if (backend == null) {
            throw new NullPointerException();
        }
        this.cell = cell;
        this.backend = backend;
    }

    public String[] getMetaAttributeDomains() {
        String[] backendDomains = this.backend.getMetaAttributeDomains();
        return StringUtils.merge((String[])NAMESPACES, (String[])backendDomains);
    }

    public String[] getMetaAttributeNames(String domainName) {
        if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/mdx".equals(domainName)) {
            return (String[])PROPERTIES.clone();
        }
        return this.backend.getMetaAttributeNames(domainName);
    }

    public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context) {
        return this.getMetaAttribute(domain, name, type, context, null);
    }

    public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context, Object defaultValue) {
        if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/mdx".equals(domain)) {
            try {
                Object attribute = this.cell.getPropertyValue((Property)Property.StandardCellProperty.valueOf((String)name));
                if (attribute == null) {
                    return defaultValue;
                }
                return attribute;
            }
            catch (IllegalArgumentException e) {
                return defaultValue;
            }
        }
        return this.backend.getMetaAttribute(domain, name, type, context, defaultValue);
    }

    public Object clone() throws CloneNotSupportedException {
        MDXMetaDataCellAttributes attributes = (MDXMetaDataCellAttributes)super.clone();
        attributes.backend = (DataAttributes)this.backend.clone();
        return attributes;
    }

    public ConceptQueryMapper getMetaAttributeMapper(String domain, String name) {
        return DefaultConceptQueryMapper.INSTANCE;
    }
}

