/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.olap4j.OlapConnection;
import org.olap4j.OlapWrapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.OlapConnectionProvider;

public class DriverConnectionProvider
implements OlapConnectionProvider {
    private Properties properties = new Properties();
    private String url;
    private String driver;

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Object setProperty(String key, String value) {
        if (value == null) {
            return this.properties.remove(key);
        }
        return this.properties.setProperty(key, value);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @Override
    public OlapConnection createConnection(String user, String password) throws SQLException {
        Connection connection;
        if (this.url == null) {
            throw new NullPointerException("URL must not be null when connecting");
        }
        try {
            if (this.driver != null) {
                Class.forName(this.driver);
            }
        }
        catch (Throwable e) {
            throw new SQLException("Unable to load the driver: " + this.driver, e.getMessage());
        }
        Properties p = new Properties();
        for (String entryKey : this.properties.stringPropertyNames()) {
            if (this.isFilteredKey(entryKey)) continue;
            p.setProperty(entryKey, this.properties.getProperty(entryKey));
        }
        if (user != null) {
            p.setProperty("user", user);
        }
        if (password != null) {
            p.setProperty("password", password);
        }
        if ((connection = DriverManager.getConnection(this.url, p)) instanceof OlapConnection) {
            return (OlapConnection)connection;
        }
        if (connection instanceof OlapWrapper) {
            OlapWrapper wrapper = (OlapWrapper)connection;
            OlapConnection olapConnection = (OlapConnection)wrapper.unwrap(OlapConnection.class);
            if (olapConnection == null) {
                throw new SQLException("Unable to unwrap the connection: " + this.driver);
            }
            return olapConnection;
        }
        throw new SQLException("Unable to unwrap the connection: " + this.driver);
    }

    private boolean isFilteredKey(String key) {
        return key.startsWith("::");
    }

    public String[] getPropertyNames() {
        return this.properties.stringPropertyNames().toArray(new String[this.properties.size()]);
    }

    @Override
    public Object getConnectionHash() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getClass().getName());
        list.add(this.properties.clone());
        list.add(this.url);
        list.add(this.driver);
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverConnectionProvider that = (DriverConnectionProvider)o;
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.properties.equals(that.properties)) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.properties != null ? this.properties.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.driver != null ? this.driver.hashCode() : 0);
        return result;
    }
}

