/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.solution;

import java.math.BigDecimal;
import java.util.Date;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.util.ParameterHelper;

public abstract class BaseParameterProvider
implements IParameterProvider {
    protected abstract String getValue(String var1);

    public abstract Object getParameter(String var1);

    public String getStringParameter(String name, String defaultValue) {
        return ParameterHelper.parameterToString(this.getValue(name), defaultValue);
    }

    public IPentahoResultSet getListParameter(String name) {
        return (IPentahoResultSet)this.getParameter(name);
    }

    public long getLongParameter(String name, long defaultValue) {
        return ParameterHelper.parameterToLong(this.getValue(name), defaultValue);
    }

    public Date getDateParameter(String name, Date defaultValue) {
        Object value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return ParameterHelper.parameterToDate(this.getValue(name), defaultValue);
    }

    public BigDecimal getDecimalParameter(String name, BigDecimal defaultValue) {
        return ParameterHelper.parameterToDecimal(this.getStringParameter(name, ""), defaultValue);
    }

    public Object[] getArrayParameter(String name, Object[] defaultValue) {
        return ParameterHelper.parameterToObjectArray(this.getParameter(name), defaultValue);
    }

    public String[] getStringArrayParameter(String name, String[] defaultValue) {
        return ParameterHelper.parameterToStringArray(this.getParameter(name), defaultValue);
    }

    public boolean hasParameter(String name) {
        return this.getParameter(name) != null;
    }
}

