/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.engine.core.system.objfac.spring.PublishedBeanRegistry;
import org.pentaho.platform.engine.core.system.objfac.spring.SpringPentahoObjectReference;
import org.pentaho.platform.engine.core.system.objfac.spring.SpringScopeSessionHolder;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractSpringPentahoObjectFactory
implements IPentahoObjectFactory {
    protected ConfigurableApplicationContext beanFactory;
    protected static final Log logger = LogFactory.getLog(AbstractSpringPentahoObjectFactory.class);
    protected static final String PRIORITY = "priority";
    private BeanDefinitionPriorityComparitor priorityComparitor = new BeanDefinitionPriorityComparitor();
    private String name;

    protected AbstractSpringPentahoObjectFactory() {
    }

    protected AbstractSpringPentahoObjectFactory(String name) {
        this.name = name;
    }

    public <T> T get(Class<T> interfaceClass, IPentahoSession session) throws ObjectFactoryException {
        return this.get(interfaceClass, null, session);
    }

    public <T> T get(Class<T> interfaceClass, String key, IPentahoSession session) throws ObjectFactoryException {
        return this.retreiveObject(interfaceClass, key, session, null);
    }

    public <T> T get(Class<T> interfaceClass, IPentahoSession session, Map<String, String> props) throws ObjectFactoryException {
        return this.retreiveObject(interfaceClass, null, session, props);
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        return this.retreiveObjects(interfaceClass, curSession, properties);
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.retreiveObjects(interfaceClass, curSession, null);
    }

    protected Object instanceClass(String simpleName) throws ObjectFactoryException {
        return this.instanceClass(simpleName, null);
    }

    protected Object instanceClass(String simpleName, String key) throws ObjectFactoryException {
        Object object = null;
        try {
            if (this.beanFactory.containsBean(simpleName)) {
                object = this.beanFactory.getType(simpleName).newInstance();
            } else if (key != null) {
                object = this.beanFactory.getType(key).newInstance();
            }
        }
        catch (Exception e) {
            String msg = Messages.getInstance().getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_CREATE_OBJECT", key);
            throw new ObjectFactoryException(msg, (Throwable)e);
        }
        return object;
    }

    protected Object instanceClass(Class<?> interfaceClass, String key) throws ObjectFactoryException {
        Object object = null;
        try {
            String[] beanNames = PublishedBeanRegistry.getBeanNamesForType((ListableBeanFactory)this.beanFactory, interfaceClass);
            if (beanNames.length > 0) {
                ArrayList<BeanDefinitionNamePair> beanDefs = new ArrayList<BeanDefinitionNamePair>();
                for (String name : beanNames) {
                    BeanDefinition ref = this.getBeanDefinitionFromFactory(name);
                    beanDefs.add(new BeanDefinitionNamePair(name, ref));
                }
                Collections.sort(beanDefs, this.priorityComparitor);
                object = this.beanFactory.getType(((BeanDefinitionNamePair)beanDefs.get((int)0)).name).newInstance();
            } else {
                object = key != null ? this.beanFactory.getType(key).newInstance() : this.beanFactory.getType(interfaceClass.getSimpleName()).newInstance();
            }
        }
        catch (Exception e) {
            String msg = Messages.getInstance().getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_CREATE_OBJECT", key);
            throw new ObjectFactoryException(msg, (Throwable)e);
        }
        return object;
    }

    private <T> T retrieveViaSpring(Class<T> interfaceClass) throws ObjectFactoryException {
        return this.retrieveViaSpring(interfaceClass, null);
    }

    private <T> T retrieveViaSpring(Class<T> interfaceClass, Map<String, String> props) throws ObjectFactoryException {
        Object object = null;
        try {
            String[] beanNames = PublishedBeanRegistry.getBeanNamesForType((ListableBeanFactory)this.beanFactory, interfaceClass);
            if (beanNames == null || beanNames.length == 0) {
                beanNames = new String[]{interfaceClass.getSimpleName()};
            }
            ArrayList<BeanDefinitionNamePair> beanDefs = new ArrayList<BeanDefinitionNamePair>();
            for (String name : beanNames) {
                if (!this.beanFactory.getBeanFactory().containsBean(name)) continue;
                BeanDefinition ref = this.getBeanDefinitionFromFactory(name);
                beanDefs.add(new BeanDefinitionNamePair(name, ref));
            }
            if (beanDefs.size() == 0) {
                return null;
            }
            if (props != null && props.size() > 0) {
                Iterator iterator = beanDefs.iterator();
                block3: while (iterator.hasNext()) {
                    BeanDefinition def = ((BeanDefinitionNamePair)iterator.next()).definition;
                    for (Map.Entry<String, String> prop : props.entrySet()) {
                        Object attrVal = def.getAttribute(prop.getKey());
                        if (attrVal != null && attrVal.equals(prop.getValue())) continue;
                        iterator.remove();
                        continue block3;
                    }
                }
            }
            Collections.sort(beanDefs, this.priorityComparitor);
            if (beanDefs.size() == 0) {
                throw new IllegalStateException("No bean found for given type");
            }
            object = this.beanFactory.getBean(((BeanDefinitionNamePair)beanDefs.get((int)0)).name);
        }
        catch (Throwable t) {
            String msg = Messages.getInstance().getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_RETRIEVE_OBJECT", interfaceClass.getSimpleName());
            throw new ObjectFactoryException(msg, t);
        }
        if (!interfaceClass.isAssignableFrom(object.getClass())) {
            throw new IllegalStateException("Object retrived from Spring not expected type: " + interfaceClass.getSimpleName());
        }
        return (T)object;
    }

    private BeanDefinition getBeanDefinitionFromFactory(String name) {
        return this.beanFactory.getBeanFactory().getBeanDefinition(name);
    }

    protected Object retrieveViaSpring(String beanId) throws ObjectFactoryException {
        Object object;
        try {
            object = this.beanFactory.getBean(beanId);
        }
        catch (Throwable t) {
            String msg = Messages.getInstance().getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_RETRIEVE_OBJECT", beanId);
            throw new ObjectFactoryException(msg, t);
        }
        return object;
    }

    private <T> T retreiveObject(Class<T> interfaceClass, String key, IPentahoSession session, Map<String, String> props) throws ObjectFactoryException {
        Object object;
        block6: {
            logger.debug((Object)("Attempting to get an instance of [" + interfaceClass.getSimpleName() + "] while in session [" + session + "]"));
            if (session != null && session instanceof StandaloneSession) {
                SpringScopeSessionHolder.SESSION.set(session);
                try {
                    if (key != null) {
                        object = this.retrieveViaSpring(key);
                        break block6;
                    }
                    object = this.retrieveViaSpring(interfaceClass, props);
                }
                catch (Throwable t) {
                    logger.debug((Object)"Retrieving object from Pentaho session map (not Spring).");
                    object = session.getAttribute(interfaceClass.getSimpleName());
                    if (object == null) {
                        object = this.instanceClass(interfaceClass, key);
                        session.setAttribute(interfaceClass.getSimpleName(), object);
                    }
                    break block6;
                }
            }
            SpringScopeSessionHolder.SESSION.set(null);
            object = key != null ? this.retrieveViaSpring(key) : this.retrieveViaSpring(interfaceClass, props);
        }
        logger.debug((Object)(" Got an instance of [" + interfaceClass.getSimpleName() + "]: " + object));
        if (object instanceof IPentahoInitializer) {
            ((IPentahoInitializer)object).init(session);
        }
        return (T)object;
    }

    /*
     * Unable to fully structure code
     */
    protected <T> List<T> retreiveObjects(Class<T> type, IPentahoSession session, Map<String, String> properties) throws ObjectFactoryException {
        AbstractSpringPentahoObjectFactory.logger.debug((Object)("Attempting to get an instance of [" + type.getSimpleName() + "] while in session [" + session + "]"));
        objects = new ArrayList<Object>();
        if (session != null && session instanceof StandaloneSession) {
            try {
                SpringScopeSessionHolder.SESSION.set(session);
                beanNames = PublishedBeanRegistry.getBeanNamesForType((ListableBeanFactory)this.beanFactory, type);
                beanDefs = new ArrayList<BeanDefinitionNamePair>();
                for (String name : beanNames) {
                    ref = this.getBeanDefinitionFromFactory(name);
                    if (ref == null) continue;
                    beanDefs.add(new BeanDefinitionNamePair(name, ref));
                }
                if (properties != null && properties.size() > 0) {
                    iterator = beanDefs.iterator();
                    block3: while (iterator.hasNext()) {
                        entry = (BeanDefinitionNamePair)iterator.next();
                        def = entry.definition;
                        for (Map.Entry<String, String> prop : properties.entrySet()) {
                            attrVal = def.getAttribute(prop.getKey());
                            if (attrVal != null && attrVal.equals(prop.getValue())) continue;
                            iterator.remove();
                            continue block3;
                        }
                    }
                }
                Collections.sort(beanDefs, this.priorityComparitor);
                for (BeanDefinitionNamePair defPair : beanDefs) {
                    objects.add(this.beanFactory.getBean(defPair.name));
                }
            }
            catch (Throwable t) {
                AbstractSpringPentahoObjectFactory.logger.debug((Object)"Retrieving object from Pentaho session map (not Spring).");
                object = session.getAttribute(type.getSimpleName());
                if (object != null) ** GOTO lbl43
                object = this.instanceClass(type.getSimpleName());
                session.setAttribute(type.getSimpleName(), object);
            }
        } else {
            object = this.retrieveViaSpring(type);
            if (object != null) {
                objects.add(object);
                AbstractSpringPentahoObjectFactory.logger.debug((Object)(" Got an instance of [" + type.getSimpleName() + "]: " + object));
            }
        }
lbl43:
        // 6 sources

        SpringScopeSessionHolder.SESSION.set(null);
        return objects;
    }

    public boolean objectDefined(String key) {
        return this.beanFactory.containsBean(key);
    }

    public boolean objectDefined(Class<?> clazz) {
        boolean found;
        boolean bl = found = PublishedBeanRegistry.getBeanNamesForType((ListableBeanFactory)this.beanFactory, clazz).length > 0;
        if (!found) {
            found = this.beanFactory.containsBean(clazz.getSimpleName());
        }
        return found;
    }

    public Class getImplementingClass(String key) {
        return this.beanFactory.getType(key);
    }

    protected void setBeanFactory(ConfigurableApplicationContext context) {
        this.beanFactory = context;
    }

    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> clazz, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getObjectReference(clazz, curSession, null);
    }

    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> clazz, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        SpringScopeSessionHolder.SESSION.set(curSession);
        String[] beanNames = PublishedBeanRegistry.getBeanNamesForType((ListableBeanFactory)this.beanFactory, clazz);
        if (beanNames.length == 0) {
            beanNames = new String[]{clazz.getSimpleName()};
        }
        ArrayList<BeanDefinitionNamePair> refs = new ArrayList<BeanDefinitionNamePair>();
        for (String name : beanNames) {
            if (!this.beanFactory.getBeanFactory().containsBean(name)) continue;
            BeanDefinition ref = null;
            try {
                ref = this.getBeanDefinitionFromFactory(name);
                refs.add(new BeanDefinitionNamePair(name, ref));
            }
            catch (NoSuchBeanDefinitionException nsb) {
                String[] aliases = this.beanFactory.getBeanFactory().getAliases(name);
                if (aliases.length <= 0) continue;
                try {
                    ref = this.getBeanDefinitionFromFactory(aliases[0]);
                    refs.add(new BeanDefinitionNamePair(aliases[0], ref));
                }
                catch (NoSuchBeanDefinitionException e) {
                    logger.debug((Object)("Unable to find bean definition for name:" + name + " it likely exists in a parent BeanFactory"));
                }
            }
        }
        if (refs.size() == 0) {
            return null;
        }
        if (properties != null && properties.size() > 0) {
            Iterator iterator = refs.iterator();
            block5: while (iterator.hasNext()) {
                BeanDefinitionNamePair entry = (BeanDefinitionNamePair)iterator.next();
                BeanDefinition def = entry.definition;
                for (Map.Entry<String, String> prop : properties.entrySet()) {
                    Object attrVal = def.getAttribute(prop.getKey());
                    if (attrVal != null && attrVal.equals(prop.getValue())) continue;
                    iterator.remove();
                    continue block5;
                }
            }
        }
        if (refs.size() == 0) {
            return null;
        }
        Collections.sort(refs, this.priorityComparitor);
        BeanDefinition def = ((BeanDefinitionNamePair)refs.get((int)0)).definition;
        String name = ((BeanDefinitionNamePair)refs.get((int)0)).name;
        SpringScopeSessionHolder.SESSION.set(null);
        return new SpringPentahoObjectReference<T>(this.beanFactory, name, clazz, curSession, def);
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getObjectReferences(interfaceClass, curSession, null);
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        String[] beanNames = PublishedBeanRegistry.getBeanNamesForType((ListableBeanFactory)this.beanFactory, interfaceClass);
        if (beanNames == null || beanNames.length == 0) {
            return null;
        }
        ArrayList<IPentahoObjectReference<T>> collection = new ArrayList<IPentahoObjectReference<T>>();
        ArrayList<BeanDefinitionNamePair> refs = new ArrayList<BeanDefinitionNamePair>();
        for (String name : beanNames) {
            BeanDefinition ref = this.getBeanDefinitionFromFactory(name);
            refs.add(new BeanDefinitionNamePair(name, ref));
        }
        if (properties != null && properties.size() > 0) {
            Iterator iterator = refs.iterator();
            block1: while (iterator.hasNext()) {
                BeanDefinitionNamePair entry = (BeanDefinitionNamePair)iterator.next();
                BeanDefinition def = entry.definition;
                for (Map.Entry<String, String> prop : properties.entrySet()) {
                    Object attrVal = def.getAttribute(prop.getKey());
                    if (attrVal != null && attrVal.equals(prop.getValue())) continue;
                    iterator.remove();
                    continue block1;
                }
            }
        }
        Collections.sort(refs, this.priorityComparitor);
        for (BeanDefinitionNamePair ref : refs) {
            String name;
            BeanDefinition def = ref.definition;
            name = ref.name;
            SpringPentahoObjectReference<T> sRef = new SpringPentahoObjectReference<T>(this.beanFactory, name, interfaceClass, curSession, def);
            collection.add(sRef);
        }
        return collection;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.beanFactory.getBeanFactory().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractSpringPentahoObjectFactory)) {
            return false;
        }
        AbstractSpringPentahoObjectFactory that = (AbstractSpringPentahoObjectFactory)o;
        return this.beanFactory.equals(that.beanFactory);
    }

    protected static class BeanDefinitionNamePair {
        public String name;
        public BeanDefinition definition;

        public BeanDefinitionNamePair(String name, BeanDefinition definition) {
            this.definition = definition;
            this.name = name;
        }
    }

    protected class BeanDefinitionPriorityComparitor
    implements Comparator<BeanDefinitionNamePair> {
        protected BeanDefinitionPriorityComparitor() {
        }

        @Override
        public int compare(BeanDefinitionNamePair beanDefinitionNamePair, BeanDefinitionNamePair beanDefinitionNamePair1) {
            int pri2;
            int pri1 = this.computePriority(beanDefinitionNamePair.definition);
            if (pri1 == (pri2 = this.computePriority(beanDefinitionNamePair1.definition))) {
                return 0;
            }
            if (pri1 < pri2) {
                return 1;
            }
            return -1;
        }

        private int computePriority(BeanDefinition ref) {
            if (ref == null || ref.getAttribute(AbstractSpringPentahoObjectFactory.PRIORITY) == null) {
                return 0;
            }
            try {
                int val = Integer.parseInt(ref.getAttribute(AbstractSpringPentahoObjectFactory.PRIORITY).toString());
                return val;
            }
            catch (NumberFormatException e) {
                logger.error((Object)("bean of type " + ref.getBeanClassName() + " has an invalid priority value, only numeric allowed"));
                return 0;
            }
        }
    }
}

